/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.Serializable;

/** 
 *  [<code>AmountData</code>]<br>
 *  Hold calculated data
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class AmountData implements Serializable {

    static final long serialVersionUID = 6231369687382986087L;

    protected long creditAmount,debitAmount;

    public AmountData() {
	creditAmount = 0;debitAmount = 0;
    }
    
    public AmountData(long creditAmount,long debitAmount) {
	this.creditAmount = creditAmount;
	this.debitAmount = debitAmount;
    }

    public long getCreditAmount() {
	return creditAmount;
    }

    public void addCreditAmount(long c) {
	creditAmount += c;
    }

    public long getDebitAmount() {
	return debitAmount;
    }

    public void addDebitAmount(long a) {
	debitAmount += a;
    }

    public void add(AmountData a) {
	addCreditAmount(a.getCreditAmount());
	addDebitAmount(a.getDebitAmount());
    }

    public void sub(AmountData a) {
	addCreditAmount(-a.getCreditAmount());
	addDebitAmount(-a.getDebitAmount());
    }

    public String toString() {
	return 
	    "AmountData: CR:"+getCreditAmount()+
	    "  DR: "+getDebitAmount();
    }
}
