/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>AnnualData</code>]<br>
 *  Manage annual data (initial and current amount)
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class AnnualData implements NumberIdentical, Serializable {

    static final long serialVersionUID = -6770198245155884431L;

    transient ProjectData parent;
    int year ;
    Date startedDate=null, closedDate=null;
    List currentMoneys = new ArrayList();
    List initialMoneys = new ArrayList();

    public AnnualData(ProjectData p,int year) {
	parent = p;
	setYear(year);
	startedDate = new Date();
	sync();
    }

    // copy constructor
    protected AnnualData(AnnualData ad,ProjectData copyParent) {
	parent = copyParent;
	setYear(ad.getYear());
	startedDate = ad.getStartedDate();
	//copy contents
	for (int i=0;i<ad.initialMoneys.size();i++) {
	    SubjectMoney sm = (SubjectMoney)ad.initialMoneys.get(i);
	    initialMoneys.add( sm.getCopy(this) );
	    SubjectCurrentMoney cm = 
		(SubjectCurrentMoney)ad.currentMoneys.get(i);
	    currentMoneys.add( cm.getCopy(this) );
	}
    }

    public ProjectData getParent() {return parent;}
    public void setParent(ProjectData pd) {parent = pd;}

    public int getId() {return getYear();}

    public void setYear(int a) { year = a; }
    public int getYear() { return year; }
    public Date getStartedDate() {return startedDate;}
    public Date getClosedDate() {return closedDate;}
    public void setStartedDate(Date d) {startedDate = d;}
    public void setClosedDate(Date d) {closedDate = d;}

    public void prepareNextYear(AnnualData prevYear) {
	
    }

    public AnnualData getCopy(ProjectData copyParent) {
	AnnualData copy = new AnnualData(this, copyParent);
	return copy;
    }

    /** 
     * correspond subjects to project data.
     */
    public void sync() {
	List nextCurrent = new ArrayList();
	List nextInit = new ArrayList();
	Iterator it = getParent().getSubjects().iterator();
	while(it.hasNext()){
	    Subject sx = (Subject)it.next();
            int id = sx.getId();
	    SubjectMoney sm = getInitialMoney(id);
	    SubjectMoney nsm = 
		AnnualSubjectFactory.getSubjectMoney(this,sx,sm);
	    nextInit.add(nsm);
	    SubjectCurrentMoney scm = getCurrentMoney(id);
	    SubjectCurrentMoney nscm = 
		AnnualSubjectFactory.getSubjectCurrentMoney(this,sx,scm);
	    nextCurrent.add(nscm);
	}
	initialMoneys = nextInit;
	currentMoneys = nextCurrent;
	Collections.sort(initialMoneys,IdComparator.getInstance());
	Collections.sort(currentMoneys,IdComparator.getInstance());
    }

    public List getInitialMoneys() {return initialMoneys;}
    public List getCurrentMoneys() {return currentMoneys;}

    public SubjectMoney getInitialMoney(int sid) {
	return (SubjectMoney)IdComparator.search(initialMoneys,sid);
    }
    public SubjectCurrentMoney getCurrentMoney(int sid) {
	return (SubjectCurrentMoney)IdComparator.search(currentMoneys,sid);
    }

    public String toString() {
	return getClass().getName()+": INI:"+initialMoneys.size()
	    +"  CUR:"+currentMoneys.size()+"  :"+getStartedDate();
    }
}

class AnnualSubjectFactory {

    static SubjectMoney getSubjectMoney(AnnualData p,Subject sx,SubjectMoney sm) {
	SubjectMoney cm = null;
	switch (sx.getSpecialLabel()) {
	case Subject.CAPITAL_LABEL:
	    cm = new SubjectMoney_Capital(p,sx);
	    break;
	case Subject.DEPRECIATION_LABEL:
	    //not implemented
	case Subject.NORMAL_LABEL:
	default:
	    cm = new SubjectMoney(p,sx);
	    if (sm != null)
		cm.setMoney(sm.getMoney());	
	}
	return cm;
    }

    static SubjectCurrentMoney getSubjectCurrentMoney(
	AnnualData p,Subject sx,
	SubjectCurrentMoney sm) {

	SubjectCurrentMoney cm = null;
	switch (sx.getSpecialLabel()) {
	case Subject.CAPITAL_LABEL:
	    cm = new SubjectCurrentMoney_Capital(p,sx);
	    break;
	case Subject.DEPRECIATION_LABEL:
	    //not implemented
	case Subject.NORMAL_LABEL:
	default:
	    cm = new SubjectCurrentMoney(p,sx);
	}
	return cm;
    }

}
