/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.Serializable;

/** 
 *  [<code>CurrentAmountData</code>]<br>
 *  Hold calculated data
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class CurrentAmountData extends AmountData implements Serializable {

    static final long serialVersionUID = -1107731477892617106L;    

    protected long currentAmount;

    public CurrentAmountData() {
	currentAmount = 0;
    }
    
    public CurrentAmountData(long creditAmount,
			     long debitAmount,
			     long currentAmount) {
	this.creditAmount = creditAmount;
	this.debitAmount = debitAmount;
	this.currentAmount = currentAmount;
    }

    public CurrentAmountData(AmountData a,long currentAmount) {
	this.creditAmount = a.creditAmount;
	this.debitAmount = a.debitAmount;
	this.currentAmount = currentAmount;
    }

    public long getCurrentAmount() {
	return currentAmount;
    }

    public void addCurrentAmount(long a) {
	currentAmount += a;
    }

    public void add(CurrentAmountData a) {
	super.add(a);
	addCurrentAmount(a.getCurrentAmount());
    }

    public void sub(CurrentAmountData a) {
	super.sub(a);
	addCurrentAmount(-a.getCurrentAmount());
    }

    public String toString() {
	return 
	    "CurrentAmountData: CR:"+getCreditAmount()+
	    "  DR: "+getDebitAmount()+
	    "  CUR: "+getCurrentAmount();
    }
}
