/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>GroupData</code>]<br>
 *  Manage group data
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class GroupData implements NumberIdentical,Serializable{
    static final long serialVersionUID = 4925475959722616137L;

    int gid ;
    String name ;
    String comment ;
    List users = new ArrayList();
    List rprojects = new ArrayList();
    List wprojects = new ArrayList();
    List eprojects = new ArrayList();
    List sprojects = new ArrayList();
    // automation
    List [] accesses = {rprojects,wprojects,eprojects,sprojects};
    public static int  [] masks = {
	SecurityManager.READABLE,
	SecurityManager.WRITABLE,
	SecurityManager.EDITABLE,
	SecurityManager.SETTLABLE};
    public static String [] resourceStrings = {"Readable","Writable","EditSubject","SettleAccount"};

    public GroupData(String n,String c,int id) {
	setName(n);
	setComment(c);
	gid = id;
    }

    public int getId() {return gid;}

    public void setName(String a) { name = a; }
    public String getName() { return name; }
    public String toString() { return getName();}

    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }

    /**
     * [<code>addUser</code>]
     *  
     * @param uid user id
     */ 
    public void addUser(int uid) {
	IdElement e = (IdElement)(IdComparator.search(users,uid));
	if (e == null) {
	    users.add(new IdElement(uid));
	    Collections.sort(users,IdComparator.getInstance());
	}
    }

    public void removeUser(int uid) {
	if (uid == 0 && getId() == 0) return;//removing admin from admin group
	//
	IdElement e = (IdElement)(IdComparator.search(users,uid));
	if (e != null) 
	    users.remove(e);
    }

    /**
     * [<code>setProject</code>]
     *  
     * @param pid project id
     * @param tasks access permission (READABLE,WRITABLE,EDITABLE and SETTLABLE,
     * you can specify some access permission by adding each them. 
     * Ex. READBLE+WRITABLE )
     */ 
    public void setProject(int pid,int tasks) {
	for (int i=0;i<accesses.length;i++)
	    setProjectPermission(pid,tasks,masks[i],accesses[i]);
    }

    private void setProjectPermission(int pid,int tasks,
				      int mask, List projects) {
	IdElement tp = (IdElement)(IdComparator.search(projects,pid));
	if ( (mask & tasks) != 0) {
	    if (tp == null) {
		projects.add(new IdElement(pid));
		Collections.sort( projects ,IdComparator.getInstance());
	    }
	} else {
	    if (tp != null) {
		projects.remove(tp);
		Collections.sort( projects ,IdComparator.getInstance());
	    }
	}
    }

    /**
     * [<code>getPermission</code>]
     *  
     * @param uid user id
     * @param pid project id
     * @param task READABLE,WRITABLE,EDITABLE and SETTLABLE
     * @return if true, allow the operation.
     */ 
    boolean getPermission(int uid, int pid,int task) {
	IdElement user = (IdElement)(IdComparator.search(users,uid));
	if (user == null) return false;
	//
	if (getId() == 0)//admin group 
	    return true;
	//
	return isPermitted(pid,task);
    }

    //===( utility )======

    /** return NumberIdentical objects */
    public List getUsers() {return users;}
    public boolean isPermitted(int pid,int task) {
	if (getId() == 0) return true;//admin group
	for (int i=0;i<accesses.length;i++) {
	    if (task == masks[i]) {
		if (IdComparator.search(accesses[i],pid) != null)
		    return true;
	    }
	}
	return false;
    }

    /** check whether one is belonging to this group or not. */
    public boolean isBelonging(int uid) {
	if(IdComparator.search(users,uid) != null) return true;
	return false;
    }
}

class IdElement implements NumberIdentical,Serializable {
    int id;
    IdElement(int i) {
	id = i;
    }
    public int getId() {return id;}
}
