/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>GroupManager</code>]<br>
 *  Manage GroupData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class GroupManager {
    List groups ;
    int curGid = 0;
    SecurityManager parent;

    public GroupManager(SecurityManager p) {
	parent = p;
	groups = new ArrayList();
    }

    public SecurityManager getParent() { return parent; }

    /**
     * [<code>addGroup</code>]
     *  
     * @param name group name
     * @param comment group comment
     * @return group data
     */ 
    public GroupData addGroup(String name,String comment) {
	GroupData g = new GroupData(name,comment,curGid);
	groups.add(g);
	Collections.sort( groups ,IdComparator.getInstance());
	curGid++;
	return g;
    }

    /**
     * [<code>getGroup</code>]
     *  
     * @param gid group id
     * @return group data
     */ 
    public GroupData getGroup(int gid) {
	return (GroupData)(IdComparator.search(groups,gid));
    }

    public List getGroups() {return groups;}

    /**
     * [<code>removeGroup</code>]
     *  
     * @param gid group id
     */ 
    public void removeGroup(int gid) {
	if (gid == 0) {
	    System.out.println("Cannot remove admin group.");
	    return;
	}
	GroupData g = getGroup(gid);
	if (g != null) {
	    groups.remove(g);
	    Collections.sort( groups ,IdComparator.getInstance());
	}
    }

    /**
     * [<code>getPermission</code>]
     *  
     * @param uid user id
     * @param pid project id
     * @param task READABLE,WRITABLE,EDITABLE and SETTLABLE
     * @return if true, allow the operation.
     */ 
    boolean getPermission(int uid, int pid,int task) {
	Iterator it = groups.iterator();
	while(it.hasNext()) {
	    GroupData g = (GroupData)it.next();
	    if (g.getPermission(uid,pid,task))
		return true;
	}
	return false;
    }

    boolean getAdminPermission(int uid) {
	GroupData g = (GroupData)groups.get(0);
	if (g.isBelonging(uid))
	    return true;
	return false;
    }

    //====================
    void loadClasses(List list) {
	Integer it = (Integer)list.get(0);
	curGid = it.intValue();
	groups = (List)list.get(1);
	Collections.sort( groups ,IdComparator.getInstance());
    }
    
    List saveClasses() {
	List list = new LinkedList();
	list.add(new Integer(curGid));
	list.add(groups);
	return list;
    }

    void initByClean() {
	GroupData g = addGroup("Admin group","System Administration Group");
	g.addUser(0);
	System.out.println("Made admin group.");
    }
}
