/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import arg.money.gui.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import jp.gr.java_conf.ccs2.comp.*;

public class MainApp {

    static ShellFactory shellFactory;
    static SystemInfo systemInfo;
    static RuntimeInformation runtime;

    public static void main(String [] args) {
	System.setErr(System.out);
	systemInfo = new SystemInfo();
	shellFactory = new LocalSwingShellFactory();
	runtime = new LocalInformation(shellFactory);
	//
	guiSetup();
    }
    
    static void onLogin() {
	systemInfo.getSessionManager().login(runtime);
    }

    static void onExit() {
	systemInfo.onExit();
    }

    static void guiSetup() {
	final JFrame f = new JFrame("Account system");
	Container root = f.getContentPane();
	BoxLayout b = new BoxLayout(root,BoxLayout.Y_AXIS);
	root.setLayout(b);
	// title picture
	ImageIcon icon = new ImageIcon(
	    systemInfo.getClass().getResource("/arg/money/woods_trees.jpg"));
	while(icon.getImageLoadStatus() == java.awt.MediaTracker.LOADING);
	BufferedCanvas bc = new BufferedCanvas();
	Image img = icon.getImage();
	bc.setBackground(new ImagePainter(img,bc));
	bc.setSize(img.getWidth(bc),img.getHeight(bc));
	root.add(bc);
	//
	JPanel bottom = new JPanel();
	JButton login = new JButton(SystemUtil.getResourceString("Login"));
	login.setIcon(new ImageIcon(
	    systemInfo.getClass().getResource("/toolbarButtonGraphics/development/Host24.gif")));
	bottom.add(login);
	JButton exit = new JButton(SystemUtil.getResourceString("Exit"));
	exit.setIcon(new ImageIcon(
	    systemInfo.getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
	bottom.add(exit);
	root.add(bottom);
	//
	login.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onLogin();
		}});
	exit.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onExit();
		    f.dispose();
		    f.setVisible(false);
		    System.exit(0);
		}});
	f.pack();
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wd = f.getSize();
        f.setLocation( (sd.width-wd.width)/2,(sd.height-wd.height)/2);
	f.setDefaultCloseOperation(f.DO_NOTHING_ON_CLOSE);
	f.show();
    }
}
