/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;

/** 
 *  [<code>ProjectCalculation</code>]<br>
 *  Calculate slips
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class ProjectCalculation {

    SystemInfo system;
    int pid,year;

    public ProjectCalculation(SystemInfo sm,int pid,int year) {
	this.system = sm;
	this.pid = pid;
	this.year = year;
    }

    public ProjectCalculation(SystemInfo sm,int pid) {
	this.system = sm;
	this.pid = pid;
	this.year = getProjectData().getCurYear();
    }

    SlipManager getSlipManager() {
	return system.getSlipManager();
    }

    ProjectData getProjectData() {
	return system.getProjectManager().getProjectData(pid);
    }

    AnnualData getAnnualData() {
	ProjectData pd = getProjectData();
	return pd.getAnnual(year);
    }

    public CurrentAmountData getCurrentAmountDataOfSubject(int sid) {
	return getAnnualData().getCurrentMoney(sid).getAmounts(getSlipManager());
    }

    public long getCurrentAmountOfSubject(int sid) {
	return getAnnualData().getCurrentMoney(sid).getAmounts(getSlipManager()).getCurrentAmount();
    }

    public long getInitialAmountOfSubject(int sid) {
	return getAnnualData().getInitialMoney(sid).getMoney();
    }

    public long getCurrentAmountOfSubjectGroup(int sgid) {
	Iterator it = getProjectData().getSubjects().iterator();
	int amount=0;
	while(it.hasNext()) {
	    Subject s = (Subject)it.next();
	    SubjectGroup sg = getProjectData().getGroupBySubject(s.getId());
	    if (sg.getId() == sgid) {
		amount += getCurrentAmountOfSubject(s.getId());
	    }
	}
	return amount;
    }

    public long getCurrentAmountOfSubjectSubgroup(int ssgid) {
	Iterator it = getProjectData().getSubjects().iterator();
	int amount=0;
	while(it.hasNext()) {
	    Subject s = (Subject)it.next();
	    SubjectSubgroup ssg = getProjectData().getSubgroupBySubject(s.getId());
	    if (ssg.getId() == ssgid) {
		amount += getCurrentAmountOfSubject(s.getId());
	    }
	}
	return amount;
    }

    public long getInitialAmountOfSubjectSubgroup(int ssgid) {
	Iterator it = getProjectData().getSubjects().iterator();
	int amount=0;
	while(it.hasNext()) {
	    Subject s = (Subject)it.next();
	    SubjectSubgroup ssg = getProjectData().getSubgroupBySubject(s.getId());
	    if (ssg.getId() == ssgid) {
		amount += getInitialAmountOfSubject(s.getId());
	    }
	}
	return amount;
    }

    public long getInitialAmountOfSubjectGroup(int sgid) {
	Iterator it = getProjectData().getSubjects().iterator();
	int amount=0;
	while(it.hasNext()) {
	    Subject s = (Subject)it.next();
	    SubjectGroup sg = getProjectData().getGroupBySubject(s.getId());
	    if (sg.getId() == sgid) {
		amount += getInitialAmountOfSubject(s.getId());
	    }
	}
	return amount;
    }
    
}
