/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;
import jp.gr.java_conf.ccs2.io.EasyWriter;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.util.ResourceFile;


/** initialize subjects in given project with some resource file. */
public class ProjectMaker {

    /** initialize the project */
    public static void make(ProjectData project, String resourceFile) {
	ResourceBundle rb = null;
	if (resourceFile == null) resourceFile = "";
	File file = new File(resourceFile);
	if (!file.exists()) {
	    rb = defaultResource();
	} else {
	    rb = ResourceFile.getResourceFile(resourceFile);
	    if (rb == null) {
		String er = "Project resource file["+
		    resourceFile+"] not found...";
		SystemUtil.logMessage(er);
		rb = defaultResource();
	    }
	}
	if (rb == null) {
	    SystemUtil.logMessage("Can not initialize the project ["+project.getName()+"]...");
	    return;
	}
	init(project,rb);
    }

    private static ResourceBundle defaultResource() {
	ResourceBundle resource = null;
	try {
	    resource = ResourceBundle.getBundle("arg.money.defaultProject");
	} catch (MissingResourceException mre) {
	    SystemUtil.logMessage("Default project resource file not found...");
	}
	return resource;
    }

    private static void init(ProjectData project,ResourceBundle resource) {
	String buf = "";
	try {
	    //group
	    buf = resource.getString("root");
	    String [] groups = StringUtil.split(buf);
	    for (int i=0;i<groups.length;i++) {
		String name = groups[i];
		SubjectGroup gx = project.addSubjectGroup(
		    name,getComment(resource,name),
		    getBalanceGroup(resource,name));
		//subgroup
		buf = resource.getString(name);
		String [] subgroups = StringUtil.split(buf);
		for (int j=0;j<subgroups.length;j++) {
		    name = subgroups[j];
		    SubjectSubgroup sgx = project.addSubjectSubgroup(
			name,getComment(resource,name),gx.getId());
		    //subject
		    buf = resource.getString(name);
		    String [] subjects = StringUtil.split(buf);
		    for (int k=0;k<subjects.length;k++) {
			name = subjects[k];
			Subject sx = project.addSubject(
			    name,getComment(resource,name),
			    gx.getId(),sgx.getId());
			sx.setSpecialLabel(getSpecialLabel(resource,name));
		    }
		}
	    }
	} catch(MissingResourceException mre) {
	    SystemUtil.logMessage("Invalid resource file... : "+buf);
	    //mre.printStackTrace();
	} catch(RuntimeException rte) {
	    rte.printStackTrace();
	}
    }

    
    /** name_special=special label */
    private static int getSpecialLabel(ResourceBundle rs,String name) {
	int [] specialValues = SystemUtil.getSpecialValues();
	String [] specialLabels = SystemUtil.getSpecialLabels();
	int ret = Subject.NORMAL_LABEL;
	try {
	    String a = rs.getString(name+"_special");
	    for (int i=0;i<specialValues.length;i++) {
		if (a.compareToIgnoreCase(specialLabels[i]) == 0) {
		    ret = specialValues[i];
		    break;
		}
	    }
	} catch (MissingResourceException e) {}
	return ret;
    }

    /** name@=comment */
    private static String getComment(ResourceBundle rs,String name) {
	String ret = null;
	try {
	    ret = rs.getString(name+"@");
	} catch (MissingResourceException e) {
	    ret = "";
	}
	return ret;
    }

    /** name%=balance group */
    private static int getBalanceGroup(ResourceBundle rs,String name) {
	int [] groupValues = SystemUtil.getBalanceGroupValues();
	String [] groupLabels= SystemUtil.getBalanceGroupLabels();
	int ret = groupValues[0];
	try {
	    String a = rs.getString(name+"_group");
	    for (int i=0;i<groupValues.length;i++) {
		if (a.compareToIgnoreCase(groupLabels[i]) == 0) {
		    ret = groupValues[i];
		    break;
		}
	    }
	} catch (MissingResourceException e) {
	    SystemUtil.logMessage("balance group label : "+name+" not found");
	}
	return ret;
    }

    //=================================

    /** save the project data into resource file */
    public static void save(ProjectData project, String resourceFile) {
	List list = new LinkedList();
	String groups = "root=";

	Iterator it = project.getSubjectGroups().iterator();
	while(it.hasNext()) {
	    SubjectGroup sg = (SubjectGroup)it.next();
	    groups += sg.getName()+" ";
	    list.add(transComment(sg.getName(),sg.getComment()));
	    list.add(transBalanceGroup(sg.getName(),sg.getBalanceGroup()));
	    String subgroups = sg.getName()+"=";

	    Iterator it2 = project.getSubjectSubgroups().iterator();
	    while(it2.hasNext()) {
		SubjectSubgroup ssg = (SubjectSubgroup)it2.next();
		if (ssg.getGroupId() != sg.getId()) continue;
		subgroups += ssg.getName() + " ";
		list.add(transComment(ssg.getName(),ssg.getComment()));
		String subjects = ssg.getName()+"=";
		
		Iterator it3 = project.getSubjects().iterator();
		while(it3.hasNext()) {
		    Subject sb = (Subject)it3.next();
		    if (sb.getSubgroupId() != ssg.getId()) continue;
		    subjects += sb.getName()+" ";
		    list.add(transComment(sb.getName(),sb.getComment()));
		    list.add(transSpecialLabel(sb.getName(),sb.getSpecialLabel()));
		}
		list.add(0,subjects);
		list.add("");
	    }
	    list.add(0,subgroups);
	    list.add("");
	}
	list.add(0,groups);
	list.add(0,"");

	EasyWriter out = new EasyWriter(resourceFile);
	if (!out.isOk()) {
	    String er = "Can not write resource file ["+resourceFile+"]";
	    SystemUtil.logMessage(er);
	    return;
	}
	out.println("#######################");
	out.println("# Project Resource file");
	out.println("# ["+project.getName()+"]");

	it = list.iterator();
	while(it.hasNext()) {
	    out.println(it.next().toString());
	}
	out.close();
    }

    private static String transComment(String name,String com) {
	return name+"@="+com;
    }
    private static String transSpecialLabel(String name,int sp) {
	int [] specialValues = SystemUtil.getSpecialValues();
	String [] specialLabels = SystemUtil.getSpecialLabels();
	for (int i=0;i<specialValues.length;i++) {
	    if (specialValues[i] == sp)
		return name+"_special="+specialLabels[i];
	}
	SystemUtil.logMessage("GSpecial label not found. ["+sp+"]");
	return "";
    }
    private static String transBalanceGroup(String name,int bg) {
	int [] groupValues = SystemUtil.getBalanceGroupValues();
	String [] groupLabels= SystemUtil.getBalanceGroupLabels();
	for (int i=0;i<groupValues.length;i++) {
	    if (groupValues[i] == bg)
		return name+"_group="+groupLabels[i];
	}
	SystemUtil.logMessage("Group label not found. ["+bg+"]");
	return "";
    }
}
