/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;
import arg.money.gui.*;
import javax.swing.*;
import java.awt.*;
import java.util.List;

/** 
 *  [<code>SessionData</code>]<br>
 *  Manage session information
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SessionData implements NumberIdentical,Serializable {

    int sessionId ;
    int uid ;
    Date date ;
    RuntimeInformation runtimeInfo;
    transient SessionManager parent;
    transient UserShell shell;

    //===( Constructor )====================
    
    public SessionData(int u,int s,SessionManager p,RuntimeInformation rt) {
	sessionId = s;
	parent = p;
	uid = u;
	date = new Date();
	runtimeInfo = rt;
    }

    //===( Operation )====================

    /** called in log-in sequence  */
    void startup() {
	shell = runtimeInfo.getShellFactory().getUserShell(this);
	shell.show();
    }

    /** called by shell when need to close the session. */
    public void terminate() {
	if (shell != null)
	    shell.close();
	parent.removeSession(getId());
    }

    public void updateData(int pid) {
	shell.update(pid);
    }

    //===( Access )====================

    public int getId() {return sessionId;}
    public int getUid() { return uid; }
    public UserData getUser() {
	try {
	    return getParent().getParent().
		getSecurityManager().getUserManager().getUser(getUid());
	} catch ( RuntimeException e ) {
	    e.printStackTrace();
	}
	return null;
    }
    public Date getDate() { return date; }
    public SessionManager getParent() {return parent;}
    public RuntimeInformation getRuntimeInformation() {
	return runtimeInfo;
    }
}
