/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;

/** 
 *  [<code>SlipElement</code>]<br>
 *  Manage an information that has money and subject id
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SlipElement implements java.io.Serializable{

    static final long serialVersionUID = 8299645645608940433L;

    int sid ;
    long money ;

    public SlipElement(int id,long m) {
	setId(id);
	setMoney(m);
    }
    public String toString() {
	return Integer.toString(sid)+":"+Long.toString(money);
    }

    public void setMoney(long a) { money = a; }
    public long getMoney() { return money; }

    public int getId() {return sid;}
    public void setId(int id) {sid = id;}

    public SlipElement getCopy() {
	return new SlipElement(getId(),getMoney());
    }
}
