/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>Subject</code>]<br>
 *  Manage subject data
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class Subject implements NumberIdentical, Serializable, NameCommentObject{

    //Special label of Subjects
    public static final int NORMAL_LABEL   = 0;//ʂ̉Ȗ
    public static final int CAPITAL_LABEL = 1;//iYƕvZj
    public static final int DEPRECIATION_LABEL  = 2;//p
    public static final int GROUP_TRANSACTION_LABEL = 3;//O[v
    
    static final long serialVersionUID = 6126270599398235535L;

    int sid ;
    int groupId ;
    int subgroupId ;
    String name ;
    String comment ;
    int specialLabel = Subject.NORMAL_LABEL;

    public Subject(int sd,int gid, int sgid, String s,String c) {
	sid = sd;
	setGroupId(gid);
	setSubgroupId(sgid);
	setName(s);
	setComment(c);
    }

    public int getId() { return sid;}

    public void setGroupId(int a) { groupId = a; }
    public int getGroupId() { return groupId; }

    public void setSubgroupId(int a) { subgroupId = a; }
    public int getSubgroupId() { return subgroupId; }

    public void setName(String a) { name = a; }
    public String getName() { return name; }
    public String toString() { return getName();}

    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }

    public int getSpecialLabel() {return specialLabel;}
    public void setSpecialLabel(int i) { specialLabel = i;}

    public Subject getCopy() {
	Subject copy = new Subject(getId(),getGroupId(),getSubgroupId(),
				   getName(),getComment());
	copy.setSpecialLabel(getSpecialLabel());
	return copy;
    }
}
