/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  Manage  current money in AnnualData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectCurrentMoney  implements NumberIdentical,Serializable  {

    static final long serialVersionUID = 4332927089652257543L;

    Date lastCalculated = new Date();
    CurrentAmountData amount;

    int sid ;
    AnnualData parent;

    public SubjectCurrentMoney(AnnualData p,Subject s) {
	parent = p;
	sid = s.getId();
    }
    protected SubjectCurrentMoney(SubjectCurrentMoney sm,
				  AnnualData copyParent) {
	parent = copyParent;
	sid = sm.getId();
    }


    public int getId() {return sid;}

    public CurrentAmountData getAmounts(SlipManager manager) {
	ProjectData pd = parent.getParent();
	Date genDate = manager.getLastModified(parent.getYear(),pd.getId());
	if (genDate.after(lastCalculated) || amount == null) {
	    amount = calculate(pd,manager);
	    lastCalculated.setTime(System.currentTimeMillis());
	}
	return amount;
    }

    public long getCreditAmount(SlipManager manager) {
	return getAmounts(manager).getCreditAmount();
    }

    public long getDebitAmount(SlipManager manager) {
	return getAmounts(manager).getDebitAmount();
    }

    public long getCurrentAmount(SlipManager manager) {
	return getAmounts(manager).getCurrentAmount();
    }
    
    protected CurrentAmountData calculate(ProjectData project,
					  SlipManager manager) {
	return project.calculate(manager,parent.getYear(),sid);
    }

    public String toString() {
	return getClass().getName()+":"+sid+"   money:"+amount;
    }

    public SubjectCurrentMoney getCopy(AnnualData copyParent) {
	SubjectCurrentMoney sm = new SubjectCurrentMoney(this,copyParent);
	return sm;
    }
}
