/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  Manage initial capital money in AnnualData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectCurrentMoney_Capital extends SubjectCurrentMoney {

    static final long serialVersionUID = 2394022524896972489L;

    public SubjectCurrentMoney_Capital(AnnualData p,Subject s) {
	super(p,s);
    }
    protected SubjectCurrentMoney_Capital(SubjectCurrentMoney_Capital sc,
					  AnnualData copyParent) {
	super(sc,copyParent);
    }

    protected CurrentAmountData calculate(ProjectData project,
					  SlipManager manager) {
	Iterator it = project.getSubjects().iterator();
	CurrentAmountData assets = new CurrentAmountData();
	CurrentAmountData debt = new CurrentAmountData();
	CurrentAmountData captal = new CurrentAmountData();
	while(it.hasNext()) {
	    Subject sb = (Subject)it.next();
	    SubjectCurrentMoney sm = parent.getCurrentMoney(sb.getId());
	    if (sm == null) {
		//SystemUtil.logMessage(sb.getName()+" : SubjectCurrentMoney not found : in SCM_Capital. ["+project.getName()+":"+parent.getYear()+"]");
		continue;
	    }
	    SubjectGroup sg = parent.getParent().getGroupBySubject(sm.getId());
	    if (sg == null) {
		SystemUtil.logMessage(
		    "SubjectGroup not found : in SubjectMoney_Capital");
		continue;
	    }
	    if (sg.getBalanceGroup() == SubjectGroup.ASSETS) {
		assets.add(sm.getAmounts(manager) );
	    }
	    if (sg.getBalanceGroup() == SubjectGroup.DEBT) {
		debt.add( sm.getAmounts(manager) );
	    }
	    if (sg.getBalanceGroup() == SubjectGroup.CAPITAL) {
		if (sb.getSpecialLabel() != sb.CAPITAL_LABEL) {
		    captal.add( sm.getAmounts(manager) );
		}
	    }
	}
	CurrentAmountData rets = new CurrentAmountData();
	rets.add( assets );
	rets.sub( debt );
	rets.sub( captal );
	return rets;
    }

    public SubjectCurrentMoney getCopy(AnnualData copyParent) {
	SubjectCurrentMoney_Capital sc = 
	    new SubjectCurrentMoney_Capital(this,copyParent);
	return sc;
    }
}
