/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>SubjectGroup</code>]<br>
 *  Manage subject group data
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectGroup implements NumberIdentical, Serializable,NameCommentObject{

    static final long serialVersionUID = 3113927724053180344L;

    //Subject group constants
    public static final int ASSETS  = 0;//Y
    public static final int DEBT    = 1;//
    public static final int CAPITAL = 2;//{
    public static final int PROFIT  = 3;//v
    public static final int EXPENSE = 4;//p

    int groupId ;
    String name ;
    String comment ;
    int balanceGroup ;

   /** Grop constructor
     * @param gid group ID
     * @param n group name
     * @param com group comment
     * @param whichGroup balance group label
     */
    public SubjectGroup(int gid,String n,String com,
			int whichGroup) {
            groupId = gid;
            setName(n);
            setComment(com);
            setBalanceGroup(whichGroup);
        }

    public int getId() { return groupId;}

    public void setName(String a) { name = a; }
    public String getName() { return name; }
    public String toString() { return getName();}

    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }
    
    public int getBalanceGroup() {return balanceGroup;}
    public void setBalanceGroup(int i) {
        if (i >= 0 && i <= 4) balanceGroup = i;
    }

    public boolean isClear() {
	boolean clear = false;
	switch (getBalanceGroup()) {
	case ASSETS:
	case DEBT:
	case CAPITAL:
	    break;
	case EXPENSE:
	case PROFIT:
	    clear = true;
	    break;
	default:
	    System.err.println("Invalid group label : "+getName());
	}
	return clear;
    }

    public long getTotalAmount(long credit,long debt) {
	long sign = 1;
	switch (getBalanceGroup()) {
	case ASSETS:
	case EXPENSE:
	    sign = 1;
	    break;
	    
	case DEBT:
	case CAPITAL:
	case PROFIT:
	    sign = -1;
	    break;
	default:
	    System.err.println("Invalid group label : "+getName());
	}
	long tm = (credit-debt)*sign;
	return tm;
    }

    public SubjectGroup getCopy() {
	SubjectGroup copy = new SubjectGroup(getId(),getName(),getComment(),
					     getBalanceGroup());
	return copy;
    }
}
