/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  Manage initial money in AnnualData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectMoney implements NumberIdentical,Serializable {

    static final long serialVersionUID = -713903483366229506L;

    int sid ;
    long money ;
    AnnualData parent;

    public SubjectMoney(AnnualData p,Subject s) {
	parent = p;
	sid = s.getId();
	money = 0;
    }
    protected SubjectMoney(SubjectMoney sm,AnnualData ad) {
	parent = ad;
	sid = sm.getId();
	money = sm.getMoney();
    }

    public int getId() {return sid;}

    public void setMoney(long a) {
	money = a;
	SubjectCurrentMoney cm = parent.getCurrentMoney(sid);
	cm.lastCalculated.setTime(0);//infinity past
    }

    public long getMoney() { return money; }

    public String toString() {
	return getClass().getName()+":"+sid+"   money:"+money;
    }

    public SubjectMoney getCopy(AnnualData copyParent) {
	SubjectMoney sm = new SubjectMoney(this,copyParent);
	return sm;
    }
}
