/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  Manage initial capital money in AnnualData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectMoney_Capital extends SubjectMoney {
    static final long serialVersionUID = -9105000074337116391L;

    public SubjectMoney_Capital(AnnualData p,Subject s) {
	super(p,s);
    }
    protected SubjectMoney_Capital(SubjectMoney_Capital sc,
				   AnnualData copyParent) {
	super(sc,copyParent);
    }

    public long getMoney() {
	Iterator it = parent.getInitialMoneys().iterator();
	long assets=0,debt=0;
	while(it.hasNext()) {
	    SubjectMoney sm = (SubjectMoney)it.next();
	    SubjectGroup sg = parent.getParent().getGroupBySubject(sm.getId());
	    if (sg == null) {
		System.err.println("SubjectGroup not found : in SubjectMoney_Capital");
		continue;
	    }
	    if (sg.getBalanceGroup() == SubjectGroup.ASSETS) 
		assets += sm.getMoney();
	    if (sg.getBalanceGroup() == SubjectGroup.DEBT)
		debt += sm.getMoney();
	}
	return assets-debt;
    }

    public SubjectMoney getCopy(AnnualData copyParent) {
	SubjectMoney_Capital sm = new SubjectMoney_Capital(this,copyParent);
	return sm;
    }
}
