/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>SubjectSubgroup</code>]<br>
 *  Manage Subject Subgroup data 
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SubjectSubgroup implements NumberIdentical, Serializable ,NameCommentObject{

    static final long serialVersionUID = 72139563632178305L;

    int subgroupId ;
    int groupId;
    String name ;
    String comment ;

    public SubjectSubgroup(int sgid,int gid,String n,String c) {
	subgroupId = sgid;
	groupId = gid;
	setName(n);
	setComment(c);
    }

    public int getId() { return subgroupId;}
    public int getGroupId() { return groupId;}

    public void setName(String a) { name = a; }
    public String getName() { return name; }
    public String toString() { return getName();}

    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }

    public SubjectSubgroup getCopy() {
	SubjectSubgroup copy = new SubjectSubgroup(getId(),getGroupId(),
						   getName(),getComment());
	return copy;
    }
}
