/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>SystemInfo</code>]<br>
 *  Manage all manager
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class SystemInfo {

    SessionManager sessionManager ;
    SecurityManager securityManager ;
    ProjectManager projectManager ;
    SlipManager slipManager ;
    ReportManager reportManager ;
    
    List managers = new LinkedList();

    /** Construct accounting system with some properties */
    public SystemInfo(String systemPropFile) {
	//yet not implemented
    }

    //==================================

    /** Construct accounting system with default setting */
    public SystemInfo() {
	initByDefault();
	securityManager = new SecurityManager(this);
	managers.add(securityManager);
	projectManager = new ProjectManager(this);
	managers.add(projectManager);
	slipManager = new SlipManager(this);
	managers.add(slipManager);
	reportManager = new ReportManager(this);
	managers.add(reportManager);
	sessionManager = new SessionManager(this);
	managers.add(sessionManager);
	//
	//Invoke initialize routine
	Iterator it = managers.iterator();
	while(it.hasNext()) {
	    ((AbstractManager)it.next()).initByLoad();
	} 
	onStartup();
    }

    //Invoke startup routine
    protected void onStartup() {
	Iterator it = managers.iterator();
	while(it.hasNext()) {
	    ((AbstractManager)it.next()).onStartup();
	}
	Date d = new Date();
	System.out.println("System is started up at "+d.toString());
    }

    /** Close system and save datas */
    public void onExit() {
	Iterator it = managers.iterator();
	while(it.hasNext()) {
	    ((AbstractManager)it.next()).onExit();
	}
	Date d = new Date();
	System.out.println("System was terminated at "+d.toString());
    }

    //===( access to manager )===============================

    /** access to manager */
    public SessionManager getSessionManager() { return sessionManager; }
    /** access to manager */
    public SecurityManager getSecurityManager() { return securityManager; }
    /** access to manager */
    public ProjectManager getProjectManager() { return projectManager; }
    /** access to manager */
    public SlipManager getSlipManager() { return slipManager; }
    /** access to manager */
    public ReportManager getReportManager() { return reportManager; }

    //===( system filename )===============================

    String projectResource = null;
    /** System property "project resource file", from which 
     * ProjectData construct a subject list.
     */
    public String getProjectResourceFilename() {return projectResource;}

    String  projectsFilename;
    /**
     * System data "Project data"
     */
    public String  getProjectsFilename() {return projectsFilename;}
     
    String slipsFilename;
    /** System data "TansferSlip data" */
    public String getSlipsFilename() {return slipsFilename;}
 
    String securityFilename;
    /** System data "Security data"  */
    public String getSecurityFilename() {return securityFilename;}

    String sessionLogFilename;
    /** System data "Security data"  */
    public String getSessionLogFilename() {return sessionLogFilename;}

    //===( default initialize )===============================

    /** initialize by default setting */
    void initByDefault() {
	System.out.println("Startup...");
	projectsFilename = "projects.dat";
	slipsFilename = "slips.dat";
	securityFilename = "security.dat";
	sessionLogFilename = "sessionlog.dat";
    }

}
