/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import jp.gr.java_conf.ccs2.io.*;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class SystemUtil {

    /** return present year */
    public static int getYear() {
	return getCalendar().get(Calendar.YEAR);
    }
    /** return present month */
    public static int getMonth() {
	return getCalendar().get(Calendar.MONTH)+1;
    }
    /** return present day */
    public static int getDay() {
	return getCalendar().get(Calendar.DAY_OF_MONTH);
    }

    private static Calendar getCalendar() {
	Date date = new Date();
	Calendar cal = Calendar.getInstance();
	cal.setTime(date);
	return cal;
    }

    // string and integer 

    private static int [] specialValues= {
	Subject.NORMAL_LABEL,
	Subject.CAPITAL_LABEL,
	Subject.DEPRECIATION_LABEL,
        Subject.GROUP_TRANSACTION_LABEL};
    private static String [] specialLabels= {"Normal","Capital","Depreciation","GroupTransaction"};

    public static int [] getSpecialValues() {return specialValues;}
    public static String [] getSpecialLabels() {return specialLabels;}

    private static int [] groupValues= {
	SubjectGroup.ASSETS,
	SubjectGroup.DEBT,
	SubjectGroup.CAPITAL,
	SubjectGroup.PROFIT,
	SubjectGroup.EXPENSE};
    private static String [] groupLabels= {"Assets","Debt","Capital","Profit","Expense"};
    public static String [] getBalanceGroupLabels() {return groupLabels;   }
    public static int [] getBalanceGroupValues() {return groupValues;  }

    /** return focus event that activates IM engine.  */
    public static FocusListener getIMEvent() {
	try {
	    return (FocusListener)jp.gr.java_conf.ccs2.frame.Singleton.instance(
		getResourceString("FocusIMEvent"));
	} catch (Exception e) {
	    //System.out.println(e.getClass().getName()+" : "+e.getMessage());
	}
	return null;
    }


    protected static MessageMonitor monitor = 
          new MessageMonitor("errorlogs.txt",MessageMonitor.ERROR,System.err);
    //G[Ȍo
    public static void logMessage(String log) {
	monitor.error(log);
    }

    static ResourceBundle resources;
    static boolean loadFailed = false;

    /** 񃊃\[X̓ǂݍ */
    protected static void loadResources() {
	String lc = null;
	Locale locale = Locale.getDefault();
       
	if (lc != null) {
	    String code = lc;
	    String country ="" ,lang="";
	    int ps = code.indexOf("_");
	    if (ps > -1) {
		lang = code.substring(0,ps);
		country = code.substring(ps+1);
	    } else {
		lang = code;
		country = "";
	    }
	    locale = new Locale(lang,country);
	    System.out.println("locale set to "+locale);
	} else 
	    System.out.println("default locale ["+locale.toString()+"] was set.");

	try {
	    resources = ResourceBundle.getBundle("arg.money.message",locale);
	    System.out.println(getResourceString("WelcomeMessage"));
	} catch (MissingResourceException mre) {
	    System.err.println("[message.properties] not found");
	    loadFailed = true;
	    //System.exit(1);
	}
    }

    /** ̓ǂ݂݁Bumessage.propertiesvɏnative2asciiB
	get resource string from properties file "strings.properties" */
    public static String getResourceString(String s) {
	if (resources == null && !loadFailed) 
	    loadResources();
	try {
	    return resources.getString(s);
	} catch (Exception e) {
	    System.err.println("no string :"+s);
	    //System.exit(0);
	}
	return s;
    }
    
}
