/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>TransferSlip</code>]<br>
 *  Manage an information of TransferSlip, 
 *   including the object of ASlipLines.
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class TransferSlip implements NumberIdentical,ReservableObject {
    int tid ;
    int year ;
    Date date ;
    Date lastmodified = new Date();
    int receiptNumber ;
    int pid ;
    int uid ;
    List lines ;

    boolean lock = false;

    public TransferSlip() {
	this(null);
    }

    public TransferSlip(List ls) {
	setLines(ls);
    }

    public TransferSlip(int t,int y,int rn,int p,int u,List lines) {
	this(lines);
	tid = t; setYear(y); setDate(new Date());
	setReceiptNumber(rn); setPid(p); setUid(u);
    }

    public String toString() {
	StringBuffer sb = new StringBuffer("----------------");
	sb.append("TSlip # "+jp.gr.java_conf.ccs2.util.StringUtil.datej(date)).append("\n");
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = (ASlipLine)lines.get(i);
	    sb.append(line.toString()).append("\n");
	}
	return sb.toString();
    }

    public TransferSlip getCopy() {
	TransferSlip copy = new TransferSlip();
	copyTo(copy);
	return copy;
    }

    public void copyTo(TransferSlip t) {
	t.tid = tid;
	t.year = year;
	t.date = new Date(date.getTime());
	t.receiptNumber = receiptNumber;
	t.pid = pid;
	t.uid = uid;
	if (t.getLines() != null) 
	    t.getLines().clear();
	else 
	    t.setLines(null);
	Iterator it = getLines().iterator();
	while(it.hasNext()){
	    SlipElement lt,rt;
	    ASlipLine line = (ASlipLine)it.next();
	    if (line.existLeft())
		lt = line.getLeft().getCopy();
	    else lt = null;
	    if (line.existRight())
		rt = line.getRight().getCopy();
	    else rt = null;
	    t.addLine(line.getSummary(),lt,rt);
	}
    }
    
    //number identical
    public int getId() {return tid;}

    public void setYear(int a) { year = a; }
    public int getYear() { return year; }

    public void setDate(Date a) { date = a; }
    public Date getDate() { return date; }

    public void setLastmodified(Date d) {lastmodified = d;}
    public Date getLastmodified() { return lastmodified; }
    public void modify() { lastmodified.setTime(System.currentTimeMillis()); }

    public void setReceiptNumber(int a) { receiptNumber = a; }
    public int getReceiptNumber() { return receiptNumber; }

    public void setPid(int a) { pid = a; }
    public int getPid() { return pid; }

    public void setUid(int a) { uid = a; }
    public int getUid() { return uid; }
    
    public void setLines(List ls) {
	if (ls == null) {
	    lines = new LinkedList();
	} else {
	    lines = ls;
	}
	if (lines.size() == 0)
	    addLine("",new SlipElement(-1,0),new SlipElement(-1,0));
    }

    public List getLines() {return lines;}

    public boolean existsSlipLineByLeftSubject(int sid) {
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = (ASlipLine)lines.get(i);
	    if (line.getLeft().getId() == sid)
		return true;
	}
	return false;
    }
    public Iterator getSlipLineByLeftSubject(int sid) {
	List temp = new LinkedList();
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = (ASlipLine)lines.get(i);
	    if (line.getLeft().getId() == sid)
		temp.add(line);
	}
	if (temp.size() == 0) return null;
	return temp.iterator();
    }

    public boolean existsSlipLineByRightSubject(int sid) {
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = (ASlipLine)lines.get(i);
	    if (line.getRight().getId() == sid)
		return true;
	}
	return false;
    }
    public Iterator getSlipLineByRightSubject(int sid) {
	List temp = new LinkedList();
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = (ASlipLine)lines.get(i);
	    if (line.getRight().getId() == sid)
		temp.add(line);
	}
	if (temp.size() == 0) return null;
	return temp.iterator();
    }

    public ASlipLine getASlipLine(int aid) {
	return (ASlipLine)lines.get(aid);
    }

    public ASlipLine addLine(String summary,
			     SlipElement left,SlipElement right) {
	ASlipLine fw = null;
	if (lines.size() != 0)
	    fw = (ASlipLine)lines.get(lines.size()-1);
	ASlipLine line = new ASlipLine(this,fw,summary,left,right);
	lines.add(line);
	return line;
    }

    public void removeLine(ASlipLine as) {
	if (as.getForward() == null) return;//can not remove!!
	//
	lines.remove(as);
	Object [] it = lines.toArray();
	lines.clear();
	for(int j=0;j<it.length;j++) {
	    ASlipLine line = (ASlipLine)it[j];
	    if (line != null) {
		SlipElement left  = line.existLeft() ? line.getLeft() : null;
		SlipElement right = line.existRight() ? line.getRight() : null;
		ASlipLine newLine = addLine(
		    line.getSummary(),left,right);
		if (newLine.getForward() == null) {
		    if (!newLine.existLeft()) {
			newLine.setLeft(new SlipElement(-1,0));
		    }
		    if (!newLine.existRight()) {
			newLine.setRight(new SlipElement(-1,0));
		    }
		}
	    }
	}
	if (lines.size() == 0)
	    setLines(null);
    }

    //=====(load procedure)=================
    
    public void load(List args) {
	try {
	    if ( args.size() >= 7 ) {
		//decode slip data!!
		Iterator it = args.iterator();
		tid = ((Integer)it.next()).intValue();
		setYear(((Integer)it.next()).intValue());
		setDate((Date)it.next());
		setReceiptNumber(((Integer)it.next()).intValue());
		setPid(((Integer)it.next()).intValue());
		setUid(((Integer)it.next()).intValue());
		//decode slip lines
		lines = (List)it.next();
		for (int i=0;i<lines.size();i++) {
		    ASlipLine as = (ASlipLine)lines.get(i);
		    as.setParent(this);
		}
		if (it.hasNext()) {
		    setLastmodified( (Date)it.next() );
		} 
	    } 
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    public List save() {
	List ret = new LinkedList();
	ret.add(new Integer(getId()));
	ret.add(new Integer(getYear()));
	ret.add(getDate());
	ret.add(new Integer(getReceiptNumber()));
	ret.add(new Integer(getPid()));
	ret.add(new Integer(getUid()));
	ret.add(lines);
	ret.add(getLastmodified());
	return ret;
    }


    //===============================
    // LOCKING FRAMEWORK
    //===============================

    /** if succeed, return true. */
    public synchronized boolean lock() {
	if (lock) return false;
	lock = true;
	return true;
    }

    /** if locked, return true. */
    public boolean isLocked() {
	return lock;
    }

    public synchronized void unlock() {
	lock = false;
    }

}

