/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money;
import java.util.*;
import java.io.*;

/** 
 *  [<code>UserManager</code>]<br>
 *  Manage UserData
 *  @author SAKURAI, Masashi
 *  @version 1.0
 */ 

public class UserManager {
    List users ;
    SecurityManager parent ;
    int curUid = 0;

    public UserManager(SecurityManager s) {
	parent = s;
	users = new ArrayList();
    }

    public SecurityManager getParent() { return parent; }
    /**
     * [<code>addUser</code>]
     *  
     * @param d user data
     * @return user data
     */ 
    public UserData addUser(String name,String comment,
			String password) {
	UserData u =new UserData(name,comment,password,curUid);
	synchronized(this) {
	    users.add(u);
	    Collections.sort(users,IdComparator.getInstance());
	    curUid++;
	}
	return u;
    }

    public List getUsers() {
	return users;
    }

    /**
     * [<code>getUser</code>]
     *  
     * @param uid user id
     * @return user data
     */ 
    public UserData getUser(int uid) {
	return (UserData)IdComparator.search(users,uid);
    }

    /**
     * [<code>login</code>]
     *  
     * @param name user name
     * @param passwd password
     * @return user id. If not certified, return -1.
     */ 
    public int login(String name,String passwd) {
	Iterator it = users.iterator();
	while(it.hasNext()) {
	    UserData u = (UserData)it.next();
	    if (u.getName().equals(name) &&
		u.getPassword().equals(passwd))
		return u.getId();
	}
	return -1;
    }

    /**
     * [<code>removeUser</code>]
     *  
     * @param uid user id
     */ 
    public void removeUser(int uid) {
	if (uid == 0) {
	    System.out.println("Cannot remove admin acount.");
	    return;
	}
	UserData u = getUser(uid);
	if (u != null) {
	    synchronized(parent) {
		//remove from belonging groups
		List groups = parent.getBelongingGroups(uid);
		Iterator it = groups.iterator();
		while(it.hasNext()) {
		    GroupData gd = (GroupData)it.next();
		    gd.removeUser(uid);
		}
		//
		users.remove(u);
	    }
	}
    }

    void loadClasses(List list) {
	Integer it = (Integer)list.get(0);
	curUid = it.intValue();
	users = (List)list.get(1);
	Collections.sort(users,IdComparator.getInstance());
    }
    
    List saveClasses() {
	List list = new LinkedList();
	list.add(new Integer(curUid));
	list.add(users);
	return list;
    }

    void initByClean() {
	addUser("admin","System Administrator","");
	System.out.println("Made admin acount.");
    }

}
