/*
 * DGeneralList.java
 *
 * Created on 2000/04/06, 16:40
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.util.*;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class DGeneralList extends javax.swing.JDialog {

    protected List contents;
    protected int index = -1;
    
    public DGeneralList(java.awt.Frame f,String title,List t) {
        this(f,true);
        contents = t;
        titleLabel.setText(title);
        updateList();
        okButton.setEnabled(false);
        pack();
        SubjectsUtil.setCenter(this);
    }
    
  /** Creates new form DGeneralList */
  public DGeneralList(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    titleLabel = new javax.swing.JLabel ();
    jPanel1 = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    cancelButton = new javax.swing.JButton ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    list = new javax.swing.JList ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );

    titleLabel.setText ("jLabel1");
    titleLabel.setFont (new java.awt.Font ("Serif", 0, 36));


    getContentPane ().add (titleLabel, java.awt.BorderLayout.NORTH);


      okButton.setText ("Ok");
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel1.add (okButton);
  
      cancelButton.setText ("Cancel");
      cancelButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              cancelButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel1.add (cancelButton);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);


      list.setFixedCellWidth (200);
      list.addKeyListener (new java.awt.event.KeyAdapter () {
          public void keyTyped (java.awt.event.KeyEvent evt) {
              listKeyTyped (evt);
          }
      }
      );
      list.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
          public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
              listValueChanged (evt);
          }
      }
      );
      list.addMouseListener (new java.awt.event.MouseAdapter () {
          public void mouseClicked (java.awt.event.MouseEvent evt) {
              listMouseClicked (evt);
          }
      }
      );
  
      jScrollPane1.setViewportView (list);
  

    getContentPane ().add (jScrollPane1, java.awt.BorderLayout.CENTER);

}//GEN-END:initComponents

  private void listKeyTyped (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_listKeyTyped
// Add your handling code here:
    if (evt.getKeyChar() == '\n')
        onOk();
  }//GEN-LAST:event_listKeyTyped

  private void listValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_listValueChanged
// Add your handling code here:
    okButton.setEnabled(true);
  }//GEN-LAST:event_listValueChanged

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
// Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

  private void listMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_listMouseClicked
// Add your handling code here:
    okButton.setEnabled(true);
    if (evt.getClickCount() == 2) 
        onOk();
  }//GEN-LAST:event_listMouseClicked

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    List t = new LinkedList();
    t.add("first");
    t.add("second");
    t.add("third");
    DGeneralList dlg = new DGeneralList (new javax.swing.JFrame (),"Dialog test",t);
    dlg.show();
    if (dlg.getIndex() != -1) {
        System.out.println(t.get(dlg.getIndex()));
    } else 
        System.out.println("canceled");
  }

    void updateList() {
        Object [] array = contents.toArray();
        list.setListData(array);
    }

    public void onOk() {
        int i = list.getSelectedIndex();
        if (i<0 && i>=contents.size()) {
            //error
            javax.swing.JOptionPane.showMessageDialog(this,"Please select an item.");
            return;
        }
        index = i;
        dispose();
    }

    public int getIndex() {return index;}
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel titleLabel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList list;
    // End of variables declaration//GEN-END:variables

}