/*
 * DGroupEditor.java
 *
 * Created on 2000/04/04, 19:05
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.*;
import arg.money.*;
import arg.money.SecurityManager;
import java.awt.Frame;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class DGroupEditor extends javax.swing.JDialog {

    protected boolean ok;
    protected GroupData group;
    protected SecurityManager manager;
    Frame ownerFrame;
    
    public DGroupEditor(java.awt.Frame f,GroupData g,SecurityManager sm) {
        this(f,true);
        ownerFrame = f;
        group = g;
        manager = sm;
	//
	propPage.setTitleAt(0,SystemUtil.getResourceString("Member"));
	propPage.setTitleAt(1,SystemUtil.getResourceString("Access"));
        updateMemberList();
        updateProjectList();
	//
        groupNameText.addFocusListener(SystemUtil.getIMEvent());
        groupCommentText.addFocusListener(SystemUtil.getIMEvent());
	groupNameText.setText(g.getName());
	groupCommentText.setText(g.getComment());
	pack ();
        SubjectsUtil.setCenter(this);
    }
    
  /** Creates new form DGroupEditor */
  public DGroupEditor(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    jPanel6 = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    cancelButton = new javax.swing.JButton ();
    centerPanel = new javax.swing.JPanel ();
    groupNamePanel = new javax.swing.JPanel ();
    groupNameText = new javax.swing.JTextField ();
    groupMemberPanel = new javax.swing.JPanel ();
    groupCommentText = new javax.swing.JTextField ();
    propPage = new javax.swing.JTabbedPane ();
    memberPage = new javax.swing.JPanel ();
    jPanel9 = new javax.swing.JPanel ();
    jScrollPane4 = new javax.swing.JScrollPane ();
    memberList = new javax.swing.JList ();
    jPanel8 = new javax.swing.JPanel ();
    addMemberButton = new javax.swing.JButton ();
    delMemberButton = new javax.swing.JButton ();
    accessPage = new javax.swing.JPanel ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    accessTable = new javax.swing.JTable ();
    jLabel1 = new javax.swing.JLabel ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );


      okButton.setText (SystemUtil.getResourceString("Ok"));
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel6.add (okButton);
  
      cancelButton.setText (SystemUtil.getResourceString("Cancel"));
      cancelButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              cancelButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel6.add (cancelButton);
  

    getContentPane ().add (jPanel6, java.awt.BorderLayout.SOUTH);

    centerPanel.setLayout (new javax.swing.BoxLayout (centerPanel, 1));

      groupNamePanel.setBorder (new javax.swing.border.TitledBorder("Group Name"));
      SubjectsUtil.borderTitle(groupNamePanel,SystemUtil.getResourceString("GroupName"));
  
        groupNameText.setColumns (20);
        groupNameText.setText ("jTextField5");
    
        groupNamePanel.add (groupNameText);
    
      centerPanel.add (groupNamePanel);
  
      groupMemberPanel.setBorder (new javax.swing.border.TitledBorder("Comment"));
      SubjectsUtil.borderTitle(groupMemberPanel,SystemUtil.getResourceString("GroupComment"));
  
        groupCommentText.setColumns (30);
        groupCommentText.setText ("jTextField6");
    
        groupMemberPanel.add (groupCommentText);
    
      centerPanel.add (groupMemberPanel);
  
  
        memberPage.setLayout (new javax.swing.BoxLayout (memberPage, 0));
        memberPage.setBorder (new javax.swing.border.TitledBorder(
        new javax.swing.border.EtchedBorder(), "Member"));
        SubjectsUtil.borderTitle(memberPage,SystemUtil.getResourceString("Member"));
    
          jPanel9.setLayout (new javax.swing.BoxLayout (jPanel9, 0));
      
        
          
              jScrollPane4.setViewportView (memberList);
          
            jPanel9.add (jScrollPane4);
        
          memberPage.add (jPanel9);
      
          jPanel8.setLayout (new javax.swing.BoxLayout (jPanel8, 1));
      
            addMemberButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Import24.gif")));
            addMemberButton.setText (SystemUtil.getResourceString("AddMember"));
            addMemberButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    addMemberButtonActionPerformed (evt);
                }
            }
            );
        
            jPanel8.add (addMemberButton);
        
            delMemberButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Export24.gif")));
            delMemberButton.setForeground (java.awt.Color.red);
            delMemberButton.setText (SystemUtil.getResourceString("RemoveMember"));
            delMemberButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    delMemberButtonActionPerformed (evt);
                }
            }
            );
        
            jPanel8.add (delMemberButton);
        
          memberPage.add (jPanel8);
      
        propPage.addTab ("jPanel7", memberPage);
    
        accessPage.setLayout (new java.awt.BorderLayout ());
    
      
        
            jScrollPane1.setViewportView (accessTable);
        
          accessPage.add (jScrollPane1, java.awt.BorderLayout.CENTER);
      
        propPage.addTab ("jPanel2", accessPage);
    
      centerPanel.add (propPage);
  

    getContentPane ().add (centerPanel, java.awt.BorderLayout.CENTER);

    jLabel1.setText (SystemUtil.getResourceString("GroupManager"));
    jLabel1.setFont (new java.awt.Font ("Serif", 0, 36));


    getContentPane ().add (jLabel1, java.awt.BorderLayout.NORTH);

}//GEN-END:initComponents

  private void delMemberButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delMemberButtonActionPerformed
// Add your handling code here:
    int ps = memberList.getSelectedIndex();
    if (ps == -1) return;
    group.removeUser(uarray[ps].getId());
    updateMemberList();
  }//GEN-LAST:event_delMemberButtonActionPerformed

  private void addMemberButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addMemberButtonActionPerformed
// Add your handling code here:
    List us = manager.getUserManager().getUsers();
    DGeneralList dlg = new DGeneralList(ownerFrame,"",us);
    dlg.show();
    int ps = dlg.getIndex();
    if (ps == -1) return;
    UserData ud = (UserData)us.get(ps);
    group.addUser(ud.getId());
    updateMemberList();
  }//GEN-LAST:event_addMemberButtonActionPerformed

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
// Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new DGroupEditor (new javax.swing.JFrame (), true).show ();
  }

    UserData [] uarray;
    void updateMemberList() {
        List list = group.getUsers();
        UserManager um = manager.getUserManager();
        uarray = new UserData[list.size()];
        if (list.size() != 0) {
            for (int i=0;i<list.size();i++) {
                NumberIdentical n = (NumberIdentical)list.get(i);
                uarray[i] = um.getUser(n.getId());
            }
        }
        memberList.setListData(uarray);
    }

    AccessModel accessModel;
    void updateProjectList() {
        List ps = manager.getParent().getProjectManager().getProjects();
        accessModel = new AccessModel(ps);
	accessTable.setDefaultEditor(
	    Boolean.TYPE,
	    new DefaultCellEditor(new JCheckBox()));
	accessTable.setDefaultRenderer(
	    Boolean.TYPE,
	    new BooleanCellRenderer());
        accessTable.setModel(accessModel);
	//
    }

    class AccessModel extends AbstractTableModel {
        List projects;
        final String [] titles = {
            SystemUtil.getResourceString("Project"),
            SystemUtil.getResourceString("GroupComment"),
            SystemUtil.getResourceString("Readable"),
            SystemUtil.getResourceString("Writable"),
            SystemUtil.getResourceString("EditSubject"),
            SystemUtil.getResourceString("SettleAccount")
	};
        boolean [][] accesses;
        AccessModel(List ps) {
            projects = ps;
            accesses = new boolean [ps.size()][GroupData.masks.length];
            if (ps.size() != 0)
                for (int i=0;i<ps.size();i++) {
                    ProjectData pd = (ProjectData)projects.get(i);
		    for (int j=0;j<GroupData.masks.length;j++)
			accesses[i][j] = group.isPermitted(pd.getId(),GroupData.masks[j]);
                }
        }
	public int getColumnCount() { return titles.length; }
	public Class getColumnClass(int c) {
	    if (c >= 2 && c <= 5) return Boolean.TYPE;
	    return super.getColumnClass(c);
	}
	public int getRowCount() { return projects.size();}
	public String getColumnName(int i) {
            return titles[i];}
	public boolean isCellEditable(int rowIndex, int columnIndex) {
	    if (columnIndex >= 2 && columnIndex <= 5) return true;
	    return false;
	}
	public Object getValueAt(int row, int col) {
	    ProjectData pd = (ProjectData)projects.get(row);
            switch(col) {
	    case 0://name
		return pd.getName();
	    case 1://comment
		return pd.getComment();
	    case 2://readable
	    case 3://writable
	    case 4://editable
	    case 5://settlable
		return new Boolean(accesses[row][col-2]);
	    default:
	    }
	    return null;
	}
	
        public void setValueAt(Object a, int rowIndex, int columnIndex)  {
            if (a instanceof String) {
                Boolean bb = new Boolean((String)a);
                switch(columnIndex) {
                case 2://readable
                case 3://writable
                case 4://editable
                case 5://settlable
		    accesses[rowIndex][columnIndex-2] = bb.booleanValue();
		    return;
		default:
                }
            }
            if (a instanceof Boolean) {
                Boolean bb = (Boolean)a;
                switch(columnIndex) {
                case 2://readable
                case 3://writable
                case 4://editable
                case 5://settlable
		    accesses[rowIndex][columnIndex-2] = bb.booleanValue();
		    return;
		default:
                }
            }
        }

        public void confirm() {
            if (projects.size() != 0)
                for (int i=0;i<projects.size();i++) {
                    ProjectData pd = (ProjectData)projects.get(i);
		    int mask = 0;
		    for (int j=0;j<GroupData.masks.length;j++) {
			if (accesses[i][j])
			    mask += GroupData.masks[j];
		    }
		    group.setProject(pd.getId(),mask);
                }
        }
    }

    public boolean isOk() {return ok;}

    void onOk() {
        String s = groupNameText.getText();
        if (s.length() == 0) {
            String mes = SystemUtil.getResourceString("InputGroupName");
            javax.swing.JOptionPane.showMessageDialog(this,mes);
            return;
        }
        group.setName(s);
        group.setComment(groupCommentText.getText());
        //project access
        accessModel.confirm();
        //user lsit
        List list = group.getUsers();
        list.clear();
        if (uarray.length != 0) {
            for (int i=0;i<uarray.length;i++) {
                  group.addUser(uarray[i].getId());
            }
        }
        //
        ok = true;
        dispose();
    }

    
    // ϐ錾 - ύXȂ//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel6;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel centerPanel;
    private javax.swing.JPanel groupNamePanel;
    private javax.swing.JTextField groupNameText;
    private javax.swing.JPanel groupMemberPanel;
    private javax.swing.JTextField groupCommentText;
    private javax.swing.JTabbedPane propPage;
    private javax.swing.JPanel memberPage;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JList memberList;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JButton addMemberButton;
    private javax.swing.JButton delMemberButton;
    private javax.swing.JPanel accessPage;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable accessTable;
    private javax.swing.JLabel jLabel1;
    // ϐ錾̏I//GEN-END:variables

}
