/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import jp.gr.java_conf.ccs2.frame.*;
import arg.money.*;


public class DMenu extends JFrame implements UserShell{

    SessionData session;
    SystemInfo systemInfo;

    Document document = new Document();

    public DMenu(SessionData sd) {
	super(SystemUtil.getResourceString("MenuTitle"));
	session = sd;
	systemInfo = sd.getParent().getParent();
	initGui();
    }

    JLabel nameLabel,commentLabel;
    void initGui() {
	JPanel root = new JPanel();
	root.setLayout( new GridLayout(7,1));
        getContentPane().add(root,"Center");
	// name panel
        JPanel npanel = new JPanel();
        BoxLayout boxlayout = new BoxLayout(npanel,BoxLayout.Y_AXIS);
        npanel.setLayout(boxlayout);
        nameLabel = new JLabel(session.getUser().getName());
        nameLabel.setFont(new Font("SansSerif",Font.PLAIN,28));
        nameLabel.setForeground(Color.black);
        npanel.add(nameLabel);
        commentLabel = new JLabel(session.getUser().getComment());
        commentLabel.setFont(new Font("Serif",Font.PLAIN,12));
        commentLabel.setForeground(Color.yellow);
        npanel.add(commentLabel);
        npanel.setBorder(new javax.swing.border.TitledBorder(SystemUtil.getResourceString("User")));
        getContentPane().add(npanel,"North");
        //
	JButton explorerButton = new JButton(
	    SystemUtil.getResourceString("ExplorerButton"));
	explorerButton.setHorizontalAlignment(SwingConstants.LEFT);
	explorerButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/development/Applet24.gif")));
	root.add(explorerButton);
	JButton reportButton = new JButton(
	    SystemUtil.getResourceString("ReportButton"));
	reportButton.setHorizontalAlignment(SwingConstants.LEFT);
	reportButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/History24.gif")));
	root.add(reportButton);
	JButton projectButton = new JButton(
	    SystemUtil.getResourceString("ProjectButton"));
	projectButton.setHorizontalAlignment(SwingConstants.LEFT);
	projectButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/Copy24.gif")));
	root.add(projectButton);
	JButton securityButton = new JButton(
	    SystemUtil.getResourceString("SecurityButton"));
	securityButton.setHorizontalAlignment(SwingConstants.LEFT);
	securityButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
	root.add(securityButton);
	final JButton specialButton = new JButton(
	    SystemUtil.getResourceString("SpecialButton"));
	specialButton.setHorizontalAlignment(SwingConstants.LEFT);
	specialButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/Export24.gif")));
	root.add(specialButton);
	JButton userButton = new JButton(
	    SystemUtil.getResourceString("UserDataButton"));
	userButton.setHorizontalAlignment(SwingConstants.LEFT);
	userButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/Information24.gif")));
	root.add(userButton);
	JButton exitButton = new JButton(
	    SystemUtil.getResourceString("Exit"));
	exitButton.setHorizontalAlignment(SwingConstants.LEFT);
	exitButton.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/Stop24.gif")));
	root.add(exitButton);
	JLabel label = new JLabel(
	    SystemUtil.getResourceString("Copyright"));
	getContentPane().add(label,"South");
	//
	userButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    editUserData();
                    UserData ud = session.getUser();
                    nameLabel.setText(ud.getName());
                    commentLabel.setText(ud.getComment());
                    pack();
		}});
	explorerButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onExplorer();
		}});
	reportButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onReport();
		    //Not Implemented
		}});
	projectButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    DProjectManager dlg = 
			new DProjectManager(DMenu.this,session,
					    systemInfo.getProjectManager());
		    dlg.show();
		}});
	securityButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    DSecurityManager dlg = 
			new DSecurityManager(DMenu.this,systemInfo.getSecurityManager());
		    dlg.show();
		}});
	specialButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    Dimension d = specialButton.getSize();
		    specialPopupMenu.show(specialButton,
					  (int)(d.getWidth()/2),
					  (int)(d.getHeight()/2));
		}});
	exitButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    session.terminate();
		    onExit();
		}});
	makePopupMenu();
	//permission
	boolean isAdmin = systemInfo.getSecurityManager().
	    getAdminPermission(session);
	if (!isAdmin) securityButton.setEnabled(false);
	if (!isAdmin) specialButton.setEnabled(false);
	//
	setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
	pack();
    }

    /** called in log-in sequence */
    public void show() {
	super.show();
    }

    /** called when need to update */
    public void update(int pid){
	document.updateViews(new Integer(pid));
    }

    /** called when need to close the shell */
    public void close() {
	document.updateViews(null);
	dispose();
    }

    void editUserData() {
	DUserEditor dlg = new DUserEditor(
	    this,session.getUser());
	dlg.show();
    }

    void onExit() {
	close();
	session.terminate();
    }
    
    void onExplorer() {
	JFrame explorer = new FSlipExplorer(systemInfo.getSlipManager(),
					 session,document);
	explorer.show();
    }
    void onReport() {
	JFrame reporter = new FReport(systemInfo.getSlipManager(),session,document);
	reporter.show();
    }

    void onExport() {
	
    }

    void onNextYear() {
	try {
	    ProjectManager pm = systemInfo.getProjectManager();
	    pm.makeNextYear(systemInfo.getSlipManager());
	} catch (DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("ProjectLockError"));
	    return;
	}
    }

    
    JPopupMenu specialPopupMenu;

    void makePopupMenu() {
	specialPopupMenu = new JPopupMenu();
	JMenuItem item = new JMenuItem(
	    SystemUtil.getResourceString("SpecialNextYear"));
	item.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onNextYear();
		}
	    });
	specialPopupMenu.add(item);
	item = new JMenuItem(
	    SystemUtil.getResourceString("SpecialExport"));
	item.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onExport();
		}
	    });
	specialPopupMenu.add(item);
    }
}
