/*
 * DProjectEditor.java
 *
 * Created on 2000/04/05, 3:17
 */

/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.Frame;
import javax.swing.*;
import javax.swing.border.*;
import java.text.*;
import java.util.*;
import java.awt.Frame;
import arg.money.*;
import jp.gr.java_conf.ccs2.comp.swing.*;

/**
 *
 * @author  sakurai
 * @version
 */
public class DProjectEditor extends javax.swing.JDialog {

    Frame ownerFrame;
    ProjectData project;
    SlipManager manager;
    SubjectsUtil utils;
    boolean okFlag = false;
    
    DateComponent startedDate,closedDate;

    public DProjectEditor(Frame f,ProjectData pd,SlipManager sm) {
        this(f,true);
        ownerFrame = f;
        project = pd;
	manager = sm;
        okFlag = false;
	//IME
        projectNameText.addFocusListener(SystemUtil.getIMEvent());
        commentText.addFocusListener(SystemUtil.getIMEvent());
	moneyText.addFocusListener(new DirectIMFocusListener());
	//start and close date
        startedDate = new DateComponent();
        startedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("StartedDate")));
        annualDataPanel.add(startedDate);
        closedDate = new DateComponent();
        closedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("ClosedDate")));
        annualDataPanel.add(closedDate);
        //set year
        List list = project.getAnnuals();
        Iterator it = list.iterator();
        while(it.hasNext()) {
            AnnualData ad = (AnnualData)it.next();
            yearComboBox.addItem(new Integer(ad.getId()));
        }
        //set name and comment
        projectNameText.setText(project.getName());
        commentText.setText(project.getComment());
        //set subject util object
        utils = new SubjectsUtil(project,groupList,subgroupList,subjectList,
				 new jp.gr.java_conf.ccs2.comp.MessageListener() {
            public void message(String a,int id,Object n) {
                updateMoney();
            }
        });
        updateYear();
	pack();
        SubjectsUtil.setCenter(this);
    }

    void updateYear() {
        try {
            Integer index = (Integer)yearComboBox.getSelectedItem();
            AnnualData ad = project.getAnnual(index.intValue());
            Date d = ad.getStartedDate();
            startedDate.setDate(d);
            d = ad.getClosedDate();
            closedDate.setDate(d);
        }catch(RuntimeException e) {}
        updateMoney();
    }
    
    SubjectMoney lastMoney;
    NumberFormat form = NumberFormat.getInstance();
    void updateMoney() {
        setMoney();
        String name="",com="";
        //
        name = SystemUtil.getResourceString("non");
        com = "";
        try {
            SubjectGroup group = utils.getSelectedGroup();
            if (group != null) {
                name = group.getName();
                com = group.getComment();
            }
        }catch(RuntimeException e) {
            //System.err.println("RTException at updateMoney1 in DProjectEditor.");
        }
        groupNameLabel.setText(name);
        groupCommentLabel.setText(com);
        //
        name = SystemUtil.getResourceString("non");
        com = "";
        try {
            SubjectSubgroup subgroup = utils.getSelectedSubgroup();
            if (subgroup != null) {
                name = subgroup.getName();
                com = subgroup.getComment();
            }
        }catch(RuntimeException e) {
            //System.err.println("RTException at updateMoney2 in DProjectEditor.");
        }
        subgroupNameLabel.setText(name);
        subgroupCommentLabel.setText(com);
        //
        name = SystemUtil.getResourceString("non");
        com = "";
        Subject subject = null;
        try {
            subject = utils.getSelectedSubject();
            if (subject != null) {
                name = subject.getName();
                com = subject.getComment();
            }
        }catch(RuntimeException e) {
            //System.err.println("RTException at updateMoney3 in DProjectEditor.");
        }
        subjectNameLabel.setText(name);
        subjectCommentLabel.setText(com);
        //
        try {
            if (subject != null) {
                Integer index = (Integer)yearComboBox.getSelectedItem();
                AnnualData ad = project.getAnnual(index.intValue());
                SubjectMoney sm = ad.getInitialMoney(subject.getId());
                moneyText.setText(form.format(sm.getMoney()));
                lastMoney = sm;
            }
        }catch(RuntimeException e) {
            System.err.println("RTException at updateMoney4 in DProjectEditor.");
            e.printStackTrace();
        }
    }

    void setMoney() {
        if ( lastMoney != null)  {
            try {
                long mm = form.parse(
		    jp.gr.java_conf.ccs2.util.StringUtil.transform(
			moneyText.getText())).longValue();
                lastMoney.setMoney(mm);
            }catch(ParseException e) {

            }
        }
    }

    void setDate() {
	Integer index = (Integer)yearComboBox.getSelectedItem();
	AnnualData ad = project.getAnnual(index.intValue());
	Date d = startedDate.getDate();
	if (d != null) {
	    ad.setStartedDate(d);
	}

	d = closedDate.getDate();
	if (d != null) {
	    ad.setClosedDate(d);
	}
    }

    void onOk() {
        setMoney();
	setDate();
        project.setName(projectNameText.getText());
        project.setComment(commentText.getText());
        okFlag = true;
        dispose();
    }

    void onCancel() {
        okFlag = false;
        dispose();
    }

    public boolean isOk() {
        return okFlag;
    }
    
    /** Creates new form DProjectEditor */
    public DProjectEditor(java.awt.Frame parent,boolean modal) {
        super (parent, modal);
        initComponents ();
        pack ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        jPanel2 = new javax.swing.JPanel ();
        titleLabel = new javax.swing.JLabel ();
        jPanel3 = new javax.swing.JPanel ();
        jPanel4 = new javax.swing.JPanel ();
        jPanel13 = new javax.swing.JPanel ();
        jLabel1 = new javax.swing.JLabel ();
        projectNameText = new javax.swing.JTextField ();
        jPanel14 = new javax.swing.JPanel ();
        jLabel2 = new javax.swing.JLabel ();
        commentText = new javax.swing.JTextField ();
        annualDataPanel = new javax.swing.JPanel ();
        yearLabel = new javax.swing.JLabel ();
        yearComboBox = new javax.swing.JComboBox ();
        jPanel6 = new javax.swing.JPanel ();
        groupPanel = new javax.swing.JPanel ();
        jScrollPane1 = new javax.swing.JScrollPane ();
        groupList = new javax.swing.JList ();
        jPanel5 = new javax.swing.JPanel ();
        groupAddButton = new javax.swing.JButton ();
        groupModButton = new javax.swing.JButton ();
        groupDelButton = new javax.swing.JButton ();
        subgroupPanel = new javax.swing.JPanel ();
        jScrollPane2 = new javax.swing.JScrollPane ();
        subgroupList = new javax.swing.JList ();
        jPanel10 = new javax.swing.JPanel ();
        subAddButton = new javax.swing.JButton ();
        subModButton = new javax.swing.JButton ();
        subDelButton = new javax.swing.JButton ();
        subjectPanel = new javax.swing.JPanel ();
        jScrollPane3 = new javax.swing.JScrollPane ();
        subjectList = new javax.swing.JList ();
        jPanel11 = new javax.swing.JPanel ();
        subjectAddButton = new javax.swing.JButton ();
        subjectModButton = new javax.swing.JButton ();
        subjectDelButton = new javax.swing.JButton ();
        annualPanel = new javax.swing.JPanel ();
        jPanel15 = new javax.swing.JPanel ();
        groupNameLabel = new javax.swing.JLabel ();
        groupCommentLabel = new javax.swing.JLabel ();
        jPanel16 = new javax.swing.JPanel ();
        subgroupNameLabel = new javax.swing.JLabel ();
        subgroupCommentLabel = new javax.swing.JLabel ();
        jPanel17 = new javax.swing.JPanel ();
        subjectNameLabel = new javax.swing.JLabel ();
        subjectCommentLabel = new javax.swing.JLabel ();
        jPanel18 = new javax.swing.JPanel ();
        moneyLabel = new javax.swing.JLabel ();
        moneyText = new javax.swing.JTextField ();
        jPanel1 = new javax.swing.JPanel ();
        okButton = new javax.swing.JButton ();
        cancelButton = new javax.swing.JButton ();
        getContentPane ().setLayout (new javax.swing.BoxLayout (getContentPane (), 1));
        addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
                closeDialog (evt);
            }
        }
        );

        jPanel2.setLayout (new java.awt.BorderLayout ());

          titleLabel.setText (SystemUtil.getResourceString("ProjectEditor"));
          titleLabel.setFont (new java.awt.Font ("Serif", 0, 36));
  
          jPanel2.add (titleLabel, java.awt.BorderLayout.NORTH);
  
          jPanel3.setLayout (new javax.swing.BoxLayout (jPanel3, 1));
  
            jPanel4.setLayout (new javax.swing.BoxLayout (jPanel4, 1));
            jPanel4.setBorder (new javax.swing.border.EtchedBorder());
    
              jPanel13.setLayout (new java.awt.FlowLayout (0, 15, 5));
      
                jLabel1.setText (SystemUtil.getResourceString("ProjectName")+" : ");
        
                jPanel13.add (jLabel1);
        
                projectNameText.setColumns (20);
        
                jPanel13.add (projectNameText);
        
              jPanel4.add (jPanel13);
      
              jPanel14.setLayout (new java.awt.FlowLayout (0, 15, 5));
      
                jLabel2.setText (SystemUtil.getResourceString("ProjectComment")+" : ");
        
                jPanel14.add (jLabel2);
        
                commentText.setColumns (30);
        
                jPanel14.add (commentText);
        
              jPanel4.add (jPanel14);
      
      
                yearLabel.setText (SystemUtil.getResourceString("CurrentYear"));
        
                annualDataPanel.add (yearLabel);
        
                yearComboBox.addItemListener (new java.awt.event.ItemListener () {
                    public void itemStateChanged (java.awt.event.ItemEvent evt) {
                        yearComboBoxItemStateChanged (evt);
                    }
                }
                );
        
                annualDataPanel.add (yearComboBox);
        
              jPanel4.add (annualDataPanel);
      
            jPanel3.add (jPanel4);
    
          jPanel2.add (jPanel3, java.awt.BorderLayout.CENTER);
  

        getContentPane ().add (jPanel2);

        jPanel6.setLayout (new javax.swing.BoxLayout (jPanel6, 0));

          groupPanel.setLayout (new java.awt.BorderLayout ());
          groupPanel.setBorder (new javax.swing.border.TitledBorder("Group"));
          SubjectsUtil.borderTitle(groupPanel,SystemUtil.getResourceString("Group"));
  
    
              groupList.setFixedCellWidth (140);
              groupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      groupListKeyPressed (evt);
                  }
              }
              );
              groupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      groupListValueChanged (evt);
                  }
              }
              );
              groupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      groupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane1.setViewportView (groupList);
      
            groupPanel.add (jScrollPane1, java.awt.BorderLayout.CENTER);
    
            jPanel5.setLayout (new javax.swing.BoxLayout (jPanel5, 0));
    
              groupAddButton.setText (SystemUtil.getResourceString("Add"));
              groupAddButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      groupAddButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel5.add (groupAddButton);
      
              groupModButton.setText (SystemUtil.getResourceString("Mod"));
              groupModButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      groupModButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel5.add (groupModButton);
      
              groupDelButton.setForeground (java.awt.Color.red);
              groupDelButton.setText (SystemUtil.getResourceString("Del"));
              groupDelButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      groupDelButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel5.add (groupDelButton);
      
            groupPanel.add (jPanel5, java.awt.BorderLayout.SOUTH);
    
          jPanel6.add (groupPanel);
  
          subgroupPanel.setLayout (new java.awt.BorderLayout ());
          subgroupPanel.setBorder (new javax.swing.border.TitledBorder("Subgroup"));
          SubjectsUtil.borderTitle(subgroupPanel,SystemUtil.getResourceString("Subgroup"));
  
    
              subgroupList.setFixedCellWidth (140);
              subgroupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subgroupListKeyPressed (evt);
                  }
              }
              );
              subgroupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subgroupListValueChanged (evt);
                  }
              }
              );
              subgroupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subgroupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane2.setViewportView (subgroupList);
      
            subgroupPanel.add (jScrollPane2, java.awt.BorderLayout.CENTER);
    
            jPanel10.setLayout (new javax.swing.BoxLayout (jPanel10, 0));
    
              subAddButton.setText (SystemUtil.getResourceString("Add"));
              subAddButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subAddButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel10.add (subAddButton);
      
              subModButton.setText (SystemUtil.getResourceString("Mod"));
              subModButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subModButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel10.add (subModButton);
      
              subDelButton.setForeground (java.awt.Color.red);
              subDelButton.setText (SystemUtil.getResourceString("Del"));
              subDelButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subDelButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel10.add (subDelButton);
      
            subgroupPanel.add (jPanel10, java.awt.BorderLayout.SOUTH);
    
          jPanel6.add (subgroupPanel);
  
          subjectPanel.setLayout (new java.awt.BorderLayout ());
          subjectPanel.setBorder (new javax.swing.border.TitledBorder("Subject"));
          SubjectsUtil.borderTitle(subjectPanel,SystemUtil.getResourceString("Subject"));
  
    
              subjectList.setFixedCellWidth (140);
              subjectList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subjectListKeyPressed (evt);
                  }
              }
              );
              subjectList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subjectListValueChanged (evt);
                  }
              }
              );
              subjectList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subjectListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane3.setViewportView (subjectList);
      
            subjectPanel.add (jScrollPane3, java.awt.BorderLayout.CENTER);
    
            jPanel11.setLayout (new javax.swing.BoxLayout (jPanel11, 0));
    
              subjectAddButton.setText (SystemUtil.getResourceString("Add"));
              subjectAddButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subjectAddButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel11.add (subjectAddButton);
      
              subjectModButton.setText (SystemUtil.getResourceString("Mod"));
              subjectModButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subjectModButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel11.add (subjectModButton);
      
              subjectDelButton.setForeground (java.awt.Color.red);
              subjectDelButton.setText (SystemUtil.getResourceString("Del"));
              subjectDelButton.addActionListener (new java.awt.event.ActionListener () {
                  public void actionPerformed (java.awt.event.ActionEvent evt) {
                      subjectDelButtonActionPerformed (evt);
                  }
              }
              );
      
              jPanel11.add (subjectDelButton);
      
            subjectPanel.add (jPanel11, java.awt.BorderLayout.SOUTH);
    
          jPanel6.add (subjectPanel);
  

        getContentPane ().add (jPanel6);

        annualPanel.setLayout (new javax.swing.BoxLayout (annualPanel, 1));
        annualPanel.setBorder (new javax.swing.border.TitledBorder("Annual Money"));
        SubjectsUtil.borderTitle(annualPanel,SystemUtil.getResourceString("AnnualAmount"));

          jPanel15.setLayout (new java.awt.FlowLayout (0, 15, 5));
          jPanel15.setAlignmentX (0.1F);
  
            groupNameLabel.setForeground (java.awt.Color.black);
    
            jPanel15.add (groupNameLabel);
    
            groupCommentLabel.setForeground (java.awt.Color.white);
    
            jPanel15.add (groupCommentLabel);
    
          annualPanel.add (jPanel15);
  
          jPanel16.setLayout (new java.awt.FlowLayout (0, 15, 5));
          jPanel16.setAlignmentX (0.1F);
  
            subgroupNameLabel.setForeground (java.awt.Color.black);
    
            jPanel16.add (subgroupNameLabel);
    
            subgroupCommentLabel.setForeground (java.awt.Color.white);
    
            jPanel16.add (subgroupCommentLabel);
    
          annualPanel.add (jPanel16);
  
          jPanel17.setLayout (new java.awt.FlowLayout (0, 15, 5));
          jPanel17.setAlignmentX (0.1F);
  
            subjectNameLabel.setForeground (java.awt.Color.black);
    
            jPanel17.add (subjectNameLabel);
    
            subjectCommentLabel.setForeground (java.awt.Color.white);
    
            jPanel17.add (subjectCommentLabel);
    
          annualPanel.add (jPanel17);
  
  
            moneyLabel.setAlignmentX (1.0F);
            moneyLabel.setText (SystemUtil.getResourceString("InitialAmount"));
            moneyLabel.setHorizontalAlignment (javax.swing.SwingConstants.RIGHT);
    
            jPanel18.add (moneyLabel);
    
            moneyText.setColumns (15);
            moneyText.setFont (new java.awt.Font ("Monospaced", 0, 14));
    
            jPanel18.add (moneyText);
    
          annualPanel.add (jPanel18);
  

        getContentPane ().add (annualPanel);


          okButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Save24.gif")));
          okButton.setText (SystemUtil.getResourceString("Ok"));
          okButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (okButton);
  
          cancelButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Stop24.gif")));
          cancelButton.setText (SystemUtil.getResourceString("Cancel"));
          cancelButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (cancelButton);
  

        getContentPane ().add (jPanel1);

    }//GEN-END:initComponents

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
      onCancel();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void groupDelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_groupDelButtonActionPerformed
// Add your handling code here:
    SubjectGroup sb = utils.getSelectedGroup();
    if (sb == null) return;
    String [] arg = {sb.getName()};
    String mes = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"),arg);
    int ret = JOptionPane.showConfirmDialog(this,mes,SystemUtil.getResourceString("Confirm"),JOptionPane.YES_NO_OPTION);
    if (ret != JOptionPane.YES_OPTION) return;
    try {
	project.removeSubjectGroup(sb.getId(),manager);
    } catch (RemovalException e) {
	JOptionPane.showMessageDialog(
	    this, SystemUtil.getResourceString(e.getMessage()) );
    }
    lastMoney = null;
    utils.updateGroupList();
    updateMoney();
  }//GEN-LAST:event_groupDelButtonActionPerformed

  private void groupModButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_groupModButtonActionPerformed
// Add your handling code here:
      SubjectGroup sb = utils.getSelectedGroup();
      if (sb == null) return;
      DSubjectGroup dlg = new DSubjectGroup(
	  ownerFrame, SystemUtil.getResourceString("InputSubgroupData"),
	  SystemUtil.getResourceString("SubgroupName"),
	  SystemUtil.getResourceString("SubgroupComment"),
	  sb,sb.getBalanceGroup());
      dlg.show();
      sb.setBalanceGroup(dlg.getBalanceGroup());
      project.syncAnnualData();
      utils.updateGroupList();
      updateMoney();
  }//GEN-LAST:event_groupModButtonActionPerformed

  private void groupAddButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_groupAddButtonActionPerformed
// Add your handling code here:
    SubjectGroup s = project.addSubjectGroup(
            SystemUtil.getResourceString("DefaultSubjectGroupName"),
            SystemUtil.getResourceString("DefaultSubjectGroupComment"),
	    SubjectGroup.ASSETS);
    DSubjectGroup dlg = new DSubjectGroup(ownerFrame,SystemUtil.getResourceString("InputSubjectGroupData"),
        SystemUtil.getResourceString("SubjectGroupName"), SystemUtil.getResourceString("SubjectGroupComment"),s,s.getBalanceGroup());
    dlg.show();
    s.setBalanceGroup(dlg.getBalanceGroup());
    utils.updateGroupList();
    updateMoney();
  }//GEN-LAST:event_groupAddButtonActionPerformed

  private void subjectListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subjectListKeyPressed
// Add your handling code here:
    if (evt.getKeyCode() == evt.VK_LEFT)
        subgroupList.requestFocus();
  }//GEN-LAST:event_subjectListKeyPressed

  private void subgroupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subgroupListKeyPressed
// Add your handling code here:
    if (evt.getKeyCode() == evt.VK_RIGHT)
        subjectList.requestFocus();
    if (evt.getKeyCode() == evt.VK_LEFT)
        groupList.requestFocus();
  }//GEN-LAST:event_subgroupListKeyPressed

  private void groupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_groupListKeyPressed
// Add your handling code here:
    if (evt.getKeyCode() == evt.VK_RIGHT)
        subgroupList.requestFocus();
  }//GEN-LAST:event_groupListKeyPressed

  private void subjectListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subjectListMouseClicked
    // Add your handling code here:
    updateMoney();
    if (evt.getClickCount()==2)
        subjectModButtonActionPerformed(null);
  }//GEN-LAST:event_subjectListMouseClicked

  private void subjectListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subjectListValueChanged
    // Add your handling code here:
    updateMoney();
  }//GEN-LAST:event_subjectListValueChanged

  private void yearComboBoxItemStateChanged (java.awt.event.ItemEvent evt) {//GEN-FIRST:event_yearComboBoxItemStateChanged
    // Add your handling code here:
    updateYear();
  }//GEN-LAST:event_yearComboBoxItemStateChanged

  private void subgroupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subgroupListValueChanged
    // Add your handling code here:
    utils.updateSubjectList();
  }//GEN-LAST:event_subgroupListValueChanged

  private void subgroupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subgroupListMouseClicked
    // Add your handling code here:
    utils.updateSubjectList();
    if (evt.getClickCount()==2)
        subModButtonActionPerformed(null);
  }//GEN-LAST:event_subgroupListMouseClicked

  private void groupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_groupListValueChanged
    // Add your handling code here:
    utils.updateSubgroupList();
  }//GEN-LAST:event_groupListValueChanged

  private void groupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_groupListMouseClicked
    // Add your handling code here:
    utils.updateSubgroupList();
    if (evt.getClickCount()==2)
        groupModButtonActionPerformed(null);
  }//GEN-LAST:event_groupListMouseClicked

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    // Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

  private void subjectDelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subjectDelButtonActionPerformed
    // Add your handling code here:
    Subject sb = utils.getSelectedSubject();
    if (sb == null) return;
    String [] arg = {sb.getName()};
    String mes = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"),arg);
    int ret = JOptionPane.showConfirmDialog(this,
        mes,SystemUtil.getResourceString("Confirm"),JOptionPane.YES_NO_OPTION);
    if (ret == JOptionPane.NO_OPTION) return;
    try {
	project.removeSubject(sb.getId(),manager);
    } catch (RemovalException e) {
	JOptionPane.showMessageDialog(
	    this, SystemUtil.getResourceString(e.getMessage()) );
    }

    lastMoney = null;
    utils.updateSubjectList();
  }//GEN-LAST:event_subjectDelButtonActionPerformed

  private void subjectModButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subjectModButtonActionPerformed
      // Add your handling code here:
      Subject sb = utils.getSelectedSubject();
      if (sb == null) return;
      checkSpecialLabel(sb);
      project.syncAnnualData();
      utils.updateSubjectList();
      updateMoney();
  }//GEN-LAST:event_subjectModButtonActionPerformed

  private void subjectAddButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subjectAddButtonActionPerformed
      // Add your handling code here:
      SubjectSubgroup sgx = utils.getSelectedSubgroup();
      if (sgx == null) return;
      SubjectGroup gx = utils.getSelectedGroup();
      if (gx == null) return;
      Subject s = project.addSubject(
	  SystemUtil.getResourceString("DefaultSubjectName"),
	  SystemUtil.getResourceString("DefaultSubjectComment"),
	  gx.getId(),sgx.getId());
      //check special
      checkSpecialLabel(s);
      utils.updateSubjectList();
      updateMoney();
  }//GEN-LAST:event_subjectAddButtonActionPerformed

    private void checkSpecialLabel(Subject s) {
      int sl = s.getSpecialLabel();
      DSubject dlg = new DSubject(
	  ownerFrame, SystemUtil.getResourceString("InputSubjectData"),
	  SystemUtil.getResourceString("SubjectName"),
	  SystemUtil.getResourceString("SubjectComment"),s);
      dlg.show();
      if (s.getSpecialLabel() != Subject.NORMAL_LABEL &&
	  s.getSpecialLabel() != Subject.GROUP_TRANSACTION_LABEL) {
	  Iterator it = project.getSubjects().iterator();
	  while(it.hasNext()) {
	      Subject sx = (Subject)it.next();
	      if (s.getSpecialLabel() == sx.getSpecialLabel() &&
		  sx.getId() != s.getId()) {
		  //bat
		  String mes = SystemUtil.getResourceString("WrongSpecialLabel");
		  JOptionPane.showMessageDialog(this,mes);
		  s.setSpecialLabel(sl);
		  break;
	      }
	  }
      }
    }

  private void subDelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subDelButtonActionPerformed
      // Add your handling code here:
      SubjectSubgroup sb = utils.getSelectedSubgroup();
      if (sb == null) return;
      String [] arg = {sb.getName()};
      String mes = MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"),arg);
      int ret = JOptionPane.showConfirmDialog(this,mes,SystemUtil.getResourceString("Confirm"),JOptionPane.YES_NO_OPTION);
      if (ret != JOptionPane.YES_OPTION) return;
      try {
	  project.removeSubjectSubgroup(sb.getId(),manager);
      } catch (RemovalException e) {
	  JOptionPane.showMessageDialog(
	      this, SystemUtil.getResourceString(e.getMessage()) );
      }

    lastMoney = null;
      utils.updateSubgroupList();
      updateMoney();
  }//GEN-LAST:event_subDelButtonActionPerformed

  private void subModButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subModButtonActionPerformed
    // Add your handling code here:
    SubjectSubgroup sb = utils.getSelectedSubgroup();
    if (sb == null) return;
    DSubject dlg = new DSubject(
	ownerFrame, SystemUtil.getResourceString("InputSubgroupData"),
	SystemUtil.getResourceString("SubgroupName"),
	SystemUtil.getResourceString("SubgroupComment"),sb);
    dlg.show();
    project.syncAnnualData();
    utils.updateSubgroupList();
    updateMoney();
  }//GEN-LAST:event_subModButtonActionPerformed

  private void subAddButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subAddButtonActionPerformed
    // Add your handling code here:
    SubjectGroup sgx = utils.getSelectedGroup();
    if (sgx == null) return;
    SubjectSubgroup s = project.addSubjectSubgroup(
            SystemUtil.getResourceString("DefaultSubgroupName"),
            SystemUtil.getResourceString("DefaultSubgroupComment"),
	    sgx.getId());
    DSubject dlg = new DSubject(
	ownerFrame,SystemUtil.getResourceString("InputSubgroupData"),
        SystemUtil.getResourceString("SubgroupName"),
	SystemUtil.getResourceString("SubgroupComment"),s);
    dlg.show();
    utils.updateSubgroupList();
    updateMoney();
  }//GEN-LAST:event_subAddButtonActionPerformed

/** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

/**
 * @param args the command line arguments
 */
public static void main (String args[]) {
    ProjectData pd = new ProjectData(0,"Project","test project");
    ProjectMaker.make(pd, null);
    DProjectEditor dlg = new DProjectEditor (new javax.swing.JFrame (),pd,null);
    dlg.show();
}


// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JPanel jPanel2;
private javax.swing.JLabel titleLabel;
private javax.swing.JPanel jPanel3;
private javax.swing.JPanel jPanel4;
private javax.swing.JPanel jPanel13;
private javax.swing.JLabel jLabel1;
private javax.swing.JTextField projectNameText;
private javax.swing.JPanel jPanel14;
private javax.swing.JLabel jLabel2;
private javax.swing.JTextField commentText;
private javax.swing.JPanel annualDataPanel;
private javax.swing.JLabel yearLabel;
private javax.swing.JComboBox yearComboBox;
private javax.swing.JPanel jPanel6;
private javax.swing.JPanel groupPanel;
private javax.swing.JScrollPane jScrollPane1;
private javax.swing.JList groupList;
private javax.swing.JPanel jPanel5;
private javax.swing.JButton groupAddButton;
private javax.swing.JButton groupModButton;
private javax.swing.JButton groupDelButton;
private javax.swing.JPanel subgroupPanel;
private javax.swing.JScrollPane jScrollPane2;
private javax.swing.JList subgroupList;
private javax.swing.JPanel jPanel10;
private javax.swing.JButton subAddButton;
private javax.swing.JButton subModButton;
private javax.swing.JButton subDelButton;
private javax.swing.JPanel subjectPanel;
private javax.swing.JScrollPane jScrollPane3;
private javax.swing.JList subjectList;
private javax.swing.JPanel jPanel11;
private javax.swing.JButton subjectAddButton;
private javax.swing.JButton subjectModButton;
private javax.swing.JButton subjectDelButton;
private javax.swing.JPanel annualPanel;
private javax.swing.JPanel jPanel15;
private javax.swing.JLabel groupNameLabel;
private javax.swing.JLabel groupCommentLabel;
private javax.swing.JPanel jPanel16;
private javax.swing.JLabel subgroupNameLabel;
private javax.swing.JLabel subgroupCommentLabel;
private javax.swing.JPanel jPanel17;
private javax.swing.JLabel subjectNameLabel;
private javax.swing.JLabel subjectCommentLabel;
private javax.swing.JPanel jPanel18;
private javax.swing.JLabel moneyLabel;
private javax.swing.JTextField moneyText;
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
// ϐ錾̏I//GEN-END:variables

}
