/*
 * DProjectManager.java
 *
 * Created on 2000/04/05, 3:11
 */

/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import javax.swing.*;
import java.util.*;
import java.awt.Frame;
import arg.money.*;
import arg.money.SecurityManager;

/**
 *
 * @author  sakurai
 * @version
 */
public class DProjectManager extends javax.swing.JDialog {

    Frame ownerFrame;
    ProjectManager manager;
    SlipManager slipManager;
    SessionData session;
    
    public DProjectManager(Frame f,SessionData ss,ProjectManager pm) {
        this(f,true);
        ownerFrame = f;
        manager = pm;
	slipManager = manager.getParent().getSlipManager();
	session = ss;
        updateProjectList();
	userButton();
	pack();
        SubjectsUtil.setCenter(this);
    }

    /** Creates new form DProjectManager */
    public DProjectManager(java.awt.Frame parent,boolean modal) {
        super (parent, modal);
        initComponents ();
        pack ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel ();
        okButton = new javax.swing.JButton ();
        jPanel6 = new javax.swing.JPanel ();
        jScrollPane3 = new javax.swing.JScrollPane ();
        projectList = new javax.swing.JList ();
        jPanel7 = new javax.swing.JPanel ();
        addButton = new javax.swing.JButton ();
        modButton = new javax.swing.JButton ();
        delButton = new javax.swing.JButton ();
        copyButton = new javax.swing.JButton ();
        extButton = new javax.swing.JButton ();
        titleLabel = new javax.swing.JLabel ();
        addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
                closeDialog (evt);
            }
        }
        );


          okButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Stop24.gif")));
          okButton.setText (SystemUtil.getResourceString("Exit"));
          okButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  jButton1ActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (okButton);
  

        getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel6.setLayout (new java.awt.BorderLayout (5, 5));
        jPanel6.setName ("UserPanel");

  
            projectList.setFixedCellWidth (240);
            projectList.addMouseListener (new java.awt.event.MouseAdapter () {
                public void mouseClicked (java.awt.event.MouseEvent evt) {
                    projectListMouseClicked (evt);
                }
            }
            );
    
            jScrollPane3.setViewportView (projectList);
    
          jPanel6.add (jScrollPane3, java.awt.BorderLayout.CENTER);
  
          jPanel7.setLayout (new javax.swing.BoxLayout (jPanel7, 1));
  
            addButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/New24.gif")));
            addButton.setText (SystemUtil.getResourceString("Add"));
            addButton.setFont (new java.awt.Font ("Serif", 0, 14));
            addButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    addButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel7.add (addButton);
    
            modButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Edit24.gif")));
            modButton.setText (SystemUtil.getResourceString("Modify"));
            modButton.setFont (new java.awt.Font ("Serif", 0, 14));
            modButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    modButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel7.add (modButton);
    
            delButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Delete24.gif")));
            delButton.setText (SystemUtil.getResourceString("Delete"));
            delButton.setForeground (java.awt.Color.red);
            delButton.setFont (new java.awt.Font ("Serif", 0, 14));
            delButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    delButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel7.add (delButton);
    
            copyButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Copy24.gif")));
            copyButton.setText (SystemUtil.getResourceString("Copy"));
            copyButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    copyButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel7.add (copyButton);
    
            extButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Export24.gif")));
            extButton.setText (SystemUtil.getResourceString("Export"));
            extButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    extButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel7.add (extButton);
    
          jPanel6.add (jPanel7, java.awt.BorderLayout.EAST);
  

        getContentPane ().add (jPanel6, java.awt.BorderLayout.CENTER);

        titleLabel.setText (SystemUtil.getResourceString("ProjectManager"));
        titleLabel.setFont (new java.awt.Font ("Serif", 0, 36));


        getContentPane ().add (titleLabel, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

  private void extButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_extButtonActionPerformed
// Add your handling code here:
    int i = projectList.getSelectedIndex();
    if (i == -1) return;
    ProjectData pd = parray[i];

    JFileChooser dlg = new JFileChooser();
    int returnVal = dlg.showSaveDialog(ownerFrame);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        ProjectMaker.save(pd,dlg.getSelectedFile().getPath());
    }
  }//GEN-LAST:event_extButtonActionPerformed

  private void copyButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyButtonActionPerformed
// Add your handling code here:
    int i = projectList.getSelectedIndex();
    if (i == -1) return;
    ProjectData pd = parray[i];
    String tmp = "temp.txt";
    ProjectMaker.save(pd,tmp);
    
    pd = manager.makeProject(SystemUtil.getResourceString("DefaultProject"),
                            SystemUtil.getResourceString("DefaultProjectComment"));
    ProjectMaker.make(pd,tmp);
    DProjectEditor dlg = new DProjectEditor(ownerFrame,pd,slipManager);
    dlg.show();
    if (dlg.isOk())
        manager.comitProjectData( pd );
    updateProjectList();
  }//GEN-LAST:event_copyButtonActionPerformed

  private void projectListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_projectListMouseClicked
// Add your handling code here:
    if (evt.getClickCount() == 2)
        modButtonActionPerformed(null);
  }//GEN-LAST:event_projectListMouseClicked

  private void jButton1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    // Add your handling code here:
    onOk();
  }//GEN-LAST:event_jButton1ActionPerformed

  private void delButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delButtonActionPerformed
    // Add your handling code here:
    int i = projectList.getSelectedIndex();
    if (i == -1) return;
    ProjectData pd = parray[i];
    String [] arg = {pd.getName()};
    String mes = java.text.MessageFormat.format(SystemUtil.getResourceString("RemoveConfirm"),arg);
    int ps = JOptionPane.showConfirmDialog(this,mes,SystemUtil.getResourceString("Confirm"), JOptionPane.YES_NO_OPTION);
    if (ps == JOptionPane.YES_OPTION) {
        try {
            manager.removeProject(pd.getId());
        }catch(DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("ProjectLockError"));
	    return;
        }
    }
    updateProjectList();
  }//GEN-LAST:event_delButtonActionPerformed

  private void modButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modButtonActionPerformed
    // Add your handling code here:
    int i = projectList.getSelectedIndex();
    if (i == -1) return;
    ProjectData pd = null;
    try {
        pd = manager.lockProjectData( parray[i].getId() );
    }catch(DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("ProjectLockError"));
	    return;
    }
    DProjectEditor dlg = new DProjectEditor(ownerFrame,pd,slipManager);
    dlg.show();
    if (dlg.isOk()) {
        manager.comitProjectData( pd );
    } else {
        manager.cancelProjectData( pd );
    }
    updateProjectList();
  }//GEN-LAST:event_modButtonActionPerformed

  private void addButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
    // Add your handling code here:
    ProjectData pd = manager.makeProject("NewProject","project comment");
    String defaultSource = manager.getParent().getProjectResourceFilename();
    DProjectSource pdlg = new DProjectSource(ownerFrame,defaultSource);
    pdlg.show();
    if (pdlg.isOk()) {
        defaultSource = pdlg.getSource();
    } else return;
    ProjectMaker.make(pd,defaultSource);
    DProjectEditor dlg = new DProjectEditor(ownerFrame,pd,slipManager);
    dlg.show();
    if (dlg.isOk())
        manager.comitProjectData(pd);
    updateProjectList();
  }//GEN-LAST:event_addButtonActionPerformed

/** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

    ProjectData [] parray;
    private void updateProjectList() {
	SecurityManager sm = manager.getParent().getSecurityManager();
        List projects = manager.getProjects();
	List sum = new LinkedList();
        for(int i=0;i<projects.size();i++) {
	    ProjectData pd = (ProjectData)projects.get(i);
	    if (sm.getPermission(session,pd.getId(),SecurityManager.EDITABLE))
		sum.add(pd);
	}
        parray = new ProjectData[sum.size()];
        for(int i=0;i<parray.length;i++) {
	    parray[i] = (ProjectData)sum.get(i);
	}
	projectList.setListData(parray);
    }

    private void userButton() {
	SecurityManager sm = manager.getParent().getSecurityManager();
	if (!sm.getAdminPermission(session)) {
	    addButton.setEnabled(false);
	    delButton.setEnabled(false);
	    copyButton.setEnabled(false);
	}
    }

    void onOk() {
	dispose();
    }

/**
 * @param args the command line arguments
 */
public static void main (String args[]) {
    new DProjectManager (new javax.swing.JFrame (), true).show ();
}


// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okButton;
private javax.swing.JPanel jPanel6;
private javax.swing.JScrollPane jScrollPane3;
private javax.swing.JList projectList;
private javax.swing.JPanel jPanel7;
private javax.swing.JButton addButton;
private javax.swing.JButton modButton;
private javax.swing.JButton delButton;
private javax.swing.JButton copyButton;
private javax.swing.JButton extButton;
private javax.swing.JLabel titleLabel;
// ϐ錾̏I//GEN-END:variables

}
