/*
 * DProjectSource.java
 *
 * Created on 2000/05/09, 14:11
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.text.*;
import java.io.File;
import java.util.*;
import arg.money.*;
import java.awt.Frame;
import jp.gr.java_conf.ccs2.util.ExtensionFileFilter;


/** 
 *
 * @author  sakurai
 * @version 
 */
public class DProjectSource extends javax.swing.JDialog {

    Frame parent;
    String source;
    boolean ok = false;
    
    public DProjectSource(Frame f,String defaultSource) {
        this(f,true);
        source = defaultSource;
        chooseText.setText(defaultSource);
        SubjectsUtil.setCenter(this);
    }
    
    public void show() {
        ok = false;
        super.show();
    }
    public String getSource() {return source;}
    public boolean isOk() {return ok;}
    
  /** Creates new form DProjectSource */
  public DProjectSource(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    jLabel1 = new javax.swing.JLabel ();
    jPanel1 = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    cancelButton = new javax.swing.JButton ();
    jPanel2 = new javax.swing.JPanel ();
    chooseText = new javax.swing.JTextField ();
    chooseButton = new javax.swing.JButton ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );

    jLabel1.setText (SystemUtil.getResourceString("ProjectSource"));
    jLabel1.setFont (new java.awt.Font ("Serif", 0, 24));


    getContentPane ().add (jLabel1, java.awt.BorderLayout.NORTH);


      okButton.setText (SystemUtil.getResourceString("Ok"));
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel1.add (okButton);
  
      cancelButton.setToolTipText ("");
      cancelButton.setText (SystemUtil.getResourceString("Cancel"));
      cancelButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              cancelButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel1.add (cancelButton);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);


      chooseText.setColumns (35);
      chooseText.setText ("jTextField1");
  
      jPanel2.add (chooseText);
  
      chooseButton.setText (SystemUtil.getResourceString("Choose"));
      chooseButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              chooseButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel2.add (chooseButton);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.CENTER);

}//GEN-END:initComponents

  private void chooseButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseButtonActionPerformed
// Add your handling code here:
    JFileChooser chooser = new JFileChooser();
    ExtensionFileFilter filter = new ExtensionFileFilter("def");
    chooser.setFileFilter(filter);
    chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
    int returnVal = chooser.showOpenDialog(parent);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
        chooseText.setText(chooser.getSelectedFile().getPath());
    }
  }//GEN-LAST:event_chooseButtonActionPerformed

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
// Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
    ok = true;
    source = chooseText.getText();
    dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new DProjectSource (new javax.swing.JFrame (), true).show ();
  }


// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JLabel jLabel1;
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
private javax.swing.JPanel jPanel2;
private javax.swing.JTextField chooseText;
private javax.swing.JButton chooseButton;
// End of variables declaration//GEN-END:variables

}
