/*
 * DSecurityManager.java
 *
 * Created on 2000/03/12, 18:17
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.Frame;
import javax.swing.*;
import arg.money.*;
import java.util.*;
import java.text.*;
import arg.money.SecurityManager;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class DSecurityManager extends javax.swing.JDialog {

  SecurityManager manager;
  Frame parentFrame;
  
    public DSecurityManager(Frame p,SecurityManager m) {
	this(p,true);
	p = parentFrame;
	manager = m;
	initData();
        SubjectsUtil.setCenter(this);
    }
    
    void initData() {
	//init userlist
	updateUserList();
	userList.setSelectedIndex(0);
	
	//init grouplist
	updateGroupList();
        selectGroup(0);
	pack();
    }
    
    UserData [] uarray;
    void updateUserList() {
	UserManager um = manager.getUserManager();
	List users = um.getUsers();
	uarray = new UserData[users.size()];
	String [] rows = new String[users.size()];
	for (int i=0;i<users.size();i++) {
	    uarray[i] = (UserData)users.get(i);
	    rows[i] = uarray[i].getName()+" ["+uarray[i].getComment()+"]";
	}
	userList.setListData(rows);
    }
    
    GroupData [] garray;
    void updateGroupList() {
	GroupManager um = manager.getGroupManager();
	List groups = um.getGroups();
	garray = new GroupData[groups.size()];
	for (int i=0;i<groups.size();i++) {
	    GroupData g = (GroupData)groups.get(i);
	    garray[i] = g;
	}
	groupList.setListData(garray);
    }

    void selectGroup(int i) {
	if (i<0) return;
	if (i>=garray.length) return;
	GroupManager gm = manager.getGroupManager();
	UserManager um = manager.getUserManager();
	List groups = gm.getGroups();
	//
	GroupData g = garray[i];
	gCommentText.setText(g.getComment());
	gCommentText.setEditable(false);
	StringBuffer sb = new StringBuffer();
	List users = g.getUsers();
	Iterator it = users.iterator();
	while(it.hasNext()) {
	    NumberIdentical n = (NumberIdentical)it.next();
	    UserData u = um.getUser(n.getId());
	    sb.append(u.getName()).append(" ");
	}
	gMemberText.setText(sb.toString());
	gMemberText.setEditable(false);
	//
	ProjectManager pm = manager.getParent().getProjectManager();
	List projects = pm.getProjects();
	String [] array = new String[projects.size()];
	for (int j=0;j<projects.size();j++) {
	    ProjectData d = (ProjectData)projects.get(j);
	    sb = new StringBuffer();
	    sb.append(d.getName());
	    for (int k=0;k<GroupData.masks.length;k++)
		if (g.isPermitted(d.getId(),GroupData.masks[k])) 
		    sb.append(" : ["+
			      SystemUtil.getResourceString(
				  GroupData.resourceStrings[k])+"]");
	    array[j] = sb.toString();
	}
	projectsList.setListData(array);
    }
  
  /** Creates new form DSecurityManager */
  public DSecurityManager(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    jTab.setTitleAt(0,SystemUtil.getResourceString("UserData"));
    jTab.setTitleAt(1,SystemUtil.getResourceString("GroupData")); 
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    jLabel1 = new javax.swing.JLabel ();
    jTab = new javax.swing.JTabbedPane ();
    userPanel = new javax.swing.JPanel ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    userList = new javax.swing.JList ();
    jPanel3 = new javax.swing.JPanel ();
    userAddButton = new javax.swing.JButton ();
    userModButton = new javax.swing.JButton ();
    userDelButton = new javax.swing.JButton ();
    jPanel4 = new javax.swing.JPanel ();
    groupListPanel = new javax.swing.JPanel ();
    jScrollPane2 = new javax.swing.JScrollPane ();
    groupList = new javax.swing.JList ();
    aboutPanel = new javax.swing.JPanel ();
    comPanel = new javax.swing.JPanel ();
    gCommentText = new javax.swing.JTextField ();
    memPanel = new javax.swing.JPanel ();
    gMemberText = new javax.swing.JTextField ();
    axsPanel = new javax.swing.JPanel ();
    jScrollPane3 = new javax.swing.JScrollPane ();
    projectsList = new javax.swing.JList ();
    jPanel11 = new javax.swing.JPanel ();
    addGButton = new javax.swing.JButton ();
    modGButton = new javax.swing.JButton ();
    delGButton = new javax.swing.JButton ();
    jPanel1 = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );

    jLabel1.setText (SystemUtil.getResourceString("SecurityManager"));
    jLabel1.setFont (new java.awt.Font ("Serif", 0, 36));


    getContentPane ().add (jLabel1, java.awt.BorderLayout.NORTH);

    jTab.setName ("GroupPanel");
    jTab.setFont (new java.awt.Font ("Serif", 0, 14));

      userPanel.setLayout (new java.awt.BorderLayout (5, 5));
      userPanel.setName ("UserPanel");
  
    
          userList.addMouseListener (new java.awt.event.MouseAdapter () {
              public void mouseClicked (java.awt.event.MouseEvent evt) {
                  userListMouseClicked (evt);
              }
          }
          );
      
          jScrollPane1.setViewportView (userList);
      
        userPanel.add (jScrollPane1, java.awt.BorderLayout.CENTER);
    
        jPanel3.setLayout (new javax.swing.BoxLayout (jPanel3, 1));
    
          userAddButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/New24.gif")));
          userAddButton.setFont (new java.awt.Font ("Serif", 0, 14));
          userAddButton.setText (SystemUtil.getResourceString("Add"));
          userAddButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  userAddButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel3.add (userAddButton);
      
          userModButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Edit24.gif")));
          userModButton.setFont (new java.awt.Font ("Serif", 0, 14));
          userModButton.setText (SystemUtil.getResourceString("Modify"));
          userModButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  userModButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel3.add (userModButton);
      
          userDelButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Delete24.gif")));
          userDelButton.setForeground (java.awt.Color.red);
          userDelButton.setFont (new java.awt.Font ("Serif", 0, 14));
          userDelButton.setText (SystemUtil.getResourceString("Delete"));
          userDelButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  userDelButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel3.add (userDelButton);
      
        userPanel.add (jPanel3, java.awt.BorderLayout.EAST);
    
      jTab.addTab ("jPanel2", userPanel);
  
      jPanel4.setLayout (new java.awt.BorderLayout ());
  
        groupListPanel.setLayout (new javax.swing.BoxLayout (groupListPanel, 1));
        groupListPanel.setBorder (new javax.swing.border.TitledBorder(
        new javax.swing.border.EtchedBorder(), "Choose groups", 4, 2,
        new java.awt.Font ("SansSerif", 0, 12), java.awt.Color.black));
        SubjectsUtil.borderTitle(groupListPanel,SystemUtil.getResourceString("ChooseGroup"));
    
      
            groupList.setFixedCellWidth (150);
            groupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                    groupListValueChanged (evt);
                }
            }
            );
            groupList.addMouseListener (new java.awt.event.MouseAdapter () {
                public void mouseClicked (java.awt.event.MouseEvent evt) {
                    groupListMouseClicked (evt);
                }
            }
            );
        
            jScrollPane2.setViewportView (groupList);
        
          groupListPanel.add (jScrollPane2);
      
        jPanel4.add (groupListPanel, java.awt.BorderLayout.WEST);
    
        aboutPanel.setLayout (new javax.swing.BoxLayout (aboutPanel, 1));
        aboutPanel.setBorder (new javax.swing.border.TitledBorder("About group"));
        SubjectsUtil.borderTitle(aboutPanel,SystemUtil.getResourceString("AboutPanel"));
    
          comPanel.setBorder (new javax.swing.border.TitledBorder("Comment"));
          SubjectsUtil.borderTitle(comPanel,SystemUtil.getResourceString("GroupComment"));
      
            gCommentText.setColumns (40);
            gCommentText.setText ("jTextField1");
            gCommentText.setBackground (new java.awt.Color (237, 237, 237));
        
            comPanel.add (gCommentText);
        
          aboutPanel.add (comPanel);
      
          memPanel.setBorder (new javax.swing.border.TitledBorder("Members"));
          SubjectsUtil.borderTitle(memPanel,SystemUtil.getResourceString("GroupMember"));
      
            gMemberText.setColumns (40);
            gMemberText.setText ("jTextField2");
            gMemberText.setBackground (new java.awt.Color (237, 237, 237));
        
            memPanel.add (gMemberText);
        
          aboutPanel.add (memPanel);
      
          axsPanel.setLayout (new java.awt.BorderLayout ());
          axsPanel.setBorder (new javax.swing.border.TitledBorder("Access"));
          SubjectsUtil.borderTitle(axsPanel,SystemUtil.getResourceString("AccessPanel"));
      
        
              projectsList.setBackground (new java.awt.Color (237, 237, 237));
          
              jScrollPane3.setViewportView (projectsList);
          
            axsPanel.add (jScrollPane3, java.awt.BorderLayout.CENTER);
        
          aboutPanel.add (axsPanel);
      
        jPanel4.add (aboutPanel, java.awt.BorderLayout.CENTER);
    
    
          addGButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/New24.gif")));
          addGButton.setFont (new java.awt.Font ("Serif", 0, 12));
          addGButton.setText (SystemUtil.getResourceString("AddGroup"));
          addGButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  addGButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel11.add (addGButton);
      
          modGButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Edit24.gif")));
          modGButton.setFont (new java.awt.Font ("Serif", 0, 12));
          modGButton.setText (SystemUtil.getResourceString("ModGroup"));
          modGButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  modGButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel11.add (modGButton);
      
          delGButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Delete24.gif")));
          delGButton.setForeground (java.awt.Color.red);
          delGButton.setFont (new java.awt.Font ("Serif", 0, 12));
          delGButton.setText (SystemUtil.getResourceString("DelGroup"));
          delGButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  delGButtonActionPerformed (evt);
              }
          }
          );
      
          jPanel11.add (delGButton);
      
        jPanel4.add (jPanel11, java.awt.BorderLayout.SOUTH);
    
      jTab.addTab ("jPanel4", jPanel4);
  

    getContentPane ().add (jTab, java.awt.BorderLayout.CENTER);


      okButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Stop24.gif")));
      okButton.setFont (new java.awt.Font ("Serif", 0, 14));
      okButton.setText (SystemUtil.getResourceString("Exit"));
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel1.add (okButton);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

}//GEN-END:initComponents

  private void userListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_userListMouseClicked
// Add your handling code here:
    if (evt.getClickCount() == 2)
        userModButtonActionPerformed(null);
  }//GEN-LAST:event_userListMouseClicked

  private void groupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_groupListMouseClicked
// Add your handling code here:
    int i = getSelected();
    if (i>=0) selectGroup(i);
    if (evt.getClickCount() == 2)
        modGButtonActionPerformed(null);
  }//GEN-LAST:event_groupListMouseClicked

  private void groupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_groupListValueChanged
// Add your handling code here:
    int i = getSelected();
    if (i>=0) selectGroup(i);
  }//GEN-LAST:event_groupListValueChanged

  private void userDelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_userDelButtonActionPerformed
// Add your handling code here:
      int i = userList.getSelectedIndex();
      if (i<0 || i>=uarray.length) return;
      UserData u = uarray[i];
      String mes = SystemUtil.getResourceString("RemoveConfirm");
      MessageFormat pattform = new MessageFormat(mes);
      String [] a = {u.getName()};
      int ret = JOptionPane.showConfirmDialog(this,pattform.format(a), "Remove?", JOptionPane.YES_NO_OPTION);
      if (ret == JOptionPane.YES_OPTION) {
          manager.getUserManager().removeUser(u.getId());
	  updateUserList();
      }
	
  }//GEN-LAST:event_userDelButtonActionPerformed

  private void userModButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_userModButtonActionPerformed
// Add your handling code here:
    int i = userList.getSelectedIndex();
    UserManager um = manager.getUserManager();
    if (i>=0 && uarray.length>i) {
        UserData u = uarray[i];
        DUserEditor dlg = new DUserEditor(parentFrame,u);
        dlg.show();
        updateUserList();
      }
  }//GEN-LAST:event_userModButtonActionPerformed

  private void userAddButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_userAddButtonActionPerformed
// Add your handling code here:
    UserManager um = manager.getUserManager();
    UserData u = um.addUser(SystemUtil.getResourceString("DefaultUserName"),SystemUtil.getResourceString("DefaultUserComment"),"");
    DUserEditor dlg = new DUserEditor(parentFrame,u);
    dlg.show();
    if (!dlg.isOk()) {
      um.removeUser(u.getId());
      return;
    }
     updateUserList();
  }//GEN-LAST:event_userAddButtonActionPerformed

  private void delGButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delGButtonActionPerformed
// Add your handling code here:
    int i = getSelected();
    GroupManager gm = manager.getGroupManager();
    if (i>=0 && garray.length>i) {
        GroupData g = garray[i];
        if (g == null) {
            System.err.println("Group not found.");
            return;
        }
        String mes = SystemUtil.getResourceString("RemoveConfirm");
        MessageFormat pattform = new MessageFormat(mes);
        String [] a = {g.getName()};
        int ret = JOptionPane.showConfirmDialog(this,pattform.format(a), SystemUtil.getResourceString("Remove"),
                                                JOptionPane.YES_NO_OPTION);
        if (ret == JOptionPane.YES_OPTION) {
          gm.removeGroup(g.getId());
          updateGroupList();
        }
    }
  }//GEN-LAST:event_delGButtonActionPerformed

  private void modGButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modGButtonActionPerformed
// Add your handling code here:
    int i = getSelected();
    GroupManager gm = manager.getGroupManager();
    if (i>=0 && garray.length>i) {
        GroupData g = garray[i];
        DGroupEditor dlg = new DGroupEditor(parentFrame,g,manager);
        dlg.show();
        updateGroupList();
        selectGroup(i);
      }
  }//GEN-LAST:event_modGButtonActionPerformed

  private void addGButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addGButtonActionPerformed
// Add your handling code here:
    GroupManager gm = manager.getGroupManager();
    GroupData g = gm.addGroup(SystemUtil.getResourceString("DefaultGroupName"),
        SystemUtil.getResourceString("DefaultGroupComment"));
    DGroupEditor dlg = new DGroupEditor(parentFrame,g,manager);
    dlg.show();
    if (!dlg.isOk()) {
      gm.removeGroup(g.getId());
      return;
    }
     updateGroupList();
     selectGroup(garray.length-1);
  }//GEN-LAST:event_addGButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
      manager.update();
      dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new DSecurityManager (new javax.swing.JFrame (), true).show ();
  }

  int getSelected() {
    return groupList.getSelectedIndex();
  }
  
// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JLabel jLabel1;
private javax.swing.JTabbedPane jTab;
private javax.swing.JPanel userPanel;
private javax.swing.JScrollPane jScrollPane1;
private javax.swing.JList userList;
private javax.swing.JPanel jPanel3;
private javax.swing.JButton userAddButton;
private javax.swing.JButton userModButton;
private javax.swing.JButton userDelButton;
private javax.swing.JPanel jPanel4;
private javax.swing.JPanel groupListPanel;
private javax.swing.JScrollPane jScrollPane2;
private javax.swing.JList groupList;
private javax.swing.JPanel aboutPanel;
private javax.swing.JPanel comPanel;
private javax.swing.JTextField gCommentText;
private javax.swing.JPanel memPanel;
private javax.swing.JTextField gMemberText;
private javax.swing.JPanel axsPanel;
private javax.swing.JScrollPane jScrollPane3;
private javax.swing.JList projectsList;
private javax.swing.JPanel jPanel11;
private javax.swing.JButton addGButton;
private javax.swing.JButton modGButton;
private javax.swing.JButton delGButton;
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okButton;
// ϐ錾̏I//GEN-END:variables

}
