/*
 * DSubject.java
 *
 * Created on 2000/03/14, 19:39
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import javax.swing.*;
import java.awt.*;
import java.text.*;
import arg.money.*;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class DSubject extends javax.swing.JDialog {

    protected NameCommentObject object;
    protected boolean ok = false;
  
    public DSubject(Frame parent,String message,String title,
		    String comment,NameCommentObject nc) {
	this(parent,true);
	// IME
	titleText.addFocusListener(SystemUtil.getIMEvent());
	commentText.addFocusListener(SystemUtil.getIMEvent());
	if (title != null)
	    titleLabel.setText(title);
	if (comment != null)
	    commentLabel.setText(comment);
	if (message != null) 
	    dialogMessage.setText(message);
	if (nc != null) {
	    titleText.setText(nc.getName());
	    commentText.setText(nc.getComment());
	    object = nc;
	} else {
	    System.err.println("NameCommentObject is null...");
	}
	initGui();
	pack();
        SubjectsUtil.setCenter(this);
    }
    
    int [] values = SystemUtil.getSpecialValues();
    String [] labels = SystemUtil.getSpecialLabels();

    JComboBox specialBox;
    protected void initGui() {
	if (object instanceof Subject) {
	    //special label
	    JPanel panel = new JPanel();
	    panel.add(new JLabel(SystemUtil.getResourceString("SpecialSubject")));
	    String [] items = new String[labels.length];
	    for(int i=0;i<labels.length;i++)
		items[i] = SystemUtil.getResourceString(labels[i]);
	    specialBox = new JComboBox(items);
	    panel.add(specialBox);
	    getCenterPanel().add(panel);
	    Subject sx = (Subject)object;
	    for (int i=0;i<values.length;i++)
		if (values[i] == sx.getSpecialLabel())
		    specialBox.setSelectedIndex(i);
	}
    }
    
    protected javax.swing.JPanel getCenterPanel() {return centerPanel;}

  /** Creates new form DSubject */
  public DSubject(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    dialogMessage = new javax.swing.JLabel ();
    centerPanel = new javax.swing.JPanel ();
    titlePanel = new javax.swing.JPanel ();
    titleLabel = new javax.swing.JLabel ();
    titleText = new javax.swing.JTextField ();
    comPanel = new javax.swing.JPanel ();
    commentLabel = new javax.swing.JLabel ();
    commentText = new javax.swing.JTextField ();
    southPanel = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    cancelButton = new javax.swing.JButton ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );

    dialogMessage.setText ("jLabel1");


    getContentPane ().add (dialogMessage, java.awt.BorderLayout.NORTH);

    centerPanel.setLayout (new javax.swing.BoxLayout (centerPanel, 1));
    centerPanel.setBorder (new javax.swing.border.EtchedBorder());

      titlePanel.setBorder (new javax.swing.border.EtchedBorder());
  
        titleLabel.setText ("Title");
    
        titlePanel.add (titleLabel);
    
        titleText.setColumns (20);
        titleText.setText ("jTextField1");
        titleText.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                titleTextActionPerformed (evt);
            }
        }
        );
    
        titlePanel.add (titleText);
    
      centerPanel.add (titlePanel);
  
      comPanel.setBorder (new javax.swing.border.EtchedBorder());
  
        commentLabel.setText ("Comment");
    
        comPanel.add (commentLabel);
    
        commentText.setColumns (25);
        commentText.setText ("jTextField2");
        commentText.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                commentTextActionPerformed (evt);
            }
        }
        );
    
        comPanel.add (commentText);
    
      centerPanel.add (comPanel);
  

    getContentPane ().add (centerPanel, java.awt.BorderLayout.CENTER);


      okButton.setText (SystemUtil.getResourceString("Ok"));
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      southPanel.add (okButton);
  
      cancelButton.setText (SystemUtil.getResourceString("Cancel"));
      cancelButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              cancelButtonActionPerformed (evt);
          }
      }
      );
  
      southPanel.add (cancelButton);
  

    getContentPane ().add (southPanel, java.awt.BorderLayout.SOUTH);

}//GEN-END:initComponents

  private void commentTextActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commentTextActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_commentTextActionPerformed

  private void titleTextActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_titleTextActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_titleTextActionPerformed

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
// Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new DSubject (new javax.swing.JFrame (), true).show ();
  }

    private void onOk() {
	String n = titleText.getText();
	if (n.length()==0) {
	    String mes = "Input {0}.";
	    MessageFormat pattform = new MessageFormat(mes);
	    String [] a = {titleText.getText()};
	    javax.swing.JOptionPane.showMessageDialog(this,pattform.format(a));
	    return;
	}
	object.setName(n);
	object.setComment(commentText.getText());
	// for subject
	if (object instanceof Subject) {
	    Subject sx = (Subject)object;
	    int [] values = SystemUtil.getBalanceGroupValues();
            int ps = specialBox.getSelectedIndex();
	    if (ps >= 0)
		sx.setSpecialLabel(values[ps]);
	    else
		System.err.println("Invalid combobox selection in DSubjectGroup");
	}
	dispose();
	ok = true;
    }
  
  public boolean isOk() {
    return ok;
  }

// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JLabel dialogMessage;
private javax.swing.JPanel centerPanel;
private javax.swing.JPanel titlePanel;
private javax.swing.JLabel titleLabel;
private javax.swing.JTextField titleText;
private javax.swing.JPanel comPanel;
private javax.swing.JLabel commentLabel;
private javax.swing.JTextField commentText;
private javax.swing.JPanel southPanel;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
// ϐ錾̏I//GEN-END:variables

}
