/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.text.*;
import javax.swing.*;
import arg.money.*;

public class DSubjectGroup extends DSubject{

    int balanceGroup;

    public DSubjectGroup(Frame p,String message,String title,String comment,
			 NameCommentObject nc,int bg) {
        super(p,message,title,comment,nc);
        balanceGroup = bg;
        subInit();
    }

    int [] values;
    String [] labels;

    JComboBox groupBox;
    protected void initGui() {
	values = SystemUtil.getBalanceGroupValues();
	labels = SystemUtil.getBalanceGroupLabels();
	//balance group
        JPanel panel = new JPanel();
	panel.add(new JLabel(SystemUtil.getResourceString("BalanceGroup")));
	String [] items = new String[labels.length];
	for(int i=0;i<labels.length;i++)
	    items[i] = SystemUtil.getResourceString(labels[i]);
        groupBox = new JComboBox(items);
        panel.add(groupBox);
        getCenterPanel().add(panel);
    }
    
    void subInit() {
	for (int i=0;i<values.length;i++)
	    if (values[i] == balanceGroup) {
		groupBox.setSelectedIndex(i);
		return;
	    }
	System.err.println("invalid balance group id");
    }

    public int getBalanceGroup() {
        if (isOk()) {
	    int [] values = SystemUtil.getBalanceGroupValues();
            int ps = groupBox.getSelectedIndex();
	    if (ps >= 0)
		return values[ps];
	    System.err.println("Invalid combobox selection in DSubjectGroup");
        }
        return balanceGroup;
    }

}
