/*
 * DSubjectSelect.java
 *
 * Created on 2000/04/21, 3:31
 */

/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.Frame;
import javax.swing.*;
import java.text.*;
import java.util.*;
import arg.money.*;

/**
 *
 * @author  sakurai
 * @version
 */
public class DSubjectSelect extends javax.swing.JDialog {

    boolean ok = false;
    int id = -1;
    ProjectData project;
    SubjectsUtil utils;

    public DSubjectSelect(Frame frame,ProjectData p) {
        this(frame,true);
        project = p;

        utils = new SubjectsUtil(project,groupList,subgroupList,subjectList,
        new jp.gr.java_conf.ccs2.comp.MessageListener() {
            public void message(String a,int id,Object n) {
                updateId();
            }
        });
        updateId();
    }

    /** Creates new form DSubjectSelect */
    public DSubjectSelect(java.awt.Frame parent,boolean modal) {
        super (parent, modal);
        initComponents ();
        pack ();
    }

    public int getId() {
        return id;
    }
    public boolean isOk() {
        return ok;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        titleLabel = new javax.swing.JLabel ();
        mainPanel = new javax.swing.JPanel ();
        groupPanel = new javax.swing.JPanel ();
        jScrollPane1 = new javax.swing.JScrollPane ();
        groupList = new javax.swing.JList ();
        groupLabel = new javax.swing.JLabel ();
        subgroupPanel = new javax.swing.JPanel ();
        jScrollPane2 = new javax.swing.JScrollPane ();
        subgroupList = new javax.swing.JList ();
        subgroupLabel = new javax.swing.JLabel ();
        subjectPanel = new javax.swing.JPanel ();
        jScrollPane3 = new javax.swing.JScrollPane ();
        subjectList = new javax.swing.JList ();
        subjectLabel = new javax.swing.JLabel ();
        southPanel = new javax.swing.JPanel ();
        okButton = new javax.swing.JButton ();
        cancelButton = new javax.swing.JButton ();
        setResizable (false);
        addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
                closeDialog (evt);
            }
        }
        );

        titleLabel.setText (SystemUtil.getResourceString("SubjectSelection"));
        titleLabel.setFont (new java.awt.Font ("Serif", 0, 36));


        getContentPane ().add (titleLabel, java.awt.BorderLayout.NORTH);

        mainPanel.setLayout (new java.awt.GridLayout (1, 3));

          groupPanel.setLayout (new java.awt.BorderLayout ());
          groupPanel.setBorder (new javax.swing.border.TitledBorder(
          new javax.swing.border.EtchedBorder(), "Group"));
          SubjectsUtil.borderTitle(groupPanel,SystemUtil.getResourceString("Group"));
  
    
              groupList.setVisibleRowCount (12);
              groupList.setMaximumSize (new java.awt.Dimension(120, 240));
              groupList.setMinimumSize (new java.awt.Dimension(120, 240));
              groupList.setFixedCellWidth (150);
              groupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      groupListKeyPressed (evt);
                  }
              }
              );
              groupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      groupListValueChanged (evt);
                  }
              }
              );
              groupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      groupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane1.setViewportView (groupList);
      
            groupPanel.add (jScrollPane1, java.awt.BorderLayout.CENTER);
    
            groupLabel.setMaximumSize (new java.awt.Dimension(180, 16));
            groupLabel.setAlignmentX (0.5F);
            groupLabel.setMinimumSize (new java.awt.Dimension(180, 16));
            groupLabel.setForeground (java.awt.Color.white);
            groupLabel.setHorizontalAlignment (javax.swing.SwingConstants.LEFT);
    
            groupPanel.add (groupLabel, java.awt.BorderLayout.SOUTH);
    
          mainPanel.add (groupPanel);
  
          subgroupPanel.setLayout (new java.awt.BorderLayout ());
          subgroupPanel.setBorder (new javax.swing.border.TitledBorder(
          new javax.swing.border.EtchedBorder(), "Subgroup"));
          SubjectsUtil.borderTitle(subgroupPanel,SystemUtil.getResourceString("Subgroup"));
  
    
              subgroupList.setVisibleRowCount (12);
              subgroupList.setMaximumSize (new java.awt.Dimension(120, 240));
              subgroupList.setMinimumSize (new java.awt.Dimension(120, 240));
              subgroupList.setFixedCellWidth (150);
              subgroupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subgroupListKeyPressed (evt);
                  }
              }
              );
              subgroupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subgroupListValueChanged (evt);
                  }
              }
              );
              subgroupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subgroupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane2.setViewportView (subgroupList);
      
            subgroupPanel.add (jScrollPane2, java.awt.BorderLayout.CENTER);
    
            subgroupLabel.setMaximumSize (new java.awt.Dimension(180, 16));
            subgroupLabel.setAlignmentX (0.5F);
            subgroupLabel.setMinimumSize (new java.awt.Dimension(180, 16));
            subgroupLabel.setForeground (java.awt.Color.white);
            subgroupLabel.setHorizontalAlignment (javax.swing.SwingConstants.LEFT);
    
            subgroupPanel.add (subgroupLabel, java.awt.BorderLayout.SOUTH);
    
          mainPanel.add (subgroupPanel);
  
          subjectPanel.setLayout (new java.awt.BorderLayout ());
          subjectPanel.setBorder (new javax.swing.border.TitledBorder(
          new javax.swing.border.EtchedBorder(), "Subject"));
          SubjectsUtil.borderTitle(subjectPanel,SystemUtil.getResourceString("Subject"));
  
    
              subjectList.setVisibleRowCount (12);
              subjectList.setMaximumSize (new java.awt.Dimension(120, 240));
              subjectList.setMinimumSize (new java.awt.Dimension(120, 240));
              subjectList.setFixedCellWidth (150);
              subjectList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subjectListKeyPressed (evt);
                  }
                  public void keyTyped (java.awt.event.KeyEvent evt) {
                      subjectListKeyTyped (evt);
                  }
              }
              );
              subjectList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subjectListValueChanged (evt);
                  }
              }
              );
              subjectList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subjectListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane3.setViewportView (subjectList);
      
            subjectPanel.add (jScrollPane3, java.awt.BorderLayout.CENTER);
    
            subjectLabel.setMaximumSize (new java.awt.Dimension(180, 16));
            subjectLabel.setAlignmentX (0.5F);
            subjectLabel.setMinimumSize (new java.awt.Dimension(180, 16));
            subjectLabel.setForeground (java.awt.Color.white);
            subjectLabel.setHorizontalAlignment (javax.swing.SwingConstants.LEFT);
    
            subjectPanel.add (subjectLabel, java.awt.BorderLayout.SOUTH);
    
          mainPanel.add (subjectPanel);
  

        getContentPane ().add (mainPanel, java.awt.BorderLayout.CENTER);


          okButton.setText (SystemUtil.getResourceString("Ok"));
          okButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed (evt);
              }
          }
          );
  
          southPanel.add (okButton);
  
          cancelButton.setText (SystemUtil.getResourceString("Cancel"));
          cancelButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed (evt);
              }
          }
          );
  
          southPanel.add (cancelButton);
  

        getContentPane ().add (southPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

  private void subjectListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subjectListMouseClicked
    // Add your handling code here:
    updateId();
  }//GEN-LAST:event_subjectListMouseClicked

  private void subjectListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subjectListValueChanged
    // Add your handling code here:
    updateId();
  }//GEN-LAST:event_subjectListValueChanged

  private void subgroupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subgroupListMouseClicked
    // Add your handling code here:
    utils.updateSubjectList();
  }//GEN-LAST:event_subgroupListMouseClicked

  private void subgroupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subgroupListValueChanged
    // Add your handling code here:
    utils.updateSubjectList();
  }//GEN-LAST:event_subgroupListValueChanged

  private void groupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_groupListMouseClicked
    // Add your handling code here:
    utils.updateSubgroupList();
  }//GEN-LAST:event_groupListMouseClicked

  private void groupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_groupListValueChanged
    // Add your handling code here:
    utils.updateSubgroupList();
  }//GEN-LAST:event_groupListValueChanged

  private void groupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_groupListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_RIGHT) {
        subgroupList.requestFocus();
        if (subgroupList.getModel().getSize() != 0)
        subgroupList.setSelectedIndex(0);
    }
  }//GEN-LAST:event_groupListKeyPressed

  private void subjectListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subjectListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_LEFT) {
        subgroupList.requestFocus();
        if (subgroupList.getModel().getSize() != 0)
        subgroupList.setSelectedIndex(0);
    }
  }//GEN-LAST:event_subjectListKeyPressed

  private void subgroupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subgroupListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_RIGHT) {
        subjectList.requestFocus();
        if (subjectList.getModel().getSize() != 0)
        subjectList.setSelectedIndex(0);
    }
    if (evt.getKeyCode() == evt.VK_LEFT) {
        groupList.requestFocus();
        if (groupList.getModel().getSize() != 0)
        groupList.setSelectedIndex(0);
    }
  }//GEN-LAST:event_subgroupListKeyPressed

  private void subjectListKeyTyped (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subjectListKeyTyped
    // Add your handling code here:
    if (evt.getKeyChar() == '\n')
    onOk();
  }//GEN-LAST:event_subjectListKeyTyped

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    // Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    // Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

/** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

void onOk() {
    updateId();
    if (id == -1) return;
    ok = true;
    dispose();
}

    void updateId() {
	if (utils != null)  {
	    SubjectGroup sg = utils.getSelectedGroup();
	    String a = "";
	    if (sg != null)
		a = sg.getComment();
	    groupLabel.setText(a);
	    a = "";
	    SubjectSubgroup ssg = utils.getSelectedSubgroup();
	    if (ssg != null)
		a = ssg.getComment();
	    subgroupLabel.setText(a);
	    Subject sj = utils.getSelectedSubject();
	    a = "";
	    if (sj != null)
		a = sj.getComment();
	    subjectLabel.setText(a);
	    id = utils.getSelectedSubject().getId();
	}
    }
/**
 * @param args the command line arguments
 */
public static void main (String args[]) {
    ProjectData pd = new ProjectData(0,"Project","test project");
    ProjectMaker.make(pd, null);
    DSubjectSelect dlg = new DSubjectSelect (new javax.swing.JFrame (),pd);
    while (!dlg.isOk())
    dlg.show();
    System.out.println(pd.getSubject(dlg.getId())+" was selected.");
}


// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JLabel titleLabel;
private javax.swing.JPanel mainPanel;
private javax.swing.JPanel groupPanel;
private javax.swing.JScrollPane jScrollPane1;
private javax.swing.JList groupList;
private javax.swing.JLabel groupLabel;
private javax.swing.JPanel subgroupPanel;
private javax.swing.JScrollPane jScrollPane2;
private javax.swing.JList subgroupList;
private javax.swing.JLabel subgroupLabel;
private javax.swing.JPanel subjectPanel;
private javax.swing.JScrollPane jScrollPane3;
private javax.swing.JList subjectList;
private javax.swing.JLabel subjectLabel;
private javax.swing.JPanel southPanel;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
// End of variables declaration//GEN-END:variables

}
