/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.text.MessageFormat;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;


public class DTransferSlipEdit extends JDialog {
    
    TransferSlip slip,backupSlip;
    SlipManager manager;
    ProjectData project;
    UserData user;
    boolean ok = false;
    Frame ownerFrame;

    /** 
     * @param slip TransferSlip data, that must be set the slip id,
     * year, reciept number, project id and user id. 
     * This class make ASlipLine data.
     */
    public DTransferSlipEdit(Frame parent,
			     TransferSlip slip,SlipManager sm) {
	super(parent,SystemUtil.getResourceString("TransferSlip"),true);
	ownerFrame = parent;
	if (slip == null) {
	    throw new NullPointerException("Slip data is null.");
	}
	this.slip = slip;
	this.backupSlip = slip.getCopy();
	this.manager = sm;
	//
	SystemInfo info = manager.getParent();
	project = info.getProjectManager().getProjectData(slip.getPid());
	user = info.getSecurityManager().
	    getUserManager().getUser(slip.getUid());
	setupGui();
	pack();
	SubjectsUtil.setCenter(this);
    }

    JTextField yearLabel;
    JTextField rnText;
    JTextField projectLabel;
    DateComponent dateField;
    JTextField userLabel;

    //called by [constructor]
    private void setupGui() {
	Container root = getContentPane();
	root.setLayout(new BorderLayout(7,7));
	//
	// north pane
	Box north = new Box(BoxLayout.Y_AXIS);
	JPanel panel1 = new JPanel(new FlowLayout(20));
	JLabel tLabel = new JLabel(SystemUtil.getResourceString("TransferSlip"));
	tLabel.setFont(new Font("Serif",Font.PLAIN,36));
	north.add(tLabel);
	north.add(panel1);
	// user
	userLabel = new JTextField(user.getName());
	userLabel.setEditable(false);
	panel1.add(setCompProperty(userLabel,SystemUtil.getResourceString("User")));
	//project
	projectLabel = new JTextField(project.getName());
	projectLabel.setEditable(false);
	panel1.add(setCompProperty(projectLabel,SystemUtil.getResourceString("Project")));
	// current year
	yearLabel = new JTextField(Integer.toString(slip.getYear()));
	yearLabel.setEditable(false);
	panel1.add(setCompProperty(yearLabel,SystemUtil.getResourceString("CurrentYear")));
	//date
	dateField = new DateComponent(slip.getDate(),
				      SystemUtil.getResourceString("Date"),
				      false);
	panel1.add(setCompProperty(dateField,SystemUtil.getResourceString("Date")));
	// reciept number
	rnText = new JTextField(5);
	rnText.setText(Integer.toString(slip.getReceiptNumber()));
	panel1.add(setCompProperty(rnText,SystemUtil.getResourceString("ReceiptNumber")));
	root.add(north,"North");
	//
	//center pane
	root.add(makeTable(),"Center");
	//
	//south pane
	JPanel south = new JPanel(new FlowLayout());
	JButton okButton = new JButton(SystemUtil.getResourceString("Ok"));
	okButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onOk();
		}});
	JButton cancelButton = new JButton(SystemUtil.getResourceString("Cancel"));
	cancelButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onCancel();
		}});
	south.add(okButton);
	south.add(cancelButton);
	root.add(south,"South");
    }

    //called by [setupGui]
    private JComponent setCompProperty(JComponent p,String title) {
	JPanel t = new JPanel();
	t.setBorder(new TitledBorder(title));
	t.add(p);
	return t;
    }

    //called by user object
    public boolean isOk() {
	return ok;
    }
    
    String [] titles = {SystemUtil.getResourceString("Credit"),
			SystemUtil.getResourceString("Amount"),
			SystemUtil.getResourceString("Summary"),
			SystemUtil.getResourceString("Debtor"),
			SystemUtil.getResourceString("Amount")};
    final int [] columns = {10,10,30,10,10};
    final int CREDIT = 0,LAMOUNT=1,SUMMARY=2,DEBTOR=3,RAMOUNT=4;

    JPanel table;
    JButton radd,ladd,del;
    List lines;
    //called by [setupGui]
    Component makeTable() {
	JPanel center = new JPanel(new BorderLayout(5,5));
	table = new JPanel();
	BoxLayout layout = new BoxLayout(table,BoxLayout.Y_AXIS);
	table.setLayout(layout);
	center.add(new JScrollPane(table),"Center");
	//
	JPanel south = new JPanel();
	radd = new JButton(SystemUtil.getResourceString("AddRight"));
	radd.setIcon(new ImageIcon(getClass().getResource("/toolbarButtonGraphics/navigation/Forward24.gif")));
	ladd = new JButton(SystemUtil.getResourceString("AddLeft"));
	ladd.setIcon(new ImageIcon(getClass().getResource("/toolbarButtonGraphics/navigation/Back24.gif")));
	radd.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onRadd();
		}});
	ladd.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onLadd();
		}});
	south.add(ladd);
	south.add(Box.createHorizontalStrut(30));
	south.add(radd);
	center.add(south,"South");
	//initial value
	updateFromDataLines();
	return center;
    }

    java.text.NumberFormat form = java.text.NumberFormat.getInstance();

    //called when pushed RADD
    void onRadd() {
	updateFromComps();
	slip.addLine("",null,new SlipElement(-1,0));
	updateFromDataLines();
    }
    //called when pushed LADD
    void onLadd() {
	updateFromComps();
	slip.addLine("",new SlipElement(-1,0),null);
	updateFromDataLines();
    }

    //delete component lines and transfer the data from object to components
    //called by [setupGui,onRadd,onLadd,onDelThis]
    void updateFromDataLines() {
        radd.setEnabled(true);
        ladd.setEnabled(true);

        if (table != null)
	    table.removeAll();
	if (lines == null)
	    lines = new LinkedList();
	else
	    lines.clear();
	//
	JPanel titleRow = new JPanel(new FlowLayout(FlowLayout.LEFT));
	for (int i=0;i<titles.length;i++) {
	    JTextField t = new JTextField(titles[i],columns[i]);
	    t.setEnabled(false);
	    titleRow.add(t);
	}
	titleRow.add(new Label("---"));
	table.add(titleRow);
	//
	for (int i=0;i<slip.getLines().size();i++) {
	    LineComponent lc = new LineComponent(slip.getASlipLine(i));
	    table.add(lc);
	    lines.add(lc);
	}
	pack();
    }

    //called when push cancel
    void onCancel() {
	dispose();
	backupSlip.copyTo(slip);
    }

    //called when pushed ok
    void onOk() {
	//date
	Date d = dateField.getDate();
	if (d == null) {
            //JOptionPane.showMessageDialog(
	    //	this,"Date field is wrong. Please Check it.");
	    return;
	}
	slip.setDate(d);
	//receipt number
	try {
	    String s = rnText.getText();
	    slip.setReceiptNumber(Integer.parseInt(
		jp.gr.java_conf.ccs2.util.StringUtil.transform(s)));
	} catch (Exception e) {
            JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("ReceiptNumberWrongMessage"));
	    return;
	}
	if (!updateFromComps()) {
            JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("SlipWrongMessage"));
	    return;
	}

	project.setCurReceiptNumber(slip.getReceiptNumber());
	
	ok = true;
	dispose();
    }

    //transfer the data from components to object
    //called by [onRadd,onLadd,onOk,onDelThis] 
    boolean updateFromComps() {
	long left=0,right=0;
	for (int i=0;i<lines.size();i++) {
	    LineComponent a = (LineComponent)lines.get(i);
	    if (!a.updateFromComp())
		return false;
	}
	//simple caliculate
	for (int i=0;i<lines.size();i++) {
	    ASlipLine line = slip.getASlipLine(i);
	    if (line.existLeft())
		left += line.getLeft().getMoney();
	    if (line.existRight())
		right += line.getRight().getMoney();
	}
	if (left != right) {
            JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("TotalAmountWrongMessage"));
	    return false;
	}
	return true;
    }

    //this line manage subjects, amounts, summary and some event
    class LineComponent extends JPanel {
	JTextField [] texts;
	ASlipLine aline;
	LineComponent(ASlipLine asl) {
	    super(new FlowLayout(FlowLayout.LEFT));
	    aline = asl;
	    //setup gui
	    texts = new JTextField[titles.length];
	    for (int i=0;i<titles.length;i++) {
		texts[i] = new JTextField(columns[i]);
		this.add(texts[i]);
	    }
	    JButton del = new JButton(SystemUtil.getResourceString("Del"));
	    del.setForeground(Color.red);
	    del.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			onDelThis();
		    }});
	    this.add(del);
	    if (asl.getForward() == null)
		del.setEnabled(false);
	    updateFromData();
	}

	//called when pushed del button
	void onDelThis() {
	    updateFromComps();
	    String [] arg = {aline.getSummary()};
	    String mes =  MessageFormat.format(
		SystemUtil.getResourceString("RemoveLineConfirm"),arg);
	    int ret = JOptionPane.showConfirmDialog(
		this,mes,
		SystemUtil.getResourceString("Confirm"),
		JOptionPane.YES_NO_OPTION);
	    if (ret == JOptionPane.NO_OPTION) return;
	    aline.getParent().removeLine(aline);
	    updateFromDataLines();
	}

	//make components and transfer the data from object to components
	//called by [this.constructor]
	void updateFromData() {
	    if (aline == null) return;
	    if (aline.existLeft()) {
		SlipElement e = aline.getLeft();
		if (e != null) {
		    Subject sj = project.getSubject(e.getId());
		    String tt = "";
		    if (sj != null) tt = sj.getName();
		    texts[CREDIT].setText(tt);
		    texts[LAMOUNT].setText(form.format(e.getMoney()));
		    texts[CREDIT].addFocusListener(new FocusMan(texts[CREDIT],e));
		}
	    } else {
		texts[CREDIT].setEnabled(false);
		texts[LAMOUNT].setEnabled(false);
		texts[CREDIT].setBackground(Color.lightGray);
		texts[LAMOUNT].setBackground(Color.lightGray);
                ladd.setEnabled(false);
	    }
	    if (aline.existRight()) {
		SlipElement e = aline.getRight();
		if (e != null) {
		    Subject sj = project.getSubject(e.getId());
		    String tt = "";
		    if (sj != null) tt = sj.getName();
		    texts[DEBTOR].setText(tt);
		    texts[RAMOUNT].setText(form.format(e.getMoney()));
		    texts[DEBTOR].addFocusListener(new FocusMan(texts[DEBTOR],e));
		}
	    } else {
		texts[DEBTOR].setEnabled(false);
		texts[RAMOUNT].setEnabled(false);
		texts[DEBTOR].setBackground(Color.lightGray);
		texts[RAMOUNT].setBackground(Color.lightGray);
                radd.setEnabled(false);
	    }
	    texts[SUMMARY].setText(aline.getSummary());
	    // activate IMF
	    FocusListener fe = SystemUtil.getIMEvent();
	    if (fe != null)
		texts[SUMMARY].addFocusListener(fe);
	    fe = new jp.gr.java_conf.ccs2.comp.swing.DirectIMFocusListener();
	    texts[LAMOUNT].addFocusListener(fe);
	    texts[RAMOUNT].addFocusListener(fe);
	    // set key event
	    texts[SUMMARY].addKeyListener(new KeyAdapter() {
		    public void keyTyped (java.awt.event.KeyEvent evt) {
			if (evt.getKeyChar() == '\n')
			    onOk();
		    }
		});
	    texts[RAMOUNT].addKeyListener(new KeyAdapter() {
		    public void keyTyped (java.awt.event.KeyEvent evt) {
			if (evt.getKeyChar() == '\n')
			    onOk();
			if (evt.getKeyChar() == ' ') {
			    long left = 0;
			    for (int i=0;i<lines.size();i++) {
				LineComponent a = (LineComponent)lines.get(i);
				left += getNumber(a.texts[LAMOUNT]);
			    }
			    texts[RAMOUNT].setText(form.format(left));
			}
		    }
		});
	    texts[LAMOUNT].addKeyListener(new KeyAdapter() {
		    public void keyTyped (java.awt.event.KeyEvent evt) {
			if (evt.getKeyChar() == '\n')
			    onOk();
			if (evt.getKeyChar() == ' ') {
			    long right = 0;
			    for (int i=0;i<lines.size();i++) {
				LineComponent a = (LineComponent)lines.get(i);
				right += getNumber(a.texts[RAMOUNT]);
			    }
			    texts[LAMOUNT].setText(form.format(right));
			}
		    }
		});
	}

	long getNumber(JTextField txt) {
	    if (txt == null) return 0;
	    long ret = 0;
	    try {
		ret = form.parse(
		    jp.gr.java_conf.ccs2.util.StringUtil.transform(
			txt.getText() )).longValue();
	    }catch(Exception e) {}
	    return ret;
	}
	//called by [updateFromComps]
	boolean updateFromComp() {
	    aline.setSummary(texts[SUMMARY].getText());
	    try {
		if (aline.existLeft()) {
		    aline.getLeft().setMoney(getNumber(texts[LAMOUNT]));
		    if (aline.getLeft().getId() == -1)
			return false;
		}
		if (aline.existRight()) {
		    aline.getRight().setMoney(getNumber(texts[RAMOUNT]));
		    if (aline.getRight().getId() == -1)
			return false;
		}
	    } catch (Exception e) {
		String [] arg = {aline.getSummary()};
		String mes = MessageFormat.format(
		    SystemUtil.getResourceString("WrongMoneyMessage"),arg);
		JOptionPane.showMessageDialog(
		    this,mes);
		return false;
	    }
	    return true;
	}

	//pop up subject selector
	class FocusMan implements FocusListener {
	    JTextField f_text;
	    SlipElement f_slip;
	    FocusMan(JTextField t,SlipElement s) {
		f_text = t; f_slip = s;
	    }
	    public void focusGained(FocusEvent e) {
		f_text.transferFocus();
		DSubjectSelect dlg = new DSubjectSelect(ownerFrame,project);
		dlg.show();
		if (dlg.isOk()) {
		    f_slip.setId(dlg.getId());
		    f_text.setText(project.getSubject(dlg.getId()).getName());
		}
	    }
	    public void focusLost(FocusEvent e) {}
	}
    }
	
}
