/*
 * DUserEditor.java
 *
 * Created on 2000/03/12, 19:06
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import arg.money.*;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusAdapter;
import java.awt.im.InputSubset;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class DUserEditor extends javax.swing.JDialog {

    protected UserData user;
    protected boolean ok=false;
    
    public DUserEditor(java.awt.Frame f,UserData d) {
        this(f,true);
        //
        commentText.addFocusListener(SystemUtil.getIMEvent());
        user = d;
        nameText.setText(d.getName());
        commentText.setText(d.getComment());
        passwd1.setText(d.getPassword());
        passwd2.setText(d.getPassword());
	passwd1.addFocusListener(nonIm);
	passwd2.addFocusListener(nonIm);
        pack();
        SubjectsUtil.setCenter(this);
    }
    
  /** Creates new form DUserEditor */
  public DUserEditor(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    namePanel = new javax.swing.JPanel ();
    nameText = new javax.swing.JTextField ();
    comPanel = new javax.swing.JPanel ();
    commentText = new javax.swing.JTextField ();
    pswd1Panel = new javax.swing.JPanel ();
    passwd1 = new javax.swing.JPasswordField ();
    pswd2Panel = new javax.swing.JPanel ();
    passwd2 = new javax.swing.JPasswordField ();
    jPanel2 = new javax.swing.JPanel ();
    okButton = new javax.swing.JButton ();
    cancelButton = new javax.swing.JButton ();
    jLabel1 = new javax.swing.JLabel ();
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeDialog (evt);
        }
    }
    );

    jPanel1.setLayout (new javax.swing.BoxLayout (jPanel1, 1));
    jPanel1.setBorder (new javax.swing.border.EtchedBorder());

      namePanel.setBorder (new javax.swing.border.TitledBorder("User Name"));
      SubjectsUtil.borderTitle(namePanel,SystemUtil.getResourceString("UserName"));
  
        nameText.setColumns (20);
        nameText.setText ("jTextField1");
        nameText.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                nameTextActionPerformed (evt);
            }
        }
        );
    
        namePanel.add (nameText);
    
      jPanel1.add (namePanel);
  
      comPanel.setBorder (new javax.swing.border.TitledBorder("Comment"));
      SubjectsUtil.borderTitle(comPanel,SystemUtil.getResourceString("UserComment"));
  
        commentText.setColumns (30);
        commentText.setText ("jTextField2");
        commentText.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                commentTextActionPerformed (evt);
            }
        }
        );
    
        comPanel.add (commentText);
    
      jPanel1.add (comPanel);
  
      pswd1Panel.setBorder (new javax.swing.border.TitledBorder("Password"));
      SubjectsUtil.borderTitle(pswd1Panel,SystemUtil.getResourceString("Password"));
  
        passwd1.setColumns (20);
        passwd1.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                passwd1ActionPerformed (evt);
            }
        }
        );
    
        pswd1Panel.add (passwd1);
    
      jPanel1.add (pswd1Panel);
  
      pswd2Panel.setBorder (new javax.swing.border.TitledBorder("Password(confirm)"));
      SubjectsUtil.borderTitle(pswd2Panel,SystemUtil.getResourceString("PasswordConfirm"));
  
        passwd2.setColumns (20);
        passwd2.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                passwd2ActionPerformed (evt);
            }
        }
        );
    
        pswd2Panel.add (passwd2);
    
      jPanel1.add (pswd2Panel);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.CENTER);


      okButton.setText ("Ok");
      okButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              okButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel2.add (okButton);
  
      cancelButton.setText ("Cancel");
      cancelButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              cancelButtonActionPerformed (evt);
          }
      }
      );
  
      jPanel2.add (cancelButton);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.SOUTH);

    jLabel1.setText (SystemUtil.getResourceString("UserEditor"));
    jLabel1.setFont (new java.awt.Font ("Serif", 0, 36));


    getContentPane ().add (jLabel1, java.awt.BorderLayout.NORTH);

}//GEN-END:initComponents

  private void nameTextActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameTextActionPerformed
// Add your handling code here:
    nameText.transferFocus();
  }//GEN-LAST:event_nameTextActionPerformed

  private void commentTextActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commentTextActionPerformed
// Add your handling code here:
    commentText.transferFocus();
  }//GEN-LAST:event_commentTextActionPerformed

  private void passwd1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_passwd1ActionPerformed
// Add your handling code here:
    passwd1.transferFocus();
  }//GEN-LAST:event_passwd1ActionPerformed

  private void passwd2ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_passwd2ActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_passwd2ActionPerformed

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
// Add your handling code here:
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
// Add your handling code here:
    onOk();
  }//GEN-LAST:event_okButtonActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new DUserEditor (new javax.swing.JFrame (), true).show ();
  }

    public boolean isOk() {return ok;}

    void onOk() {
        String s = nameText.getText();
        if (s.length() == 0) {
            String mes = SystemUtil.getResourceString("InputNameField");
            javax.swing.JOptionPane.showMessageDialog(this,mes);
            return;
        }
        String p1 = new String(passwd1.getPassword());
        String p2 = new String(passwd2.getPassword());
        if (!p1.equals(p2)) {
            javax.swing.JOptionPane.showMessageDialog(
		this,
		SystemUtil.getResourceString("PasswordIncorrect"));
            return;
        }
        user.setName(s);
        user.setComment(commentText.getText());
        user.setPassword(p1);
        ok = true;
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel namePanel;
    private javax.swing.JTextField nameText;
    private javax.swing.JPanel comPanel;
    private javax.swing.JTextField commentText;
    private javax.swing.JPanel pswd1Panel;
    private javax.swing.JPasswordField passwd1;
    private javax.swing.JPanel pswd2Panel;
    private javax.swing.JPasswordField passwd2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    FocusAdapter nonIm = new FocusAdapter() {
	    public void focusGained(FocusEvent event) {
		activateIME(event.getComponent(),false);
	    }
	    /** FocusAdapter stuff (deactivate IME) */
	    public void focusLosted(FocusEvent event) {
		activateIME(event.getComponent(),false);
	    }

	    /** IME utility 
	     * @param c target component object
	     * @param kanji if true, activate the IME on the component.
	     */
	    public void activateIME(Component c,boolean kanji) {
		if (kanji) 
		    c.getInputContext().setCharacterSubsets(
		new Character.Subset[] {InputSubset.KANJI});
		else
		    c.getInputContext().setCharacterSubsets(null);
	    }
	};
}
