/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.frame.*;
import arg.money.*;
import arg.money.SecurityManager;


public class FReport extends JFrame implements MessageListener {

    SlipManager manager;
    UserData user;
    SessionData session;

    public FReport(SlipManager m,SessionData sd,Document doc) {
	initGui();
	setDocument(doc);
        SystemInfo info = m.getParent();
        manager = m;
        session = sd;
        user = info.getSecurityManager().getUserManager().getUser(sd.getUid());
        initData();
	//
        pack();
	SubjectsUtil.setCenter(this);
    }

    ProjectData getProjectData(int i) {
	return manager.getParent().getProjectManager().getProjectData(i);
    }

    int [] parray;
    AbstractReportPanel [] preport;

    void initData() {
	reportPanel.removeAll();
        SystemInfo info = manager.getParent();
        SecurityManager sm = info.getSecurityManager();
        List projects = sm.getPermittedProjects(
	    user.getId(),SecurityManager.READABLE);
        Object [] ar = projects.toArray();
        parray = new int [ar.length+1];
        preport = new AbstractReportPanel[ar.length+1];
        for(int i=0;i<(parray.length-1);i++) {
            parray[i] = ((ProjectData)ar[i]).getId();
            ImageIcon icon;
	    icon = new ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/History24.gif"));
            preport[i] = new PReport(parray[i],manager);
            reportPanel.addTab(
		getProjectData(parray[i]).getName(), icon, preport[i]);
        }
	preport[ar.length] = new GroupReportPanel(manager);
	parray[ar.length] = -1;
	reportPanel.addTab(
	    SystemUtil.getResourceString("ConsolidatedAccounts"),
	    null, preport[ar.length]);
    }
    
    private void initGui () {
        addWindowListener (new WindowAdapter () {
		public void windowClosing (WindowEvent evt) {
		    onExit();
		}
	    }
        );

	JPanel north = new JPanel();
	JButton bt = new JButton(SystemUtil.getResourceString("Print"));
	bt.setIcon(new ImageIcon(
	    getClass().getResource("/toolbarButtonGraphics/general/Print24.gif")));
	bt.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onPrint();
		}
	    });
	north.add(bt);
	getContentPane().add( north ,"North");

	reportPanel = new JTabbedPane();
        getContentPane().add( reportPanel,"Center");
	
    }

    void onPrint() {
	int ps = reportPanel.getSelectedIndex();
	if (ps >= 0) 
	    preport[ps].print();
    }

    //update
    void setDocument(Document doc) {
	view = new CView(doc) {
		public void update(Object o) {
		    if (o == null) {
			onExit();
			return;
		    }
		    int pid = ((Integer)o).intValue();
		    updateContents(pid);
		}
	    };
    }
    CView view;
    public void updateContents(int pid) {
	if (pid < 0) {
	    //rebuild projects components
	    initData();
	    return;
	}
	int ps = reportPanel.getSelectedIndex();
	if (parray[ps] == pid || pid < 0) 
	    preport[ps].update();
	preport[preport.length-1].update();
    }
    void onExit() {
	dispose();
	//view.closeView();
    }

    //exit & update message
    public void message(String com,int param,Object some) {
	
    }

    JTabbedPane reportPanel;
}
