/*
 * FSlipExplorer.java
 *
 * Created on 2000/04/05, 3:52
 */

/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.Frame;
import javax.swing.*;
import java.text.*;
import java.util.*;
import arg.money.*;
import arg.money.SecurityManager;
import jp.gr.java_conf.ccs2.frame.*;

/**
 *
 * @author  sakurai
 * @version
 */
public class FSlipExplorer extends javax.swing.JFrame {

    SlipManager manager;
    SessionData session;

    //user = info.getSecurityManager().getUserManager().getUser(sd.getUid());

    public FSlipExplorer(SlipManager m,SessionData sd,Document doc) {
        this();
	setDocument(doc);
        SystemInfo info = m.getParent();
        manager = m;
        session = sd;
        initData();
	//title
	String [] arg = {session.getUser().getName()};
	setTitle(MessageFormat.format(SystemUtil.getResourceString("FSlipExplorerTitle"),arg));
	//
        pack();
	SubjectsUtil.setCenter(this);
    }

    //update
    void setDocument(Document doc) {
	view = new CView(doc) {
		public void update(Object o) {
		    if (o == null) {
			onExit();
			return;
		    }
		    int pid = ((Integer)o).intValue();
		    updateContents(pid);
		}
	    };
    }
    CView view;
    void updateContents(int pid) {
	if (pid < 0) {
	    //rebuild projects components
	    initData();
	    return;
	}
	int in = projectPanel.getSelectedIndex();
	if (parray[in] == pid)
	    ppjarray[in].initData();
    }
    void onExit() {
	dispose();
	//view.closeView();
    }

    ProjectData getProjectData(int i) {
	return manager.getParent().getProjectManager().getProjectData(i);
    }

    int [] parray;
    PProjectPanel [] ppjarray;
    void initData() {
	projectPanel.removeAll();
        SystemInfo info = manager.getParent();
        SecurityManager sm = info.getSecurityManager();
        SlipManager slips = info.getSlipManager();
        List projects = sm.getPermittedProjects(
	    session.getUid(),SecurityManager.READABLE);
        Object [] ar = projects.toArray();
        parray = new int[ar.length];
        ppjarray = new PProjectPanel[ar.length];
        for(int i=0;i<parray.length;i++) {
            parray[i] = ((ProjectData)ar[i]).getId();
            ImageIcon icon;
            boolean wt = true;
            if (sm.getPermission(session,parray[i],SecurityManager.WRITABLE)) {
		icon = new ImageIcon(
		    getClass().getResource(
			"/toolbarButtonGraphics/general/Edit24.gif"));
            } else {
                icon = new ImageIcon(
		    getClass().getResource(
			"/toolbarButtonGraphics/general/PrintPreview24.gif"));
                wt = false;
            }
            ppjarray[i] = new PProjectPanel(this,parray[i],slips,session,wt);
            projectPanel.addTab(
		getProjectData(parray[i]).getName(), icon, ppjarray[i]);
        }
    }

    /** Creates new form FSlipExplorer */
    protected FSlipExplorer() {
        initComponents ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel ();
        inputButton = new javax.swing.JButton ();
        editButton = new javax.swing.JButton ();
        removeButton = new javax.swing.JButton ();
        findButton = new javax.swing.JButton ();
        printButton = new javax.swing.JButton ();
        exitButton = new javax.swing.JButton ();
        projectPanel = new javax.swing.JTabbedPane ();
        addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
                exitForm (evt);
            }
        }
        );


          inputButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/New24.gif")));
          inputButton.setText (SystemUtil.getResourceString("InputTS"));
          inputButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  inputButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (inputButton);
  
          editButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Edit24.gif")));
          editButton.setText (SystemUtil.getResourceString("Modify"));
          editButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  editButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (editButton);
  
          removeButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Delete24.gif")));
          removeButton.setText (SystemUtil.getResourceString("Delete"));
          removeButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  removeButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (removeButton);
  
          findButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Find24.gif")));
          findButton.setText (SystemUtil.getResourceString("Find"));
          findButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  findButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (findButton);
  
          printButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Print24.gif")));
          printButton.setText (SystemUtil.getResourceString("Print"));
          printButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  printButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (printButton);
  
          exitButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Stop24.gif")));
          exitButton.setText (SystemUtil.getResourceString("Exit"));
          exitButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  exitButtonActionPerformed (evt);
              }
          }
          );
  
          jPanel1.add (exitButton);
  

        getContentPane ().add (jPanel1, java.awt.BorderLayout.NORTH);



        getContentPane ().add (projectPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

  private void printButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_printButtonActionPerformed
// Add your handling code here:
	int in = projectPanel.getSelectedIndex();
	if (in < 0 || in >= parray.length) return;

	ppjarray[in].print();
      
  }//GEN-LAST:event_printButtonActionPerformed

  private void findButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findButtonActionPerformed
    // Add your handling code here:
      JFrame f = new JFrame(SystemUtil.getResourceString("SearchFrame"));
      f.getContentPane().add(
	  new SearchPanel(f,manager.getParent(),session,view.getDocument()),"Center");
      f.setSize(650,700);
      f.show();
  }//GEN-LAST:event_findButtonActionPerformed

  private void removeButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
    // Add your handling code here:
      PProjectPanel pp = editCheck();
      if (pp == null) return;
      pp.onDelete();
  }//GEN-LAST:event_removeButtonActionPerformed

  private void editButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonActionPerformed
    // Add your handling code here:
    PProjectPanel pp = editCheck();
    if (pp == null) return;
    pp.onModify();
  }//GEN-LAST:event_editButtonActionPerformed

  private void exitButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed
    // Add your handling code here:
    onExit();
  }//GEN-LAST:event_exitButtonActionPerformed

  private void inputButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inputButtonActionPerformed
    // Add your handling code here:
    PProjectPanel pp = editCheck();
    if (pp == null) return;
    pp.onAdd();
  }//GEN-LAST:event_inputButtonActionPerformed

/** Exit the Application */
  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
      onExit();
  }//GEN-LAST:event_exitForm

    PProjectPanel editCheck() {
	int in = projectPanel.getSelectedIndex();
	if (in < 0 || in >= parray.length) return null;
	ProjectData pd = getProjectData(parray[in]);

	//security check
	int pid = pd.getId();
	boolean b = manager.getParent().getSecurityManager().
	getPermission(session,pid,SecurityManager.WRITABLE);
	if (!b) {
	    String mes = SystemUtil.getResourceString("DontHaveWritablePermission");
	    JOptionPane.showMessageDialog(this,mes);
	    return null;
	}
	return ppjarray[in];
    }

/**
 * @param args the command line arguments
 */
public static void main (String args[]) {
    new FSlipExplorer ().show ();
}


// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JPanel jPanel1;
private javax.swing.JButton inputButton;
private javax.swing.JButton editButton;
private javax.swing.JButton removeButton;
private javax.swing.JButton findButton;
private javax.swing.JButton printButton;
private javax.swing.JButton exitButton;
private javax.swing.JTabbedPane projectPanel;
// ϐ錾̏I//GEN-END:variables

}
