/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.TitledBorder;
import arg.money.*;
import java.util.List;

public class GroupReportPanel extends AbstractReportPanel {

    SystemInfo info;

    int year;
    TGroupProfitLoss plTable;
    TGroupBalance balanceTable;
    
    public GroupReportPanel(SlipManager sm) {
	super();
	info = sm.getParent();
	setupGui();
    }

    JTabbedPane tab;
    JComboBox yearComboBox;

    void setupGui() {
	setLayout(new BorderLayout());
	//north panel
	JPanel north = new JPanel(new FlowLayout());
	JLabel title = new JLabel(SystemUtil.getResourceString("ConsolidatedAccounts"));
	title.setForeground(Color.black);
        title.setFont(new Font ("Serif", Font.PLAIN, 18));
        title.setForeground(Color.red);
	title.setHorizontalAlignment(title.LEFT);
	north.add(title,"North");
	// 
	JLabel com = new JLabel( 
	    SystemUtil.getResourceString(
		"ConsolidatedAccountsComment") );
	com.setForeground(Color.white);
	com.setHorizontalAlignment(com.LEFT);
	north.add(com,"Center");
	// Year
	JPanel some = new JPanel();
	yearComboBox = new JComboBox();
	yearComboBox.addItemListener (new ItemListener () {
		public void itemStateChanged (ItemEvent evt) {
		    yearChanged();
		}
	    }
	);
	yearComboBox.setBorder(
	    new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
	Integer [] years = getRuningYears();
	for (int i=0;i<years.length;i++)
            yearComboBox.addItem(years[i]);
	some.add(yearComboBox);
	north.add(some,"South");
	//
	add(north,"North");
	//
	//center panel
	tab = new JTabbedPane();
	plTable = new TGroupProfitLoss(info,getSelectedYear());
	balanceTable = new TGroupBalance(info,getSelectedYear());
	tab.addTab(SystemUtil.getResourceString("BalanceTable"),
		   new JScrollPane(balanceTable));
	tab.addTab(SystemUtil.getResourceString("ProfitLossTable"),
		   new JScrollPane(plTable));
	add(tab,"Center");
	//
    }

    Integer [] getRuningYears() {
	int minYear=-1,maxYear=-1;
	List projectList = info.getProjectManager().getProjects();
	for (int i=0;i<projectList.size();i++) {
	    ProjectData pd = (ProjectData)projectList.get(i);
	    List yearList = pd.getAnnuals();
	    for (int j=0;j<yearList.size();j++) {
		AnnualData an = (AnnualData)yearList.get(j);
		if (an.getYear() < minYear || minYear == -1) {
		    minYear = an.getYear();
		}
		if (an.getYear() > maxYear || maxYear == -1) {
		    maxYear = an.getYear();
		}
	    }
	}
	if (maxYear == -1 || minYear == -1) {
	    SystemUtil.logMessage("invalid annual year in GroupReportPanel.");
	    maxYear = minYear = SystemUtil.getYear();
	}
	Integer [] ss = new Integer[maxYear-minYear+1];
	for (int i=0;i<ss.length;i++) {
	    ss[i] = new Integer(minYear+i);
	}
	return ss;
    }

    void yearChanged() {
        try {
            Integer index = (Integer)yearComboBox.getSelectedItem();
	    int year = index.intValue();
	    plTable.setYear(year);
	    balanceTable.setYear(year);
        }catch(RuntimeException e) {}
    }

    int getSelectedYear() {
	Integer index = (Integer)yearComboBox.getSelectedItem();
	if (index == null) {
	    SystemUtil.logMessage("invalid selected year in GroupReportPanel.");
	    index = new Integer( SystemUtil.getYear() );
	}
	return index.intValue();
    }

    public void update() {
	plTable.update();
	balanceTable.update();
    }

    public void print() {
	int ps = tab.getSelectedIndex();
	if (ps == 0) {
	    balanceTable.print();
	}
	if (ps == 1) {
	    plTable.print();
	}
    }

}
