/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.util.List;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class MyCellRender extends DefaultTableCellRenderer {

    Font normalFont = null;
    Font highlite = null;
    Color defColor,hitColor,selColor;
    CellManager manager;
    String [] aligns;

    public MyCellRender(CellManager cm) {
	this(cm,null);
    }
    public MyCellRender(CellManager cm,String [] als) {
	super();
	aligns = als;
	manager = cm;
	normalFont = this.getFont().deriveFont(Font.PLAIN);
	int size = normalFont.getSize();
	highlite = normalFont.deriveFont(Font.BOLD,size+4);
	defColor = UIManager.getColor("TextPane.background");
	hitColor = Color.pink;
	selColor = UIManager.getColor("Table.focusCellBackground");
    }
    
    public Component getTableCellRendererComponent(
	JTable table,
	Object value,
	boolean isSelected,
	boolean hasFocus,
	int row,
	int col) {
	
	
	super.getTableCellRendererComponent(
	    table,value,isSelected,hasFocus,row,col);

	if (aligns != null) {
	    if (aligns[col].equals("r"))
		this.setHorizontalAlignment(SwingConstants.RIGHT);
	    if (aligns[col].equals("l"))
		this.setHorizontalAlignment(SwingConstants.LEFT);
	    if (aligns[col].equals("c"))
		this.setHorizontalAlignment(SwingConstants.CENTER);
	}
	
	boolean ht = false;
	if (manager != null) ht = manager.isStrongCell(row,col);
	
	if (ht) {
	    super.setFont(highlite);
	    super.setBackground(hitColor);
	} else {
	    super.setFont(normalFont);
	    if (isSelected)
		super.setBackground(table.getSelectionBackground());
	    else
		super.setBackground(table.getBackground());
	}
	setOpaque(true);
	
	return this;
    }
    
}
