/*
 * PProjectPanel.java
 *
 * Created on 2000/04/05, 3:58
 */

/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import java.text.*;
import java.util.*;
import java.util.List;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;

/**
 * 
 * @author  sakurai
 * @version
 */
public class PProjectPanel extends javax.swing.JPanel implements CellManager {

    Frame parent;
    int pid;
    ProjectManager projects;
    SlipManager slipManager;
    SessionData session;
    boolean writable = true;
    SubjectsUtil utils;

    /** Construct with ProjectData and SlipManager. */
    public PProjectPanel(Frame f,int pid,SlipManager s,
			 SessionData ss,boolean wt) {
        this();
	parent = f;
	session = ss;
	this.pid = pid;
        slipManager = s;
        writable = wt;
        initData();

	slipTable.setRowMargin(4);
	slipTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	slipTable.setAutoResizeMode(slipTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
	slipTable.setDefaultRenderer(
	    "".getClass(),new MyCellRender(this,aligns));
    }

    public ProjectData getProjectData() {
	return slipManager.getParent().getProjectManager().getProjectData(pid);
    }

    /** initialize table and subjects list data. */
    void initData() {
	ProjectData project = getProjectData();
	if (utils == null) {
	    utils = new SubjectsUtil(
		project,groupList,subgroupList,subjectList,
		new jp.gr.java_conf.ccs2.comp.MessageListener() {
			public void message(String a,int id,Object n) {
			    if (curSubjectId == -1) 
				updateTable(id);
			}
		    });
	} else {
	    curSubjectId = utils.getSelectedSubject().getId();
	    utils.update(project,curSubjectId);
	    updateTable(curSubjectId);
	}
        commentLabel.setText(project.getComment());
        titleLabel.setText(project.getName());
        subjectLabel.setText(utils.getSelectedSubject().getName());
        leftAmount.setBackground(Color.white);
        rightAmount.setBackground(Color.white);
        totalAmount.setBackground(new Color(0xe0ffff));

    }

    int curSubjectId = -1;
    /** update subject lists. (no one call this) */
    public void updateExt() {
	curSubjectId = utils.getSelectedSubject().getId();
	utils.updateGroupList();
	modelStore.clear();
	utils.setSelectedSubject(curSubjectId);
	updateTable(curSubjectId);
	curSubjectId = -1;
	ProjectData project = getProjectData();
	slipManager.modify(project.getCurYear(),project.getId());
    }

    public TransferSlip getSelectedSlip() {
        int ps = slipTable.getSelectedRow();
        if (ps < 0) return null;
        
        TableModel tm = slipTable.getModel();
        if (tm instanceof SlipModel) {
            SlipModel sm = (SlipModel)tm;
            return sm.getSlip(ps);
        }
        return null;
    }

    boolean securityCheck() {
	boolean b = slipManager.getParent().getSecurityManager().
	    getPermission(session,pid,SecurityManager.WRITABLE);
	if (!b) {
	    String mes = SystemUtil.getResourceString(
		"DontHaveWritablePermission");
	    JOptionPane.showMessageDialog(this,mes);
	    return false;
	}
	return true;
    }

    public void onModify() {
	if ( !securityCheck() ) return;

        TransferSlip ts = getSelectedSlip();
        if (ts == null) return;
	
	try {
	    ts = slipManager.lockSlip( ts.getYear(),ts.getPid(),ts.getId() );
	}catch(DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("SlipLockError"));
	    return;
	}
        //show dialog
	if (ts == null) {
	    System.out.println("null slip error");
	    return;
	}
        DTransferSlipEdit dlg = new DTransferSlipEdit(parent,ts,slipManager);
        dlg.show();
        if (dlg.isOk()) {
            ts.setUid(session.getUid());
	    slipManager.comitSlip(ts);
        } else
	    slipManager.cancelSlip(ts);
    }

    public void onDelete() {
	if ( !securityCheck() ) return;

	// get and lock
        TransferSlip ts = getSelectedSlip();
        if (ts == null) return;
	try {
	    slipManager.lockSlip(ts.getYear(),ts.getPid(),ts.getId());
	}catch(DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("SlipLockError"));
	    return;
	}

        List lines = ts.getLines();
        if (lines.size() == 0) return;

        StringBuffer sb = new StringBuffer();
        for(int i=0;i<lines.size();i++) {
            ASlipLine as = (ASlipLine)lines.get(i);
            if (as != null)
                sb.append(as.getSummary()).append(" ");
        }
        Object [] args = {
	    jp.gr.java_conf.ccs2.util.StringUtil.datej( ts.getDate() ),//date
	    slipManager.getParent().getSecurityManager().//user name
	    getUserManager().getUser(ts.getUid()),
	    new Integer(lines.size()),//contain number
	    sb.toString()};//summaries
	Object [] arg = {
	    MessageFormat.format(
		SystemUtil.getResourceString("TransferSlipExpression"),args)};
	String mes = MessageFormat.format(
	    SystemUtil.getResourceString("RemoveConfirm"),arg);
        int ret = JOptionPane.showConfirmDialog(
            this,mes,SystemUtil.getResourceString("Confirm"),
            JOptionPane.YES_NO_OPTION);
        if (ret == JOptionPane.YES_OPTION) {
	    slipManager.removeSlip(ts.getYear(),ts.getPid(),ts.getId());
	    return;
	} 
	slipManager.cancelSlip(ts);
    }

    public void onAdd() {
	if ( !securityCheck() ) return;
       //show dialog
	ProjectData project = getProjectData();
        TransferSlip ts = slipManager.makeSlip(project,session.getUid());
        DTransferSlipEdit dlg = new DTransferSlipEdit(parent,ts,slipManager);
        dlg.show();
        if (dlg.isOk()) {
	    slipManager.comitSlip(ts);
        }
    }

    public void print() {
	ProjectData project = getProjectData();
	Object [] args = {project.getName(),
			  new Integer(project.getCurYear()),
			  SystemUtil.getResourceString("SlipList"),
			  utils.getSelectedSubject().getName()
	};
	String titleString = MessageFormat.format(
	    SystemUtil.getResourceString("SubjectSheetTitle"),args);
	String [] aligns = {"c","c","c","c","r","r","r"};
	int [] lengthes = {12,12,12,12,16,16,16};
	
	TablePrinter printer = new TablePrinter(
	    titleString,slipTable,aligns,lengthes,null);
	printer.print();
    }

    NumberFormat form = NumberFormat.getInstance();

    /** when table is modified and needs to be repaint,
     * call this method. This will re-construct table model
     * and set it the view.
     */
    void updateTable(int sid) {
	ProjectData project = getProjectData();
	Object [] args = {new Integer(project.getCurYear()),
			  new Integer(project.getId()),
			  new Integer(sid)};
	String key = keyform.format(args);
	TableModel mod = (TableModel)modelStore.get(key);
	if (mod == null) {
	    List tp = slipManager.query(project.getCurYear(),project.getId());
	    slipManager.queryBySubject(sid,sid,tp);
	    mod = new SlipModel(project.getSubject(sid),
				slipManager.getList(tp));
	}
	slipTable.setModel(mod);
	slipTable.sizeColumnsToFit(-1);
        //
        subjectLabel.setText((project.getSubject(sid).getName()));
        subjectCommentLabel.setText((project.getSubject(sid).getComment()));
        //calculate current amount
	CurrentAmountData am = project.getAnnual(
	    project.getCurYear()).getCurrentMoney(sid).getAmounts(slipManager);
        leftAmount.setText(form.format(am.getCreditAmount()));
        rightAmount.setText(form.format(am.getDebitAmount()));
        totalAmount.setText(form.format(am.getCurrentAmount()));
	//ListSelectionModel dsm = slipTable.getSelectionModel();
	//dsm.setSelectionMode(dsm.SINGLE_SELECTION);
	//dsm.setSelectionInterval(mod.getRowCount()-1,mod.getRowCount()-1);
	//Rectangle r = jScrollPane8.getViewport().getViewRect();
	//Dimension d = slipTable.getSize();
	//r.y = r.height-d.height;
	//jScrollPane8.getViewport().setViewPosition(new Point(0,r.y));
	//slipTable.changeSelection(mod.getRowCount()-1,0,false,false);
    }
    MessageFormat keyform = new MessageFormat("y{0}p{1}s{2}");
    Map modelStore = new HashMap();

    //for SlipModel
    List elements;
    List slips;
    
    String [] titles = {SystemUtil.getResourceString("Date"),
			SystemUtil.getResourceString("ReceiptNo"),
			SystemUtil.getResourceString("Subject"),
			SystemUtil.getResourceString("Summary"),
			SystemUtil.getResourceString("Credit"),
			SystemUtil.getResourceString("Debit"),
			SystemUtil.getResourceString("Amount"),};
    String [] aligns = {"c","c","c","l","r","r","r"};
    /** table model */
    class SlipModel extends AbstractTableModel {
        Subject subject;

        SlipModel(Subject s,List ps) {
            subject = s;
            slips = ps;
	    ProjectData project = getProjectData();
	    AnnualData annual = project.getAnnual(project.getCurYear());
	    SubjectGroup subjectGroup = 
		project.getGroupBySubject(subject.getId());
	    SubjectMoney initSub = annual.getInitialMoney(subject.getId());
	    long initMoney = initSub.getMoney();
            // make element list
            elements = new ArrayList();
            Iterator it = slips.iterator();
	    //Slip loop
            while(it.hasNext()) {
                TransferSlip ts = (TransferSlip)it.next();
		Iterator its = ts.getSlipLineByLeftSubject(subject.getId());
		if (its != null) 
		    //line loop (left)
		    while(its.hasNext()) {
			ASlipLine line = (ASlipLine)its.next();
			SlipElement right = line.getRight();
			SlipElement left = line.getLeft();
			long lamount = left.getMoney();
			long ramount = right.getMoney();
			if (lamount != ramount) 
			    lamount = Math.min(lamount,ramount);
			initMoney += subjectGroup.getTotalAmount(lamount,0);
			elements.add(
			    new SElement(
				ts,
				project.getSubject(right.getId()),
				line.getSummary(),
				lamount,-1L,initMoney));
			
		    }
		its = ts.getSlipLineByRightSubject(subject.getId());
		if (its != null) 
		    //line loop (right)
		    while(its.hasNext()) {
			ASlipLine line = (ASlipLine)its.next();
			SlipElement right = line.getRight();
			SlipElement left = line.getLeft();
			long lamount = left.getMoney();
			long ramount = right.getMoney();
			if (lamount != ramount) 
			    ramount = Math.min(lamount,ramount);
			initMoney += subjectGroup.getTotalAmount(0,ramount);
			elements.add(
			    new SElement(
                                ts,
				project.getSubject(left.getId()),
				line.getSummary(),-1L,
				ramount,initMoney));
		    }
            }
        }
        TransferSlip getSlip(int ps) {
            if (ps >= 0 && ps <elements.size()) {
                SElement e = (SElement)elements.get(ps);
                return e.ts;
            }
            return null;
        }
        public int getColumnCount() {
            return titles.length;
        }
	public Class getColumnClass(int c) {
	    if (c >= 0 && c < titles.length) return "".getClass();
	    return super.getColumnClass(c);
	}
        public int getRowCount() {
            return elements.size();
        }
        public String getColumnName(int i) {
            return titles[i];
        }
        public Object getValueAt(int row, int col) {
            SElement se = (SElement)elements.get(row);
            switch(col) {
                case 0://date
		    if (se.getSlip().isLocked())
			return SystemUtil.getResourceString("SlipLocked");
		    return jp.gr.java_conf.ccs2.util.StringUtil.datel(se.ts.getDate());
                case 1://receipt
                return new Integer(se.ts.getReceiptNumber());
                case 2://subject
                return se.sbj.getName();
                case 3://summary
                return se.summary;
                case 4://credit amount
                if (se.credit == -1) return null;
                return form.format(se.credit);
                case 5://debit amount
                if (se.debit == -1) return null;
                return form.format(se.debit);
                case 6://current amount
                return form.format(se.currentMoney);
                default:
            }
            return null;
        }

	
    }

    public boolean isStrongCell(int row,int col) {
	try {
            SElement se = (SElement)elements.get(row);
	    boolean ht = se.getSlip().isLocked();
	    return ht;
	}catch(RuntimeException e) {
	    e.printStackTrace();
	}
	return false;
    }

    /** This inner class is used in SlipModel.
     * This class is the bridge between ASlipLine and a table row.
     */
    class SElement {
	TransferSlip ts;
        Subject sbj;
        String summary;
        long credit;
        long debit;
	long currentMoney;
        SElement (TransferSlip tts,Subject s,String m,long cr,long de,long cur) {
	    ts = tts;
            sbj = s;
            summary = m;
            credit = cr;
            debit = de;
	    currentMoney = cur;
        }
	TransferSlip getSlip() {
	    return ts;
	}
    }


    /** Creates new form PProjectPanel */
    protected PProjectPanel() {
        initComponents ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel ();
        titleLabel = new javax.swing.JLabel ();
        commentLabel = new javax.swing.JLabel ();
        jPanel2 = new javax.swing.JPanel ();
        groupPanel = new javax.swing.JPanel ();
        jScrollPane5 = new javax.swing.JScrollPane ();
        groupList = new javax.swing.JList ();
        subgroupPanel = new javax.swing.JPanel ();
        jScrollPane6 = new javax.swing.JScrollPane ();
        subgroupList = new javax.swing.JList ();
        subjectPanel = new javax.swing.JPanel ();
        jScrollPane7 = new javax.swing.JScrollPane ();
        subjectList = new javax.swing.JList ();
        tsPanel = new javax.swing.JPanel ();
        jScrollPane8 = new javax.swing.JScrollPane ();
        slipTable = new javax.swing.JTable ();
        amountPanel = new javax.swing.JPanel ();
        creditPanel = new javax.swing.JPanel ();
        leftAmount = new javax.swing.JTextField ();
        debtorPanel = new javax.swing.JPanel ();
        rightAmount = new javax.swing.JTextField ();
        totalPanel = new javax.swing.JPanel ();
        totalAmount = new javax.swing.JTextField ();
        jPanel3 = new javax.swing.JPanel ();
        subjectLabel = new javax.swing.JLabel ();
        subjectCommentLabel = new javax.swing.JLabel ();
        setLayout (new java.awt.BorderLayout ());

        jPanel1.setLayout (new java.awt.GridLayout (2, 1, 5, 0));

          titleLabel.setAlignmentX (0.1F);
          titleLabel.setText ("jLabel1");
          titleLabel.setForeground (java.awt.Color.black);
          titleLabel.setFont (new java.awt.Font ("Serif", 0, 18));
  
          jPanel1.add (titleLabel);
  
          commentLabel.setAlignmentX (0.1F);
          commentLabel.setText ("jLabel2");
          commentLabel.setForeground (java.awt.Color.white);
  
          jPanel1.add (commentLabel);
  

        add (jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setLayout (new javax.swing.BoxLayout (jPanel2, 1));

          groupPanel.setLayout (new java.awt.BorderLayout ());
          groupPanel.setBorder (new javax.swing.border.TitledBorder("Group"));
          SubjectsUtil.borderTitle(groupPanel,SystemUtil.getResourceString("Group"));
  
    
              groupList.setFixedCellWidth (150);
              groupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      groupListKeyPressed (evt);
                  }
              }
              );
              groupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      groupListValueChanged (evt);
                  }
              }
              );
              groupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      groupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane5.setViewportView (groupList);
      
            groupPanel.add (jScrollPane5, java.awt.BorderLayout.CENTER);
    
          jPanel2.add (groupPanel);
  
          subgroupPanel.setLayout (new java.awt.BorderLayout ());
          subgroupPanel.setBorder (new javax.swing.border.TitledBorder("Subgroup"));
          SubjectsUtil.borderTitle(subgroupPanel,SystemUtil.getResourceString("Subgroup"));
  
    
              subgroupList.setFixedCellWidth (150);
              subgroupList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subgroupListKeyPressed (evt);
                  }
              }
              );
              subgroupList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subgroupListValueChanged (evt);
                  }
              }
              );
              subgroupList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subgroupListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane6.setViewportView (subgroupList);
      
            subgroupPanel.add (jScrollPane6, java.awt.BorderLayout.CENTER);
    
          jPanel2.add (subgroupPanel);
  
          subjectPanel.setLayout (new java.awt.BorderLayout ());
          subjectPanel.setBorder (new javax.swing.border.TitledBorder("Subject"));
          SubjectsUtil.borderTitle(subjectPanel,SystemUtil.getResourceString("Subject"));
  
    
              subjectList.setFixedCellWidth (150);
              subjectList.addKeyListener (new java.awt.event.KeyAdapter () {
                  public void keyPressed (java.awt.event.KeyEvent evt) {
                      subjectListKeyPressed (evt);
                  }
              }
              );
              subjectList.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
                  public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
                      subjectListValueChanged (evt);
                  }
              }
              );
              subjectList.addMouseListener (new java.awt.event.MouseAdapter () {
                  public void mouseClicked (java.awt.event.MouseEvent evt) {
                      subjectListMouseClicked (evt);
                  }
              }
              );
      
              jScrollPane7.setViewportView (subjectList);
      
            subjectPanel.add (jScrollPane7, java.awt.BorderLayout.CENTER);
    
          jPanel2.add (subjectPanel);
  

        add (jPanel2, java.awt.BorderLayout.WEST);

        tsPanel.setLayout (new java.awt.BorderLayout ());
        tsPanel.setBorder (new javax.swing.border.TitledBorder("Transfer Slips"));
        SubjectsUtil.borderTitle(tsPanel,SystemUtil.getResourceString("TransferSlips"));

  
            slipTable.addKeyListener (new java.awt.event.KeyAdapter () {
                public void keyPressed (java.awt.event.KeyEvent evt) {
                    slipTableKeyPressed (evt);
                }
            }
            );
            slipTable.addMouseListener (new java.awt.event.MouseAdapter () {
                public void mouseClicked (java.awt.event.MouseEvent evt) {
                    slipTableMouseClicked (evt);
                }
            }
            );
    
            jScrollPane8.setViewportView (slipTable);
    
          tsPanel.add (jScrollPane8, java.awt.BorderLayout.CENTER);
  
          amountPanel.setLayout (new javax.swing.BoxLayout (amountPanel, 0));
          amountPanel.setBorder (new javax.swing.border.TitledBorder("Amount"));
          SubjectsUtil.borderTitle(amountPanel,SystemUtil.getResourceString("Amount"));
  
            creditPanel.setBorder (new javax.swing.border.TitledBorder("Credit"));
            SubjectsUtil.borderTitle(creditPanel,SystemUtil.getResourceString("CreditAmount"));
    
              leftAmount.setDisabledTextColor (java.awt.Color.white);
              leftAmount.setEditable (false);
              leftAmount.setColumns (14);
              leftAmount.setText ("jTextField1");
      
              creditPanel.add (leftAmount);
      
            amountPanel.add (creditPanel);
    
            debtorPanel.setBorder (new javax.swing.border.TitledBorder("Debtor"));
            SubjectsUtil.borderTitle(debtorPanel,SystemUtil.getResourceString("DebtorAmount"));
    
              rightAmount.setDisabledTextColor (java.awt.Color.white);
              rightAmount.setEditable (false);
              rightAmount.setColumns (14);
              rightAmount.setText ("jTextField2");
      
              debtorPanel.add (rightAmount);
      
            amountPanel.add (debtorPanel);
    
            totalPanel.setBorder (new javax.swing.border.TitledBorder("Total"));
            SubjectsUtil.borderTitle(totalPanel,SystemUtil.getResourceString("TotalAmount"));
    
              totalAmount.setDisabledTextColor (java.awt.Color.white);
              totalAmount.setEditable (false);
              totalAmount.setColumns (14);
              totalAmount.setText ("jTextField3");
      
              totalPanel.add (totalAmount);
      
            amountPanel.add (totalPanel);
    
          tsPanel.add (amountPanel, java.awt.BorderLayout.SOUTH);
  
          jPanel3.setLayout (new javax.swing.BoxLayout (jPanel3, 1));
  
            subjectLabel.setText ("jLabel1");
            subjectLabel.setForeground (java.awt.Color.yellow);
            subjectLabel.setFont (new java.awt.Font ("SansSerif", 0, 24));
    
            jPanel3.add (subjectLabel);
    
            subjectCommentLabel.setText ("jLabel1");
            subjectCommentLabel.setForeground (java.awt.Color.white);
    
            jPanel3.add (subjectCommentLabel);
    
          tsPanel.add (jPanel3, java.awt.BorderLayout.NORTH);
  

        add (tsPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

  private void slipTableMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_slipTableMouseClicked
// Add your handling code here:
      if (evt.getClickCount() == 2) {
	  onModify();
      }
  }//GEN-LAST:event_slipTableMouseClicked

  private void slipTableKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_slipTableKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_LEFT)
    subjectList.requestFocus();
  }//GEN-LAST:event_slipTableKeyPressed

  private void subjectListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subjectListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_LEFT)
    subgroupList.requestFocus();
    if (evt.getKeyCode() == evt.VK_RIGHT)
    slipTable.requestFocus();

  }//GEN-LAST:event_subjectListKeyPressed

  private void subjectListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subjectListMouseClicked
    // Add your handling code here:
    updateTable(utils.getSelectedSubject().getId());
  }//GEN-LAST:event_subjectListMouseClicked

  private void subjectListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subjectListValueChanged
    // Add your handling code here:
    updateTable(utils.getSelectedSubject().getId());
  }//GEN-LAST:event_subjectListValueChanged

  private void subgroupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_subgroupListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_LEFT)
    groupList.requestFocus();
    if (evt.getKeyCode() == evt.VK_RIGHT)
    subjectList.requestFocus();
  }//GEN-LAST:event_subgroupListKeyPressed

  private void subgroupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_subgroupListMouseClicked
    // Add your handling code here:
    utils.updateSubjectList();
  }//GEN-LAST:event_subgroupListMouseClicked

  private void subgroupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_subgroupListValueChanged
    // Add your handling code here:
    utils.updateSubjectList();
  }//GEN-LAST:event_subgroupListValueChanged

  private void groupListKeyPressed (java.awt.event.KeyEvent evt) {//GEN-FIRST:event_groupListKeyPressed
    // Add your handling code here:
    if (evt.getKeyCode() == evt.VK_RIGHT)
    subgroupList.requestFocus();
  }//GEN-LAST:event_groupListKeyPressed

  private void groupListMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_groupListMouseClicked
    // Add your handling code here:
    utils.updateSubgroupList();
  }//GEN-LAST:event_groupListMouseClicked

  private void groupListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_groupListValueChanged
    // Add your handling code here:
    utils.updateSubgroupList();
  }//GEN-LAST:event_groupListValueChanged


// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JPanel jPanel1;
private javax.swing.JLabel titleLabel;
private javax.swing.JLabel commentLabel;
private javax.swing.JPanel jPanel2;
private javax.swing.JPanel groupPanel;
private javax.swing.JScrollPane jScrollPane5;
private javax.swing.JList groupList;
private javax.swing.JPanel subgroupPanel;
private javax.swing.JScrollPane jScrollPane6;
private javax.swing.JList subgroupList;
private javax.swing.JPanel subjectPanel;
private javax.swing.JScrollPane jScrollPane7;
private javax.swing.JList subjectList;
private javax.swing.JPanel tsPanel;
private javax.swing.JScrollPane jScrollPane8;
private javax.swing.JTable slipTable;
private javax.swing.JPanel amountPanel;
private javax.swing.JPanel creditPanel;
private javax.swing.JTextField leftAmount;
private javax.swing.JPanel debtorPanel;
private javax.swing.JTextField rightAmount;
private javax.swing.JPanel totalPanel;
private javax.swing.JTextField totalAmount;
private javax.swing.JPanel jPanel3;
private javax.swing.JLabel subjectLabel;
private javax.swing.JLabel subjectCommentLabel;
// ϐ錾̏I//GEN-END:variables

}
