/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.TitledBorder;
import java.text.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class PReport extends AbstractReportPanel {

    int pid;
    SlipManager manager;

    TProfitLoss plTable;
    TBalance balanceTable;
    
    public PReport(int p,SlipManager sm) {
	super();
	pid = p;
	manager = sm;
	setupGui();
    }

    ProjectData getProjectData() {
	return manager.getParent().getProjectManager().getProjectData(pid);
    }

    DateComponent startedDate,closedDate;
    JComboBox yearComboBox;
    JTabbedPane tab;

    void setupGui() {
	setLayout(new BorderLayout());
	//north panel
	ProjectData project = getProjectData();
	JPanel north = new JPanel(new FlowLayout());
	JLabel title = new JLabel(project.getName());
	title.setForeground(Color.black);
        title.setFont(new Font ("Serif", Font.PLAIN, 18));
	title.setHorizontalAlignment(title.LEFT);
	north.add(title,"North");
	//
	JLabel com = new JLabel(project.getComment());
	com.setForeground(Color.white);
	com.setHorizontalAlignment(com.LEFT);
	north.add(com,"Center");
	//
	JPanel some = new JPanel();
	yearComboBox = new JComboBox();
	yearComboBox.addItemListener (new ItemListener () {
		public void itemStateChanged (ItemEvent evt) {
		    yearChanged();
		}
	    }
	);
	yearComboBox.setBorder(
	    new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
	List list = project.getAnnuals();
        Iterator it = list.iterator();
	Integer selected = null;
        while(it.hasNext()) {
            AnnualData ad = (AnnualData)it.next();
	    Integer obj = new Integer(ad.getId());
            yearComboBox.addItem(obj);
	    if (project.getCurYear() == ad.getId())
		selected = obj;
        }
	yearComboBox.setSelectedItem(selected);
	some.add(yearComboBox);
	//
	AnnualData annual = project.getAnnual(project.getCurYear());
        startedDate = new DateComponent();
        startedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("StartedDate")));
	startedDate.setDate(annual.getStartedDate());
        some.add(startedDate);
        closedDate = new DateComponent();
        closedDate.setBorder(new TitledBorder(SystemUtil.getResourceString("ClosedDate")));
	closedDate.setDate(annual.getClosedDate());
        some.add(closedDate);
	north.add(some,"South");
	//
	add(north,"North");
	//
	//center panel
	tab = new JTabbedPane();
	plTable = new TProfitLoss(project,manager,project.getCurYear());
	balanceTable = new TBalance(project,manager,project.getCurYear());
	tab.addTab(SystemUtil.getResourceString("BalanceTable"),
		   new JScrollPane(balanceTable));
	tab.addTab(SystemUtil.getResourceString("ProfitLossTable"),
		   new JScrollPane(plTable));
	add(tab,"Center");
	//
    }

    public void update() {
	plTable.update();
	balanceTable.update();
    }

    JComboBox makeYearComboBox(ProjectData project) {
	JComboBox box = new JComboBox();
	box.addItemListener (new ItemListener () {
		public void itemStateChanged (ItemEvent evt) {
		    yearChanged();
		}
	    }
	);
	box.setBorder(
	    new TitledBorder(SystemUtil.getResourceString("CurrentYear")));
	List list = project.getAnnuals();
        Iterator it = list.iterator();
	Integer selected = null;
        while(it.hasNext()) {
            AnnualData ad = (AnnualData)it.next();
	    Integer obj = new Integer(ad.getId());
            box.addItem(obj);
	    if (project.getCurYear() == ad.getId())
		selected = obj;
        }
	yearComboBox.setSelectedItem(selected);	
	return yearComboBox;
    }

    void yearChanged() {
        try {
	    ProjectData project = getProjectData();
            Integer index = (Integer)yearComboBox.getSelectedItem();
	    int year = index.intValue();
            AnnualData ad = project.getAnnual(year);
            Date d = ad.getStartedDate();
            startedDate.setDate(d);
            d = ad.getClosedDate();
            closedDate.setDate(d);
	    plTable.setYear(year);
	    balanceTable.setYear(year);
        }catch(RuntimeException e) {}
    }

    public void print() {
	int ps = tab.getSelectedIndex();
	if (ps == 0) {
	    balanceTable.print();
	}
	if (ps == 1) {
	    plTable.print();
	}
    }

}
