/*
 * SearchPanel.java
 *
 * Created on 2000/07/17, 5:12
 */
 
/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import arg.money.*;
import arg.money.print.*;
import jp.gr.java_conf.ccs2.comp.swing.*;
import jp.gr.java_conf.ccs2.frame.*;
import java.util.*;
import java.awt.*;
import java.text.NumberFormat;
import java.util.List;
import arg.money.SecurityManager;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;

/** 
 *
 * @author  sakurai
 * @version 
 */
public class SearchPanel extends javax.swing.JPanel {

    protected ProjectManager projectManager;
    protected SecurityManager securityManager;
    protected SlipManager slipManager;
    protected SessionData session;
    int debitId = -1;
    int creditId = -1;
    int searchUser = -1;
    
    protected Frame ownerFrame;
    protected DateComponent startDate,endDate;
    protected int curPid,curYear;
    protected TSlips tableSlips;
    
    private int [] parray;
    
    /** Creates new form SearchPanel */
    public SearchPanel() {
	initComponents ();
    }
  
    public SearchPanel(Frame owner,SystemInfo si,SessionData ss,Document doc) {
        ownerFrame = owner;
        this.session = ss;
        projectManager = si.getProjectManager();
        securityManager = si.getSecurityManager();
        slipManager = si.getSlipManager();
	setDocument(doc);
        initComponents();
        // component init
        pageTab.setTitleAt(0,SystemUtil.getResourceString("SearchTimePage"));
        pageTab.setTitleAt(1,SystemUtil.getResourceString("SearchSubjectPage"));
        pageTab.setTitleAt(2,SystemUtil.getResourceString("SearchInfoPage")); 
        startDate = new DateComponent();
        startDate.setBorder(new TitledBorder(SystemUtil.getResourceString("SearchStartDate")));
        endDate = new DateComponent();
        endDate.setBorder(new TitledBorder(SystemUtil.getResourceString("SearchEndDate"))); 
        datePanel.add(startDate);
        datePanel.add(endDate);
        // data init
        List prs = securityManager.getPermittedProjects(session.getUid(),SecurityManager.READABLE);
        parray = new int[prs.size()];
        Iterator it = prs.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            ProjectData pd = (ProjectData)it.next();
            parray[cnt++] = pd.getId();
            projectBox.addItem(pd.getName());
        }
	setProject(parray[0]);
	//
	tableSlips = new TSlips(slipManager,curPid,null);
	tableSlips.addMouseListener (new MouseAdapter () {
                public void mouseClicked (MouseEvent evt) {
		    if (evt.getClickCount() == 2) {
			showDialog();
		    }
                }
            }
	);
	add(new JScrollPane(tableSlips),"Center");
        reset();
    }

    boolean securityCheck() {
	boolean b = securityManager.
	    getPermission(session,curPid,SecurityManager.WRITABLE);
	if (!b) {
	    String mes = SystemUtil.getResourceString("DontHaveWritablePermission");
	    JOptionPane.showMessageDialog(this,mes);
	    return false;
	}
	return true;
    }

    ASlipLine getSelectedSlip() {
        int ps = tableSlips.getSelectedRow();
        if (ps < 0) return null;
        return tableSlips.getLine(ps);
    }

    //update
    void setDocument(Document doc) {
	view = new CView(doc) {
		public void update(Object o) {
		    if (o == null) {
			onExit();
			return;
		    }
		    int pid = ((Integer)o).intValue();
		    updateContents(pid);
		}
	    };
    }
    CView view;
    void updateContents(int pid) {
	if (pid < 0) {
	    //rebuild projects components
	    return;
	}
	tableSlips.getMyModel().fireTableDataChanged();
    }

    void showDialog() {
	if ( !securityCheck() ) return;

        TransferSlip ts = getSelectedSlip().getParent();
        if (ts == null) return;
	
	try {
	    ts = slipManager.lockSlip( ts.getYear(),ts.getPid(),ts.getId() );
	}catch(DataLockingException e) {
	    JOptionPane.showMessageDialog(
		this,SystemUtil.getResourceString("SlipLockError"));
	    return;
	}
        //show dialog
	if (ts == null) {
	    System.out.println("null slip error");
	    return;
	}
        DTransferSlipEdit dlg = 
	    new DTransferSlipEdit( ownerFrame,ts,slipManager );
        dlg.show();
        if (dlg.isOk()) {
            ts.setUid(session.getUid());
	    slipManager.comitSlip(ts);
        } else
	    slipManager.cancelSlip(ts);
    }

    void onExit() {
        ownerFrame.dispose();
	view.closeView();
    }
    
    void setProject(int pid) {
        ProjectData project = projectManager.getProjectData(pid);
	if (project == null) return;
	curPid = pid;
        List list = project.getAnnuals();
        yearBox.removeAllItems();
        Iterator it = list.iterator();
        while(it.hasNext()) {
            AnnualData ad = (AnnualData)it.next();
            yearBox.addItem(new Integer(ad.getId()));
        }
        setYear(project.getCurYear());
        // reset subject
        debitId = -1;
        creditId = -1;
        creditText.setText("");
        debitText.setText("");
    }
    void setYear(int y) {
        curYear = y;
        ListModel model = yearBox.getModel();
        for(int i=0;i<model.getSize();i++) {
            Integer it = (Integer)model.getElementAt(i);
            if (curYear == it.intValue()) {
                yearBox.setSelectedItem(it);
                break;
            }
        }
    }
    void reset() {
        int ps = pageTab.getSelectedIndex();
        if (ps == -1) return;
        switch(ps) {
        case 0://project and date
            setProject(parray[0]);
            startDate.setDate(null);
            endDate.setDate(null);
            break;
        case 1://subject and summary
            creditId = -1;
            debitId = -1;
            creditText.setText("");
            debitText.setText("");
            summaryText.setText("");
            break;
        case 2://user, rep and money
            userButton.setText(SystemUtil.getResourceString("notSelected"));
            searchUser = -1;
            repText.setText("");
            moneyText.setText("");
            break;
        default:
        }
    }
    void tableUpdate() {
	if (tableSlips != null) {
	    List tmp = slipManager.query(curYear,curPid);
	    creditId = -1;
	    debitId = -1;
	    tableUpdate(tmp);
	}
    }
    protected NumberFormat NF = NumberFormat.getInstance();
    void tableUpdate(List argList) {
        List list = slipManager.getList(argList);
        tableSlips.setSlips(list,curPid,creditId,debitId);
        long [] rets = tableSlips.getAmounts();
        leftSumText.setText(NF.format(rets[0]));
        rightSumText.setText(NF.format(rets[1]));
    }
    void search() {
        int ps = pageTab.getSelectedIndex();
        if (ps == -1) return;
        switch(ps) {
        case 0: {
	    List tmp = slipManager.query(curYear,curPid);
	    slipManager.queryByDate(startDate.getDate(),endDate.getDate(),tmp);
            tableUpdate(tmp);
	    break;
	}
        case 1: {
	    List tmp = tableSlips.getSlips();
	    tmp = slipManager.query(tmp);
	    slipManager.queryBySubject(creditId,debitId,tmp);
	    String text = summaryText.getText();
	    if (text == null || text.length() == 0) {
                tableUpdate(tmp);
		break;
	    }
	    slipManager.queryBySummary(text,tmp);
            tableUpdate(tmp);
	    break;
	}
        case 2: {
	    List tmp = tableSlips.getSlips();
	    tmp = slipManager.query(tmp);
	    if (searchUser != -1)
		slipManager.queryByUser(searchUser,tmp);
	    int a = transInteger(repText.getText(),-1);
	    if (a != -1)
		slipManager.queryByReceipt(a,tmp);
	    long b = transLong(moneyText.getText(),-1);
	    if (b != -1)
		slipManager.queryByMoney(b,tmp);
            tableUpdate(tmp);
	    break;
	}
        default:
        }
    }

    /** read a line as a integer data from this object.
     * @param def default value
     * @return a read integer
     */
    public int transInteger(String in,int def) { 
        try {
            return Integer.parseInt(in);
        } catch(Exception e) {
            return def;
        }
    }
    /** read a line as a long integer data from this object.
     * @param def default value
     * @return a read long integer
     */
    private long transLong(String in,long def) { 
        try {
            return Long.parseLong(in);
        } catch(Exception e) {
            return def;
        }
    }

    protected void onPrint() {
	LineListener liner = new LineListener() {
		public int getColumnLine(TableModel model,int col) {
		    return 1;
		}
		public int getRowLine(TableModel model,int row) {
		    if ( (row&5) == 4 )
			return 1;
		    return 0;
		}
		public boolean isStrong(TableModel model,int r,int c) {
		    return false;
		}
	    };
	TablePrinter printer = new TablePrinter(
	    SystemUtil.getResourceString("SearchResult"),tableSlips,
	    tableSlips.aligns,tableSlips.lengthes,liner);
	printer.print();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        topPanel = new javax.swing.JPanel ();
        topLabel = new javax.swing.JLabel ();
        pageTab = new javax.swing.JTabbedPane ();
        timePane = new javax.swing.JPanel ();
        ypPanel = new javax.swing.JPanel ();
        yearBox = new javax.swing.JComboBox ();
        projectBox = new javax.swing.JComboBox ();
        datePanel = new javax.swing.JPanel ();
        subjectPane = new javax.swing.JPanel ();
        subjectPanel = new javax.swing.JPanel ();
        creditPanel = new javax.swing.JPanel ();
        creditText = new javax.swing.JTextField ();
        debitPanel = new javax.swing.JPanel ();
        debitText = new javax.swing.JTextField ();
        summaryPanel = new javax.swing.JPanel ();
        summaryText = new javax.swing.JTextField ();
        infoPane = new javax.swing.JPanel ();
        userPanel = new javax.swing.JPanel ();
        userLabel = new javax.swing.JLabel ();
        userButton = new javax.swing.JButton ();
        repPanel = new javax.swing.JPanel ();
        repText = new javax.swing.JTextField ();
        moneyPanel = new javax.swing.JPanel ();
        moneyText = new javax.swing.JTextField ();
        jPanel6 = new javax.swing.JPanel ();
        searchButton = new javax.swing.JButton ();
        resetButton = new javax.swing.JButton ();
        printButton = new javax.swing.JButton ();
        exitButton = new javax.swing.JButton ();
        jPanel1 = new javax.swing.JPanel ();
        jLabel1 = new javax.swing.JLabel ();
        leftSumText = new javax.swing.JTextField ();
        rightSumText = new javax.swing.JTextField ();
        setLayout (new java.awt.BorderLayout ());

        topPanel.setLayout (new java.awt.BorderLayout ());

          topLabel.setText (SystemUtil.getResourceString("SearchPanel"));
          topLabel.setFont (new java.awt.Font ("Serif", 0, 24));
  
          topPanel.add (topLabel, java.awt.BorderLayout.NORTH);
  
  
            timePane.setLayout (new javax.swing.BoxLayout (timePane, 1));
    
              ypPanel.setBorder (new javax.swing.border.TitledBorder("Year and Project"));
              SubjectsUtil.borderTitle(ypPanel,SystemUtil.getResourceString("YearAndProject"));
      
                yearBox.addItemListener (new java.awt.event.ItemListener () {
                    public void itemStateChanged (java.awt.event.ItemEvent evt) {
                        yearBoxItemStateChanged (evt);
                    }
                }
                );
        
                ypPanel.add (yearBox);
        
                projectBox.addItemListener (new java.awt.event.ItemListener () {
                    public void itemStateChanged (java.awt.event.ItemEvent evt) {
                        projectBoxItemStateChanged (evt);
                    }
                }
                );
        
                ypPanel.add (projectBox);
        
              timePane.add (ypPanel);
      
              datePanel.setBorder (new javax.swing.border.TitledBorder("Date"));
              SubjectsUtil.borderTitle(datePanel,SystemUtil.getResourceString("Date"));
      
              timePane.add (datePanel);
      
            pageTab.addTab ("jPanel1", timePane);
    
            subjectPane.setLayout (new javax.swing.BoxLayout (subjectPane, 1));
    
              subjectPanel.setLayout (new java.awt.GridLayout (1, 2));
              subjectPanel.setBorder (new javax.swing.border.TitledBorder("Subject"));
              SubjectsUtil.borderTitle(subjectPanel,SystemUtil.getResourceString("Subject"));
      
                creditPanel.setBorder (new javax.swing.border.TitledBorder(
                new javax.swing.border.EtchedBorder(), "Credit", 2, 2,
                new java.awt.Font ("Dialog", 0, 11), java.awt.Color.black));
                SubjectsUtil.borderTitle(creditPanel,SystemUtil.getResourceString("Credit"));
        
                  creditText.setColumns (12);
                  creditText.setBackground (new java.awt.Color (255, 224, 223));
                  creditText.addMouseListener (new java.awt.event.MouseAdapter () {
                      public void mousePressed (java.awt.event.MouseEvent evt) {
                          creditTextMousePressed (evt);
                      }
                      public void mouseClicked (java.awt.event.MouseEvent evt) {
                          creditTextMouseClicked (evt);
                      }
                  }
                  );
          
                  creditPanel.add (creditText);
          
                subjectPanel.add (creditPanel);
        
                debitPanel.setBorder (new javax.swing.border.TitledBorder(
                new javax.swing.border.EtchedBorder(), "Debit", 2, 2,
                new java.awt.Font ("Dialog", 0, 11), java.awt.Color.black));
                SubjectsUtil.borderTitle(debitPanel,SystemUtil.getResourceString("Debtor"));
        
                  debitText.setColumns (12);
                  debitText.setBackground (new java.awt.Color (255, 220, 221));
                  debitText.addMouseListener (new java.awt.event.MouseAdapter () {
                      public void mousePressed (java.awt.event.MouseEvent evt) {
                          debitTextMousePressed (evt);
                      }
                      public void mouseClicked (java.awt.event.MouseEvent evt) {
                          debitTextMouseClicked (evt);
                      }
                  }
                  );
          
                  debitPanel.add (debitText);
          
                subjectPanel.add (debitPanel);
        
              subjectPane.add (subjectPanel);
      
              summaryPanel.setBorder (new javax.swing.border.TitledBorder("Summary"));
              SubjectsUtil.borderTitle(summaryPanel,SystemUtil.getResourceString("Summary"));
      
                summaryText.setColumns (18);
        
                summaryPanel.add (summaryText);
        
              subjectPane.add (summaryPanel);
      
            pageTab.addTab ("jPanel6", subjectPane);
    
            infoPane.setLayout (new javax.swing.BoxLayout (infoPane, 1));
    
              userPanel.setBorder (new javax.swing.border.TitledBorder("User"));
              SubjectsUtil.borderTitle(userPanel,SystemUtil.getResourceString("User"));
      
                userLabel.setText (SystemUtil.getResourceString("User"));
        
                userPanel.add (userLabel);
        
                userButton.setText (SystemUtil.getResourceString("notSelected"));
                userButton.addActionListener (new java.awt.event.ActionListener () {
                    public void actionPerformed (java.awt.event.ActionEvent evt) {
                        userButtonActionPerformed (evt);
                    }
                }
                );
        
                userPanel.add (userButton);
        
              infoPane.add (userPanel);
      
              repPanel.setBorder (new javax.swing.border.TitledBorder("Reciept No."));
              SubjectsUtil.borderTitle(repPanel,SystemUtil.getResourceString("ReceiptNumber"));
      
                repText.setColumns (10);
        
                repPanel.add (repText);
        
              infoPane.add (repPanel);
      
              moneyPanel.setBorder (new javax.swing.border.TitledBorder("Money"));
              SubjectsUtil.borderTitle(moneyPanel,SystemUtil.getResourceString("Amount"));
      
                moneyText.setColumns (16);
        
                moneyPanel.add (moneyText);
        
              infoPane.add (moneyPanel);
      
            pageTab.addTab ("jPanel8", infoPane);
    
          topPanel.add (pageTab, java.awt.BorderLayout.CENTER);
  
          jPanel6.setLayout (new java.awt.GridLayout (4, 1, 0, 5));
  
            searchButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Find24.gif")));
            searchButton.setText (SystemUtil.getResourceString("SearchButton"));
            searchButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    searchButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel6.add (searchButton);
    
            resetButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Redo24.gif")));
            resetButton.setText (SystemUtil.getResourceString("Cancel"));
            resetButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    resetButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel6.add (resetButton);
    
            printButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Print24.gif")));
            printButton.setText (SystemUtil.getResourceString("Print"));
            printButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed (evt);
                }
            }
            );
    
            jPanel6.add (printButton);
    
            exitButton.setIcon (new javax.swing.ImageIcon (getClass ().getResource ("/toolbarButtonGraphics/general/Stop24.gif")));
            exitButton.setText (SystemUtil.getResourceString("Exit"));
            exitButton.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                    exitButtonActionPerformed (evt);
                }
            }
            );
    
            jPanel6.add (exitButton);
    
          topPanel.add (jPanel6, java.awt.BorderLayout.EAST);
  

        add (topPanel, java.awt.BorderLayout.NORTH);


          jLabel1.setText (SystemUtil.getResourceString("Total"));
  
          jPanel1.add (jLabel1);
  
          leftSumText.setBorder (new javax.swing.border.TitledBorder("CreditAmount"));
          leftSumText.setColumns (16);
          SubjectsUtil.borderTitle(leftSumText,SystemUtil.getResourceString("LeftAmount"));
  
          jPanel1.add (leftSumText);
  
          rightSumText.setBorder (new javax.swing.border.TitledBorder("DebitAmount"));
          rightSumText.setColumns (16);
          SubjectsUtil.borderTitle(rightSumText,SystemUtil.getResourceString("RightAmount"));
  
          jPanel1.add (rightSumText);
  

        add (jPanel1, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

  private void exitButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed
// R[hɒǉ:
    onExit();
  }//GEN-LAST:event_exitButtonActionPerformed

  private void debitTextMousePressed (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_debitTextMousePressed
    debitText.transferFocus();
    ProjectData pd = projectManager.getProjectData( curPid );
    DSubjectSelect dlg = new DSubjectSelect(ownerFrame,pd);
    dlg.show();
    if (dlg.isOk()) {
        debitId = dlg.getId();
        debitText.setText(pd.getSubject(dlg.getId()).getName());
    }
  }//GEN-LAST:event_debitTextMousePressed

  private void creditTextMousePressed (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_creditTextMousePressed
    creditText.transferFocus();
    ProjectData pd = projectManager.getProjectData( curPid );
    DSubjectSelect dlg = new DSubjectSelect(ownerFrame,pd);
    dlg.show();
    if (dlg.isOk()) {
        creditId = dlg.getId();
        creditText.setText(pd.getSubject(dlg.getId()).getName());
    }
  }//GEN-LAST:event_creditTextMousePressed

  private void jButton1ActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
// R[hɒǉ:
    onPrint();
  }//GEN-LAST:event_jButton1ActionPerformed

  private void creditTextMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_creditTextMouseClicked
  }//GEN-LAST:event_creditTextMouseClicked

  private void resetButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetButtonActionPerformed
// R[hɒǉ:
       this.reset();
  }//GEN-LAST:event_resetButtonActionPerformed

  private void debitTextMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_debitTextMouseClicked
  }//GEN-LAST:event_debitTextMouseClicked
   
  private void searchButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchButtonActionPerformed
// R[hɒǉ:
    this.search();
  }//GEN-LAST:event_searchButtonActionPerformed

  private void userButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_userButtonActionPerformed
    List us = securityManager.getUserManager().getUsers();
    DGeneralList dlg = new DGeneralList(ownerFrame,"",us);
    dlg.show();
    int ps = dlg.getIndex();
    if (ps == -1) return;
    UserData ud = (UserData)us.get(ps);
    searchUser = ud.getId();
    userButton.setText(ud.getName());
  }//GEN-LAST:event_userButtonActionPerformed

  private void projectBoxItemStateChanged (java.awt.event.ItemEvent evt) {//GEN-FIRST:event_projectBoxItemStateChanged
    int ps = projectBox.getSelectedIndex();
    if (ps < 0 || ps >= parray.length) return;
    setProject(parray[ps]);
    tableUpdate();
  }//GEN-LAST:event_projectBoxItemStateChanged

  private void yearBoxItemStateChanged (java.awt.event.ItemEvent evt) {//GEN-FIRST:event_yearBoxItemStateChanged
    try {
        Integer index = (Integer)yearBox.getSelectedItem();
        curYear = index.intValue();
	tableUpdate();
    }catch(RuntimeException e) {}
  }//GEN-LAST:event_yearBoxItemStateChanged


// ϐ錾 - ύXȂ//GEN-BEGIN:variables
private javax.swing.JPanel topPanel;
private javax.swing.JLabel topLabel;
private javax.swing.JTabbedPane pageTab;
private javax.swing.JPanel timePane;
private javax.swing.JPanel ypPanel;
private javax.swing.JComboBox yearBox;
private javax.swing.JComboBox projectBox;
private javax.swing.JPanel datePanel;
private javax.swing.JPanel subjectPane;
private javax.swing.JPanel subjectPanel;
private javax.swing.JPanel creditPanel;
private javax.swing.JTextField creditText;
private javax.swing.JPanel debitPanel;
private javax.swing.JTextField debitText;
private javax.swing.JPanel summaryPanel;
private javax.swing.JTextField summaryText;
private javax.swing.JPanel infoPane;
private javax.swing.JPanel userPanel;
private javax.swing.JLabel userLabel;
private javax.swing.JButton userButton;
private javax.swing.JPanel repPanel;
private javax.swing.JTextField repText;
private javax.swing.JPanel moneyPanel;
private javax.swing.JTextField moneyText;
private javax.swing.JPanel jPanel6;
private javax.swing.JButton searchButton;
private javax.swing.JButton resetButton;
private javax.swing.JButton printButton;
private javax.swing.JButton exitButton;
private javax.swing.JPanel jPanel1;
private javax.swing.JLabel jLabel1;
private javax.swing.JTextField leftSumText;
private javax.swing.JTextField rightSumText;
// ϐ錾̏I//GEN-END:variables

}
