/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.Frame;
import java.awt.Window;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.*;
import java.awt.Color;
import java.awt.Component;
import javax.swing.*;
import javax.swing.border.*;
import java.text.*;
import java.util.*;
import arg.money.*;
import jp.gr.java_conf.ccs2.comp.MessageListener;

public class SubjectsUtil {

    //GUI utility

    /** GUI utility (change border title)
     * @param panel bborder component
     * @param title new title
     */
    public static void borderTitle(JComponent panel,String title) {
        Border b = panel.getBorder();
        if (b instanceof TitledBorder)
            ( (TitledBorder) b).setTitle(title);
    }

    /** GUI utility (set frame on the center of screen) */
    public static void setCenter(Window w) {
        Dimension scSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wndSize = w.getSize();
        w.setLocation( (scSize.width-wndSize.width)/2,(scSize.height-wndSize.height)/2);
    }
    
    JList groupList,subgroupList,subjectList;
    ProjectData project;
    MessageListener listener;

    /**
     * @param p ProjectData object
     * @param groupList group JList
     * @param subgroupList subgroup JList
     * @param subjectList subject JList
     */
    public SubjectsUtil(ProjectData p,JList groupList,
			JList subgroupList,JList subjectList,
                        jp.gr.java_conf.ccs2.comp.MessageListener mes) {
        this.project = p;
        this.groupList = groupList;
        this.subgroupList = subgroupList;
        this.subjectList = subjectList;
        this.listener = mes;
	groupList.addFocusListener(listFocus);
	subgroupList.addFocusListener(listFocus);
	subjectList.addFocusListener(listFocus);
        updateGroupList();
    }

    public void update(ProjectData p) {
	this.project = p;
	updateGroupList();
    }

    public void update(ProjectData p,int sid) {
	MessageListener tmp = listener;
	listener = null;
	update(p);
	listener = tmp;
	if (sid >= 0) {
	    setSelectedSubject(sid);
	    sendMessage();
	}
    }

    public void setSelectedSubject(int sid) {
	SubjectGroup ss = project.getGroupBySubject(sid);
	if (ss == null) return;
	int sgid = ss.getId();
	for (int i=0;i<garray.length;i++) {
	    if (garray[i].getId() == sgid) {
		groupList.setSelectedIndex(i);
		break;
	    }
	}
	int ssid = project.getSubgroupBySubject(sid).getId();
	for (int i=0;i<sgarray.length;i++) {
	    if (sgarray[i].getId() == ssid) {
		subgroupList.setSelectedIndex(i);
		break;
	    }
	}
	for (int i=0;i<sarray.length;i++) {
	    if (sarray[i].getId() == sid) {
		subjectList.setSelectedIndex(i);
		break;
	    }
	}
    }

    
    SubjectGroup [] garray;
    SubjectSubgroup [] sgarray;
    Subject [] sarray;

    public void updateGroupList() {
        List list = project.getSubjectGroups();
        if (list.size() !=0) {
            garray = new SubjectGroup[list.size()];
            for (int i=0;i<garray.length;i++)
                garray[i] = (SubjectGroup)list.get(i);
            groupList.setListData(garray);
            try {
                groupList.setSelectedIndex(0);
            }catch(RuntimeException e) {
            }
        }
        updateSubgroupList();
    }
    
    public void updateSubgroupList() {
        try {
            SubjectGroup group = getSelectedGroup();
            List list = project.getSubjectSubgroups();
            Iterator it = list.iterator();
            List req = new LinkedList();
            while(it.hasNext()) {
                SubjectSubgroup sg = (SubjectSubgroup)it.next();
                if (sg.getGroupId() == group.getId())
                    req.add(sg);
            }
            sgarray = new SubjectSubgroup[req.size()];
            for (int i=0;i<sgarray.length;i++)
                sgarray[i] = (SubjectSubgroup)req.get(i);
            subgroupList.setListData(sgarray);
            subgroupList.setSelectedIndex(0);
        }catch(RuntimeException e) {
        }
        updateSubjectList();
    }

    public void updateSubjectList() {
        try  {
            SubjectSubgroup subgroup = getSelectedSubgroup();
            List list = project.getSubjects();
            Iterator it = list.iterator();
            List req = new LinkedList();
            while(it.hasNext()) {
                Subject sb = (Subject)it.next();
                if (sb.getSubgroupId() == subgroup.getId()  )
                    req.add(sb);
            }
            sarray = new Subject[req.size()];
            for (int i=0;i<sarray.length;i++)
                sarray[i] = (Subject)req.get(i);
            subjectList.setListData(sarray);
            subjectList.setSelectedIndex(0);
        }catch(RuntimeException e) {
        }
	sendMessage();
    }

    private void sendMessage() {
        if (listener != null) {
            Subject sj = getSelectedSubject();
            if (sj != null)
                listener.message("",sj.getId(),null);
        }
    }
    
    public Subject getSelectedSubject() {
        try {
            int ps = subjectList.getSelectedIndex();
            if (ps == -1) ps = 0;
            Subject sb = sarray[ps];
            return sb;
        }catch(RuntimeException e) {
            return null;
        }
    }

    public SubjectSubgroup getSelectedSubgroup() {
        try {
            int ps = subgroupList.getSelectedIndex();
            if (ps == -1) ps = 0;
            return sgarray[ps];
        }catch(RuntimeException e) {
            return null;
        }
    }
    
    public SubjectGroup getSelectedGroup() {
        try {
            int ps = groupList.getSelectedIndex();
            if (ps == -1) ps  = 0;
            return garray[ps];
        }catch(RuntimeException e) {
            return null;
        }
    }

    Color activeColor = new Color(0xffe0e0);
    Color normalColor = Color.white;

    FocusListener listFocus = new FocusAdapter() {
	    public void focusGained(FocusEvent e) {
		Component c = e.getComponent();
		c.setBackground(activeColor);
	    }
	    public void focusLost(FocusEvent e) {
		Component c = e.getComponent();
		c.setBackground(normalColor);
	    }
	};
}
