/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.util.*;
import java.awt.print.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.SecurityManager;


public abstract class TAbstract extends JTable{
    
    protected NumberFormat NF = NumberFormat.getInstance();
    
    protected abstract class AbstractTableElement {
	abstract String getName();
	long getMoney() {return 0;}
	long getInitMoney() {return 0;}
	long getEndMoney() {return 0;}
    }

    protected class SpElement extends AbstractTableElement {
	String name;
	SpElement(String n) {
	    name = n;
	}
	String getName() {
	    return name;
	}
    }

    public TAbstract() {
	super();
    }

    protected abstract AbstractTableModel initModel();
    public abstract String getTitle();
    public abstract int [] getChops();
    public abstract String [] getAligns();
    public abstract void print();

    void update() {
	AbstractTableModel model = initModel();
	tableChanged(new TableModelEvent(model));
	model.fireTableDataChanged();
    }

    abstract void setYear(int y);

}
