/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.util.*;
import java.awt.print.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.SecurityManager;


public abstract class TAbstractProject 
    extends TAbstract implements CellManager {
    
    protected ProjectData project;
    protected SlipManager manager;
    protected AnnualData annual;

    class TableElement extends AbstractTableElement{
	Subject subject;
	TableElement(Subject s) {
	    subject = s;
	}
	String getName() {
	    return subject.getName();
	}
	//for TProfitLoss
	long getMoney() {
	    SubjectCurrentMoney sm = annual.getCurrentMoney(subject.getId());
	    if (sm == null) return 0;
	    return sm.getCurrentAmount(manager);
	}
	//for TBalance
	long getInitMoney() {
	    SubjectMoney sm = annual.getInitialMoney(subject.getId());
	    if (sm == null) return 0;
	    return sm.getMoney();
	}
	long getEndMoney() {
	    SubjectCurrentMoney sm = annual.getCurrentMoney(subject.getId());
	    if (sm == null) return 0;
	    return sm.getCurrentAmount(manager);
	}
    }

    String title;
    public String getTitle() {
	Object [] args = {project.getName(),new Integer(annual.getYear()),title};
	String titleString = MessageFormat.format(SystemUtil.getResourceString("SheetTitle"),args);
	return titleString;
    }

    public TAbstractProject(ProjectData pd,SlipManager sm,int y,String title) {
	super();
	init(pd,sm,y,title);
    }

    protected void init(ProjectData pd,SlipManager sm,int y,String title) {
	this.title = title;
	project = pd;
	manager = sm;
	annual = project.getAnnual(y);
	setModel(initModel());
    }

    void setYear(int y) {
	annual = project.getAnnual(y);
	update();
    }

    /* direct print version

    protected int m_maxNumPage = 1;

    public void printData() {
	m_maxNumPage = 1;
	JDialog dlg = PrintPreview.previewDialog(new Frame(),this);
	dlg.show();
    }

    public int print(Graphics pg, PageFormat pageFormat,
		     int pageIndex) throws PrinterException {
	if (pageIndex >= m_maxNumPage)
	    return NO_SUCH_PAGE;
	pg.translate((int)pageFormat.getImageableX(), 
		     (int)pageFormat.getImageableY());
	int wPage = 0;
	int hPage = 0;
	if (pageFormat.getOrientation() == pageFormat.PORTRAIT) {
	    wPage = (int)pageFormat.getImageableWidth();
	    hPage = (int)pageFormat.getImageableHeight();
	}
	else {
	    wPage = (int)pageFormat.getImageableWidth();
	    wPage += wPage/2;
	    hPage = (int)pageFormat.getImageableHeight();
	    pg.setClip(0,0,wPage,hPage);
	}

	int y = 0;
	//title
	Font titleFont = new Font("SansSerif",Font.BOLD,18);
	Object [] args = {project.getName(),new Integer(annual.getYear()),title};
	String titleString = MessageFormat.format(SystemUtil.getResourceString("SheetTitle"),args);
	pg.setFont(titleFont);
	pg.setColor(Color.black);
	Font fn = pg.getFont();
	FontMetrics fm = pg.getFontMetrics();
	y += fm.getAscent();
	pg.drawString(titleString, 0, y);
	//
	y += 20; // space between title and table headers
	Font headerFont = new Font("SansSerif",Font.BOLD,getFont().getSize());
	pg.setFont(headerFont);
	fm = pg.getFontMetrics();
	TableColumnModel colModel = getColumnModel();
	int nColumns = colModel.getColumnCount();
	int x[] = new int[nColumns];
	x[0] = 0;
	
	int h = fm.getAscent();
	y += h; // add ascent of header font because of baseline positioning
	
	int nRow, nCol;
	for (nCol=0; nCol<nColumns; nCol++) {
	    TableColumn tk = colModel.getColumn(nCol);
	    int width = tk.getWidth();
	    if (x[nCol] + width > wPage) {
		nColumns = nCol;
		break;
	    }
	    if (nCol+1<nColumns)
		x[nCol+1] = x[nCol] + width;
	    String t = (String)tk.getIdentifier();
	    pg.drawString(t, x[nCol], y);
	}

	pg.drawLine(0,y,wPage,y);
	Font bodyFont = getFont();
	pg.setFont(bodyFont);
	fm = pg.getFontMetrics();
	
	int header = y;
	h = fm.getHeight();
	int rowH = Math.max((int)(h*1.5), 10);
	int rowPerPage = (hPage-header)/rowH;
	m_maxNumPage = Math.max((int)Math.ceil(getRowCount()/
					       (double)rowPerPage), 1);
	TableModel tblModel = getModel();
	int iniRow = pageIndex*rowPerPage;
	int endRow = Math.min(getRowCount(), 
			      iniRow+rowPerPage);
	
	for (nRow=iniRow; nRow<endRow; nRow++) {
	    y += h;
	    for (nCol=0; nCol<nColumns; nCol++) {
		int col = getColumnModel().getColumn(nCol).getModelIndex();
		Object obj = model.getValueAt(nRow, col);
		pg.drawString(obj.toString(), x[nCol], y);
	    }
	}
	System.gc();
	return PAGE_EXISTS;
    }    
    */

    protected Iterator getIterator(Map map) {
	Iterator it = map.values().iterator();
	List list = new LinkedList();
	while(it.hasNext()) {
	    list.add(it.next());
	}
	//Collections.reverse(list);
	return list.iterator();
    }
}
