/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class TBalance extends TAbstractProject {
    
    AbstractTableElement [] assets;
    AbstractTableElement [] debts;
    AbstractTableElement [] capitals;
    
    class BalanceModel extends AbstractTableModel {
	int rows;
	BalanceModel() {
	    Map assetsMap = new HashMap();
	    Map debtMap = new HashMap();
	    Map capitalMap = new HashMap();
	    Iterator it = project.getSubjects().iterator();
	    int acount=0,dcount=0,ccount=0;
	    while(it.hasNext()) {
		Subject s = (Subject)it.next();
		SubjectGroup sg = project.getGroupBySubject(s.getId());
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		List list = null;
		switch(sg.getBalanceGroup()) {
		case SubjectGroup.ASSETS:
		    list = (List)assetsMap.get(ssg);
		    if (list == null) {
			list = new LinkedList();
			assetsMap.put(ssg,list);
			acount++;
		    }
		    list.add(s);
		    acount++;
		    break;
		case SubjectGroup.DEBT:
		    list = (List)debtMap.get(ssg);
		    if (list == null) {
			list = new LinkedList();
			debtMap.put(ssg,list);
			dcount++;
		    }
		    list.add(s);
		    dcount++;
		    break;
		case SubjectGroup.CAPITAL:
		    list = (List)capitalMap.get(ssg);
		    if (list == null) {
			list = new LinkedList();
			capitalMap.put(ssg,list);
			ccount++;
		    }
		    list.add(s);
		    ccount++;
		    break;
		default:
		}
	    }
	    assets = new AbstractTableElement[acount];
	    it = getIterator(assetsMap);
	    acount=0;
	    while(it.hasNext()) {
		List list = (List)it.next();
		Iterator it2 = list.iterator();
		Subject s = (Subject)list.get(0);
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		assets[acount++] = new SpElement(ssg.getName());
		while(it2.hasNext()) {
		    Subject sb = (Subject)it2.next();
		    assets[acount++] = new TableElement(sb);
		}
	    }
	    debts = new AbstractTableElement[dcount];
	    it = getIterator(debtMap);
	    dcount=0;
	    while(it.hasNext()) {
		List list = (List)it.next();
		Iterator it2 = list.iterator();
		Subject s = (Subject)list.get(0);
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		debts[dcount++] = new SpElement(ssg.getName());
		while(it2.hasNext()) {
		    Subject sb = (Subject)it2.next();
		    debts[dcount++] = new TableElement(sb);
		}
	    }
	    capitals = new AbstractTableElement[ccount];
	    it = getIterator(capitalMap);
	    ccount=0;
	    while(it.hasNext()) {
		List list = (List)it.next();
		Iterator it2 = list.iterator();
		Subject s = (Subject)list.get(0);
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		capitals[ccount++] = new SpElement(ssg.getName());
		while(it2.hasNext()) {
		    Subject sb = (Subject)it2.next();
		    capitals[ccount++] = new TableElement(sb);
		}
	    }

	    rows = Math.max(assets.length+1,capitals.length+debts.length+2);
	}

	String [] columns = {SystemUtil.getResourceString("Assets"),
			     SystemUtil.getResourceString("Beginning"),
			     SystemUtil.getResourceString("End"),
			     SystemUtil.getResourceString("DebtAndCapital"),
			     SystemUtil.getResourceString("Beginning"),
			     SystemUtil.getResourceString("End")
	};
	public String getColumnName(int i) {
	    return columns[i];
	}
	public Class getColumnClass(int c) {
	    if (c >= 0 && c <= 5) return "".getClass();
	    return super.getColumnClass(c);
	}
	public int getColumnCount() {
	    //yoko
	    return 6;
	}
	public int getRowCount() {
	    //tate
	    return rows;
	}
	public Object getValueAt(int row, int col) {
	    switch(col) {
	    case 0://assets name
		if ( (rows-1) == row)
		    return SystemUtil.getResourceString("Total");
		if (assets.length > row)
		    return assets[row].getName();
		break;

	    case 1://assets init
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<assets.length;i++)
			total += assets[i].getInitMoney();
		    return NF.format(total);
		}
		if (assets.length > row) {
		    if (assets[row] instanceof SpElement)
			return "";
		    return NF.format(assets[row].getInitMoney());
		}
		break;
		
	    case 2://assets end
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<assets.length;i++)
			total += assets[i].getEndMoney();
		    return NF.format(total);
		}
		if (assets.length > row) {
		    if (assets[row] instanceof SpElement)
			return "";
		    return NF.format(assets[row].getEndMoney());
		}
		break;

	    case 3://debt and capital name
		if ( (rows-1) == row)
		    return SystemUtil.getResourceString("Total");
		if ( (rows-2) == row)
		    return SystemUtil.getResourceString("Capital");
		if (debts.length > row)
		    return debts[row].getName();
		break;
		
	    case 4://debt and capital init
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<debts.length;i++)
			total += debts[i].getInitMoney();
		    for (int i=0;i<capitals.length;i++)
			total += capitals[i].getInitMoney();
		    return NF.format(total);
		}
		if ( (rows-2) == row){
		    long total = 0;
		    for (int i=0;i<capitals.length;i++)
			total += capitals[i].getInitMoney();
		    return NF.format(total);
		}
		if (debts.length > row) {
		    if (debts[row] instanceof SpElement)
			return "";
		    return NF.format(debts[row].getInitMoney());
		}
		break;
		
	    case 5://debt and capital end
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<debts.length;i++)
			total += debts[i].getEndMoney();
		    for (int i=0;i<capitals.length;i++)
			total += capitals[i].getEndMoney();
		    return NF.format(total);
		}
		if ( (rows-2) == row){
		    long total = 0;
		    for (int i=0;i<capitals.length;i++)
			total += capitals[i].getEndMoney();
		    return NF.format(total);
		}
		if (debts.length > row) {
		    if (debts[row] instanceof SpElement)
			return "";
		    return NF.format(debts[row].getEndMoney());
		}
		break;
	    default:
	    }
	    return "";
	}   
    }
    
    public TBalance(ProjectData pd,SlipManager sm,int y) {
	super(pd,sm,y,SystemUtil.getResourceString("BalanceTable"));
	setDefaultRenderer("".getClass(),new MyCellRender(this));
    }

    public void print() {
	LineListener liner = new LineListener() {
		public int getColumnLine(TableModel model,int col) {
		    return 1;
		}
		public int getRowLine(TableModel model,int row) {
		    if ( (model.getRowCount()-2) == row )
			return 1;
		    return 0;
		}
		public boolean isStrong(TableModel model,int r,int c) {
		    return isStrongCell(r,c);
		}
	    };
	String [] aligns = getAligns();
	int [] lengthes = getChops();
	TablePrinter printer = new TablePrinter(
	    getTitle(),this,aligns,lengthes,liner);
	printer.print();
    }

    protected AbstractTableModel initModel() {
	return new BalanceModel();
    }

    public int [] getChops() {
	int [] lengthes = {12,16,16,12,16,16};
	return lengthes;
    }

    public String [] getAligns() {
	String [] aligns = {"c","r","r","c","r","r"};
	return aligns;
    }


    public boolean isStrongCell(int row,int col) {
	boolean ht = false;
	try {
	    switch(col) {
	    case 0://profits name
	    case 1:
	    case 2:
		if (assets.length > row) 
		    if (assets[row] instanceof SpElement)
			ht = true;
		break;
		
	    case 3://expense name
	    case 4:
	    case 5:
		if (debts.length > row) 
		    if (debts[row] instanceof SpElement)
			ht = true;
		break;
		
	    default:
	    }
	} catch(RuntimeException e) {}
	return ht;
    }


}
