/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class TGroupBalance extends TAbstract {
    
    AbstractTableElement [] assets;
    AbstractTableElement [] debts;
    AbstractTableElement capital;
    SystemInfo info;

    
    protected class TableElement extends AbstractTableElement {
	String name;
	long initMoney,endMoney;
	TableElement(String n,long im,long em) {
	    name = n;
	    initMoney = im;
	    endMoney = em;
	}
	String getName() { return name;}
	long getInitMoney() {return initMoney;}
	long getEndMoney() {return endMoney;}
    }

    class BalanceModel extends AbstractTableModel {
	int rows;
	BalanceModel() {
	    List assetsList = new ArrayList();
	    List debtList = new ArrayList();
	    List projectList = info.getProjectManager().getProjects();
	    SlipManager sm = info.getSlipManager();
	    for (int i=0;i<projectList.size();i++) {
		ProjectData pd = (ProjectData)projectList.get(i);
		AnnualData an = pd.getAnnual( getYear() );
		if (an == null) continue;
		Object [] pargs = {pd.getName(),
				   SystemUtil.getResourceString("Assets")};
		assetsList.add(
		    new TableElement(
			MessageFormat.format(
			   SystemUtil.getResourceString("GroupAmountLabel"),
			   pargs),
			getGroupInitialAmount(SubjectGroup.ASSETS,an),
			getGroupCurrentAmount(SubjectGroup.ASSETS,an)));
		Object [] eargs = {pd.getName(),
				   SystemUtil.getResourceString("Debt")};
		debtList.add(
		    new TableElement(
			MessageFormat.format(
			  SystemUtil.getResourceString("GroupAmountLabel"),
			  eargs),
			getGroupInitialAmount(SubjectGroup.DEBT,an),
			getGroupCurrentAmount(SubjectGroup.DEBT,an)));
	    }
	    assets = new AbstractTableElement[assetsList.size()];
	    assets = (AbstractTableElement[]) assetsList.toArray(assets);
	    debts = new AbstractTableElement[debtList.size()];
	    debts = (AbstractTableElement[]) debtList.toArray(debts);
	    Object [] cargs = {SystemUtil.getResourceString("Total"),
			       SystemUtil.getResourceString("Capital")};
	    capital = new TableElement(
		MessageFormat.format(
		    SystemUtil.getResourceString("GroupAmountLabel"),
		    cargs),
		getInitialCapitalAmount(),
		getCurrentCapitalAmount());
	    
	    rows = assets.length+2;
	}

	long getGroupInitialAmount(int groupId,AnnualData annual) {
	    SlipManager manager = info.getSlipManager();
	    ProjectData project = annual.getParent();
	    Iterator it = project.getSubjects().iterator();
	    long  amount = 0;
	    while(it.hasNext()) {
		Subject sb = (Subject)it.next();
		SubjectMoney sm = 
		    annual.getInitialMoney(sb.getId());
		if (sm == null) {
		    //SystemUtil.logMessage(sb.getName()+" : SubjectCurrentMoney not found : in TGroupBalance. ["+project.getName()+":"+annual.getYear()+"]");
		    continue;
		}
		SubjectGroup sg = 
		    annual.getParent().getGroupBySubject(sm.getId());
		if (sg == null) {
		    SystemUtil.logMessage(
			"SubjectGroup not found : in TGroupBalance.");
		    continue;
		}
		if (sg.getBalanceGroup() == groupId) {
		    amount += sm.getMoney();
		}
	    }
	    return amount;
	} 

	long getGroupCurrentAmount(int groupId,AnnualData annual) {
	    SlipManager manager = info.getSlipManager();
	    ProjectData project = annual.getParent();
	    Iterator it = project.getSubjects().iterator();
	    long  amount = 0;
	    while(it.hasNext()) {
		Subject sb = (Subject)it.next();
		SubjectCurrentMoney sm = 
		    annual.getCurrentMoney(sb.getId());
		if (sm == null) {
		    //SystemUtil.logMessage(sb.getName()+" : SubjectCurrentMoney not found : in TGroupBalance. ["+project.getName()+":"+annual.getYear()+"]");
		    continue;
		}
		SubjectGroup sg = 
		    annual.getParent().getGroupBySubject(sm.getId());
		if (sg == null) {
		    SystemUtil.logMessage(
			"SubjectGroup not found : in TGroupBalance.");
		    continue;
		}
		if (sg.getBalanceGroup() == groupId) {
		    amount += sm.getCurrentAmount(manager);
		}
	    }
	    return amount;
	} 

	long getInitialCapitalAmount() {
	    SlipManager manager = info.getSlipManager();
	    List projectList = info.getProjectManager().getProjects();
	    long amount = 0;
	    for (int i=0;i<projectList.size();i++) {
		ProjectData pd = (ProjectData)projectList.get(i);
		AnnualData an = pd.getAnnual( getYear() );
		if (an == null) continue;
		List inits = an.getInitialMoneys();
		for (int j=0;j<inits.size();j++) {
		    SubjectMoney money = (SubjectMoney)inits.get(j);
		    SubjectGroup sg = pd.getGroupBySubject(money.getId());
		    if (sg.getBalanceGroup() == SubjectGroup.CAPITAL) {
			amount += money.getMoney();
			break;
		    }
		}
	    }
	    return amount;
	}

	long getCurrentCapitalAmount() {
	    SlipManager manager = info.getSlipManager();
	    List projectList = info.getProjectManager().getProjects();
	    long amount = 0;
	    for (int i=0;i<projectList.size();i++) {
		ProjectData pd = (ProjectData)projectList.get(i);
		AnnualData an = pd.getAnnual( getYear() );
		if (an == null) continue;
		List inits = an.getCurrentMoneys();
		for (int j=0;j<inits.size();j++) {
		    SubjectCurrentMoney money = 
			(SubjectCurrentMoney)inits.get(j);
		    SubjectGroup sg = pd.getGroupBySubject(money.getId());
		    if (sg.getBalanceGroup() == SubjectGroup.CAPITAL) {
			amount += money.getCurrentAmount(manager);
			break;
		    }
		}
	    }
	    return amount;
	}

	String [] columns = {SystemUtil.getResourceString("Assets"),
			     SystemUtil.getResourceString("Beginning"),
			     SystemUtil.getResourceString("End"),
			     SystemUtil.getResourceString("DebtAndCapital"),
			     SystemUtil.getResourceString("Beginning"),
			     SystemUtil.getResourceString("End")
	};
	public String getColumnName(int i) {
	    return columns[i];
	}
	public Class getColumnClass(int c) {
	    if (c >= 0 && c <= 5) return "".getClass();
	    return super.getColumnClass(c);
	}
	public int getColumnCount() {
	    //yoko
	    return 6;
	}
	public int getRowCount() {
	    //tate
	    return rows;
	}
	public Object getValueAt(int row, int col) {
	    switch(col) {
	    case 0://assets name
		if ( rows == row)
		    return SystemUtil.getResourceString("Total");
		if (assets.length > row)
		    return assets[row].getName();
		break;

	    case 1://assets init
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<assets.length;i++)
			total += assets[i].getInitMoney();
		    return NF.format(total);
		}
		if (assets.length > row) {
		    if (assets[row] == null)
			return "";
		    return NF.format(assets[row].getInitMoney());
		}
		break;
		
	    case 2://assets end
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<assets.length;i++)
			total += assets[i].getEndMoney();
		    return NF.format(total);
		}
		if (assets.length > row) {
		    if (assets[row] instanceof SpElement)
			return "";
		    return NF.format(assets[row].getEndMoney());
		}
		break;

	    case 3://debt and capital name
		if ( (rows-1) == row)
		    return SystemUtil.getResourceString("Total");
		if ( (rows-2) == row)
		    return SystemUtil.getResourceString("Capital");
		if (debts.length > row)
		    return debts[row].getName();
		break;
		
	    case 4://debt and capital init
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<debts.length;i++)
			total += debts[i].getInitMoney();
		    total += capital.getInitMoney();
		    return NF.format(total);
		}
		if ( (rows-2) == row){
		    return NF.format( capital.getInitMoney());
		}
		if (debts.length > row) {
		    if (debts[row] == null)
			return "";
		    return NF.format(debts[row].getInitMoney());
		}
		break;
		
	    case 5://debt and capital end
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<debts.length;i++)
			total += debts[i].getEndMoney();
		    total += capital.getEndMoney();
		    return NF.format(total);
		}
		if ( (rows-2) == row){
		    return NF.format( capital.getEndMoney() );
		}
		if (debts.length > row) {
		    if (debts[row] == null)
			return "";
		    return NF.format(debts[row].getEndMoney());
		}
		break;
	    default:
	    }
	    return "";
	}   
    }
    
    public TGroupBalance(SystemInfo info,int year) {
	this.info = info;
	this.year = year;
	setModel(initModel());
    }

    int year;
    int getYear() {return year;}
    void setYear(int y) {
	year = y;
	update();
    }

    public String getTitle() {
	Object [] args = {
	    SystemUtil.getResourceString("ConsolidatedAccounts"),
	    new Integer(getYear())};
	String titleString =
	    MessageFormat.format(
		SystemUtil.getResourceString("SheetTitleLite"),args);
	return titleString;
    }


    public void print() {
	LineListener liner = new LineListener() {
		public int getColumnLine(TableModel model,int col) {
		    return 1;
		}
		public int getRowLine(TableModel model,int row) {
		    if ( (model.getRowCount()-2) == row )
			return 1;
		    return 0;
		}
		public boolean isStrong(TableModel model,int r,int c) {
		    return false;
		}
	    };
	String [] aligns = getAligns();
	int [] lengthes = getChops();
	TablePrinter printer = new TablePrinter(
	    getTitle(),this,aligns,lengthes,liner);
	printer.print();
    }

    protected AbstractTableModel initModel() {
	return new BalanceModel();
    }

    public int [] getChops() {
	int [] lengthes = {12,16,16,12,16,16};
	return lengthes;
    }

    public String [] getAligns() {
	String [] aligns = {"c","r","r","c","r","r"};
	return aligns;
    }
}
