/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.awt.print.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class TGroupProfitLoss extends TAbstract {

    SystemInfo info;

    protected class TableElement extends AbstractTableElement {
	String name;
	long money;
	TableElement(String n,long m) {
	    name = n;
	    money = m;
	}
	String getName() { return name;}
	long getMoney() {return money;}
    }

    AbstractTableElement [] profits;
    AbstractTableElement [] expenses;

    class PLModel extends AbstractTableModel {
	int rows;
	PLModel() {
	    int pcount = 0;
	    int ecount = 0;
	    List profitsList = new ArrayList();
	    List expensesList = new ArrayList();
	    List projectList = info.getProjectManager().getProjects();
	    SlipManager sm = info.getSlipManager();
	    for (int i=0;i<projectList.size();i++) {
		ProjectData pd = (ProjectData)projectList.get(i);
		AnnualData an = pd.getAnnual( getYear() );
		if (an == null) continue;
		Object [] pargs = {pd.getName(),
				   SystemUtil.getResourceString("Profit")};
		profitsList.add(
		    new TableElement(
			MessageFormat.format(
			   SystemUtil.getResourceString("GroupAmountLabel"),
			   pargs), getGroupAmount(SubjectGroup.PROFIT,an,sm)));
		Object [] eargs = {pd.getName(),
				   SystemUtil.getResourceString("Expense")};
		expensesList.add(
		    new TableElement(
			MessageFormat.format(
			  SystemUtil.getResourceString("GroupAmountLabel"),
			  eargs), getGroupAmount(SubjectGroup.EXPENSE,an,sm)));
	    }
	    profits = new AbstractTableElement[profitsList.size()];
	    profits = (AbstractTableElement[]) profitsList.toArray(profits);
	    expenses = new AbstractTableElement[expensesList.size()];
	    expenses = (AbstractTableElement[]) expensesList.toArray(expenses);
	    rows = profits.length;
	}

	long getGroupAmount(int groupId,AnnualData annual,
			    SlipManager manager) {
	    ProjectData project = annual.getParent();
	    Iterator it = project.getSubjects().iterator();
	    long  amount = 0;
	    while(it.hasNext()) {
		Subject sb = (Subject)it.next();
		SubjectCurrentMoney sm = 
		    annual.getCurrentMoney(sb.getId());
		if (sm == null) {
		    //SystemUtil.logMessage(sb.getName()+" : SubjectCurrentMoney not found : in TGroupProfitLoss. ["+project.getName()+":"+annual.getYear()+"]");
		    continue;
		}
		SubjectGroup sg = 
		    annual.getParent().getGroupBySubject(sm.getId());
		if (sg == null) {
		    SystemUtil.logMessage(
			"SubjectGroup not found : in TGroupProfitLoss.");
		    continue;
		}
		if (sb.getSpecialLabel() != sb.GROUP_TRANSACTION_LABEL &&
		    sg.getBalanceGroup() == groupId) {
		    amount += sm.getCurrentAmount(manager);
		}
	    }
	    return amount;
	}

	String [] columns = {SystemUtil.getResourceString("Profit"),
			     SystemUtil.getResourceString("Amount"),
			     SystemUtil.getResourceString("Expense"),
			     SystemUtil.getResourceString("Amount")
	};
	public Class getColumnClass(int c) {
	    if (c >= 0 && c <= 3) return "".getClass();
	    return super.getColumnClass(c);
	}
	public String getColumnName(int i) {
	    return columns[i];
	}
	public int getColumnCount() {
	    //yoko
	    return 4;
	}
	public int getRowCount() {
	    //tate
	    return rows+2;//total and profits
	}
	public Object getValueAt(int row, int col) {
	    switch(col) {
	    case 0://profits name
		if ( rows == row)
		    return SystemUtil.getResourceString("Total");
		if ( (rows+1) == row)
		     return SystemUtil.getResourceString("CurrentProfit");
		if (profits.length > row)
		    return profits[row].getName();
		break;

	    case 1://profits amount
		if ( rows == row){
		    long total = 0;
		    for (int i=0;i<profits.length;i++)
			total += profits[i].getMoney();
		    return NF.format(total);
		}
		if ( (rows+1) == row) {
		    long total = 0;
		    for (int i=0;i<profits.length;i++)
			total += profits[i].getMoney();
		    for (int i=0;i<expenses.length;i++)
			total -= expenses[i].getMoney();
		    return NF.format(total);
		}
		if (row < profits.length )
		    return NF.format(profits[row].getMoney());
		return "";
		
	    case 2://expense name
		if ( rows == row)
		    return SystemUtil.getResourceString("Total");
		if (expenses.length > row)
		    return expenses[row].getName();
		break;
		
	    case 3://expense init
		if ( rows == row){
		    long total = 0;
		    for (int i=0;i<expenses.length;i++)
			total += expenses[i].getMoney();
		    return NF.format(total);
		}
		if (expenses.length > row) {
		    return NF.format(expenses[row].getMoney());
		}
		break;
	    default:
	    }
	    return "";
	}   
    }
    
    public TGroupProfitLoss(SystemInfo info,int year) {
	this.info = info;
	this.year = year;
	setModel(initModel());
    }

    int year;
    int getYear() {return year;}
    void setYear(int y) {
	year = y;
	update();
    }

    protected AbstractTableModel initModel() {
	return new PLModel();
    }
    
    public int [] getChops() {
	int [] lengthes = {12,16,12,16};
	return lengthes;
    }

    public String [] getAligns() {
	String [] aligns = {"c","r","c","r"};
	return aligns;
    }

    public String getTitle() {
	Object [] args = {
	    SystemUtil.getResourceString("ConsolidatedAccounts"),
	    new Integer(getYear())};
	String titleString =
	    MessageFormat.format(
		SystemUtil.getResourceString("SheetTitleLite"),args);
	return titleString;
    }

    public void print() {
	LineListener liner = new LineListener() {
		public int getColumnLine(TableModel model,int col) {
		    return 1;
		}
		public int getRowLine(TableModel model,int row) {
		    if ( (model.getRowCount()-3) == row )
			return 1;
		    return 0;
		}
		public boolean isStrong(TableModel model,int r,int c) {
		    return false;
		}
	    };
	String [] aligns = getAligns();
	int [] lengthes = getChops();
	TablePrinter printer = new TablePrinter(
	    getTitle(),this,aligns,lengthes,liner);
	printer.print();
    }
    
}

