/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.awt.print.*;
import java.util.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.print.*;
import arg.money.SecurityManager;


public class TProfitLoss extends TAbstractProject {
    
    AbstractTableElement [] profits;
    AbstractTableElement [] expenses;
    
    class PLModel extends AbstractTableModel {
	int rows;
	PLModel() {
	    Map profitsMap = new HashMap();
	    Map expenseMap = new HashMap();
	    Iterator it = project.getSubjects().iterator();
	    int pcount=0,ecount=0;
	    while(it.hasNext()) {
		Subject s = (Subject)it.next();
		SubjectGroup sg = project.getGroupBySubject(s.getId());
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		List list = null;
		switch(sg.getBalanceGroup()) {
		case SubjectGroup.PROFIT:
		    list = (List)profitsMap.get(ssg);
		    if (list == null) {
			list = new LinkedList();
			profitsMap.put(ssg,list);
			pcount++;
		    }
		    list.add(s);
		    pcount++;
		    break;
		case SubjectGroup.EXPENSE:
		    list = (List)expenseMap.get(ssg);
		    if (list == null) {
			list = new LinkedList();
			expenseMap.put(ssg,list);
			ecount++;
		    }
		    list.add(s);
		    ecount++;
		    break;
		default:
		}
	    }
	    profits = new AbstractTableElement[pcount];
	    it = getIterator(profitsMap);
	    pcount=0;
	    while(it.hasNext()) {
		List list = (List)it.next();
		Iterator it2 = list.iterator();
		Subject s = (Subject)list.get(0);
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		profits[pcount++] = new SpElement(ssg.getName());
		while(it2.hasNext()) {
		    Subject sb = (Subject)it2.next();
		    profits[pcount++] = new TableElement(sb);
		}
	    }
	    expenses = new AbstractTableElement[ecount];
	    it = getIterator(expenseMap);
	    ecount=0;
	    while(it.hasNext()) {
		List list = (List)it.next();
		Iterator it2 = list.iterator();
		Subject s = (Subject)list.get(0);
		SubjectSubgroup ssg = project.getSubgroupBySubject(s.getId());
		expenses[ecount++] = new SpElement(ssg.getName());
		while(it2.hasNext()) {
		    Subject sb = (Subject)it2.next();
		    expenses[ecount++] = new TableElement(sb);
		}
	    }
	    rows = Math.max(profits.length+1,expenses.length+1);
	}

	String [] columns = {SystemUtil.getResourceString("Profit"),
			    SystemUtil.getResourceString("Amount"),
			    SystemUtil.getResourceString("Expense"),
			    SystemUtil.getResourceString("Amount")
	};
	public Class getColumnClass(int c) {
	    if (c >= 0 && c <= 3) return "".getClass();
	    return super.getColumnClass(c);
	}
	public String getColumnName(int i) {
	    return columns[i];
	}
	public int getColumnCount() {
	    //yoko
	    return 4;
	}
	public int getRowCount() {
	    //tate
	    return rows+1;
	}
	public Object getValueAt(int row, int col) {
	    switch(col) {
	    case 0://profits name
		if ( (rows-1) == row)
		     return SystemUtil.getResourceString("Total");
		if ( rows == row)
		     return SystemUtil.getResourceString("CurrentProfit");
		if (profits.length > row)
		    return profits[row].getName();
		break;

	    case 1://profits amount
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<profits.length;i++)
			total += profits[i].getMoney();
		    return NF.format(total);
		}
		if ( rows == row) {
		    long total = 0;
		    for (int i=0;i<profits.length;i++)
			total += profits[i].getMoney();
		    for (int i=0;i<expenses.length;i++)
			total -= expenses[i].getMoney();
		    return NF.format(total);
		}
		if (profits.length > row) {
		    if (profits[row] instanceof SpElement)
			return "";
		    return NF.format(profits[row].getMoney());
		}
		break;
		
	    case 2://expense name
		if ( (rows-1) == row)
		    return SystemUtil.getResourceString("Total");
		if (expenses.length > row)
		    return expenses[row].getName();
		break;
		
	    case 3://expense init
		if ( (rows-1) == row){
		    long total = 0;
		    for (int i=0;i<expenses.length;i++)
			total += expenses[i].getMoney();
		    return NF.format(total);
		}
		if (expenses.length > row) {
		    if (expenses[row] instanceof SpElement)
			return "";
		    return NF.format(expenses[row].getMoney());
		}
		break;
		
	    default:
	    }
	    return "";
	}   
    }
    
    public TProfitLoss(ProjectData pd,SlipManager sm,int y) {
	super(pd,sm,y,SystemUtil.getResourceString("ProfitLossTable"));
	setDefaultRenderer("".getClass(),new MyCellRender(this));
    }

    protected AbstractTableModel initModel() {
	AbstractTableModel model = new PLModel();
	return model;
    }
    
    public int [] getChops() {
	int [] lengthes = {12,16,12,16};
	return lengthes;
    }

    public String [] getAligns() {
	String [] aligns = {"c","r","c","r"};
	return aligns;
    }

    public void print() {
	LineListener liner = new LineListener() {
		public int getColumnLine(TableModel model,int col) {
		    return 1;
		}
		public int getRowLine(TableModel model,int row) {
		    if ( (model.getRowCount()-3) == row )
			return 1;
		    return 0;
		}
		public boolean isStrong(TableModel model,int r,int c) {
		    return isStrongCell(r,c);
		}
	    };
	String [] aligns = getAligns();
	int [] lengthes = getChops();
	TablePrinter printer = new TablePrinter(
	    getTitle(),this,aligns,lengthes,liner);
	printer.print();
    }

    public boolean isStrongCell(int row,int col) {
	boolean ht = false;
	try {
	    switch(col) {
	    case 0://profits name
	    case 1:
		if (profits.length > row) 
		    if (profits[row] instanceof SpElement)
			ht = true;
		break;
		
	    case 2://expense name
	    case 3:
		if (expenses.length > row) 
		    if (expenses[row] instanceof SpElement)
			ht = true;
		break;
		
	    default:
	    }
	} catch(RuntimeException e) {}
	return ht;
    }

}

