/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.*;
import java.util.*;
import java.awt.print.*;
import java.util.List;
import jp.gr.java_conf.ccs2.comp.swing.*;
import arg.money.*;
import arg.money.SecurityManager;


public class TSlips extends JTable implements CellManager {
    
    protected NumberFormat NF = NumberFormat.getInstance();

    protected ProjectData project;
    protected ProjectManager projectManager;
    protected SlipManager manager;
    protected UserManager userManager;
    protected SlipLineModel model;
    protected long [] amounts = {0,0};
    protected int leftFilter=-1,rightFilter=-1;

    public String [] titles = {
	SystemUtil.getResourceString("Date"),
	SystemUtil.getResourceString("ReceiptNo"),
	SystemUtil.getResourceString("User"),
	SystemUtil.getResourceString("SubjectName"),
	SystemUtil.getResourceString("Credit"),
	SystemUtil.getResourceString("Summary"),
	SystemUtil.getResourceString("Debtor"),
	SystemUtil.getResourceString("SubjectName")
    };

    public String [] aligns = {"c","c","c","c","r","c","r","c"};
    public int [] lengthes = {12,5,8,6,12,10,12,6};

    /** table model */
    class SlipLineModel extends AbstractTableModel {
        List curSlips;
        Subject subject;
        List elements;

        SlipLineModel(List ss) {
	    curSlips = ss;
            // make element list
            elements = new ArrayList();
            Iterator it = curSlips.iterator();
	    //Slip loop
            while(it.hasNext()) {
                TransferSlip ts = (TransferSlip)it.next();
		Iterator its = ts.getLines().iterator();
		if (its != null) 
		    //line loop (left)
		    while(its.hasNext()) {
			ASlipLine line = (ASlipLine)its.next();
			boolean select = true;
			if (leftFilter != -1)
			    if (line.getLeft().getId() != leftFilter)
				select = false;
			if (rightFilter != -1)
			    if (line.getRight().getId() != rightFilter)
				select = false;
			if (select) {
			    long am = Math.min(line.getLeft().getMoney(),
					       line.getRight().getMoney());
			    amounts[0] += am;
			    amounts[1] += am;
			    elements.add(line);
			}
		    }
            }
        }
        TransferSlip getSlip(int ps) {
            if (ps >= 0 && ps <elements.size()) {
                ASlipLine e = (ASlipLine)elements.get(ps);
                return e.getParent();
            }
            return null;
        }
	public Class getColumnClass(int c) {
	    if (c >= 0 && c <= 7) return "".getClass();
	    return super.getColumnClass(c);
	}
        public int getColumnCount() {
            return titles.length;
        }
        public int getRowCount() {
            return elements.size();
        }
        public String getColumnName(int i) {
            return titles[i];
        }
        public Object getValueAt(int row, int col) {
            ASlipLine se = (ASlipLine)elements.get(row);
            switch(col) {
	    case 0://date
                return jp.gr.java_conf.ccs2.util.StringUtil.datel(se.getParent().getDate());
	    case 1://receipt
                return Integer.toString(se.getParent().getReceiptNumber());
	    case 2://user
                return userManager.getUser(se.getParent().getUid()).getName();
	    case 3://credit subject
                return project.getSubject(se.getLeft().getId()).getName();
	    case 4://credit amount
	    case 6://debit amount
		SlipElement right = se.getRight();
		SlipElement left = se.getLeft();
		long lamount = left.getMoney();
		long ramount = right.getMoney();
		return NF.format( Math.min(lamount,ramount) );
	    case 5://summary
		return se.getSummary();
	    case 7://debit subject
                return project.getSubject(se.getRight().getId()).getName();
	    default:
            }
            return null;
        }

    }

    public TSlips(SlipManager sm,int pid,List slips) {
	super();
	manager = sm;
	projectManager = manager.getParent().getProjectManager();
	project = projectManager.getProjectData(pid);
	userManager = sm.getParent().getSecurityManager().getUserManager();
	if (slips == null) {
	    slips = manager.getList(manager.query(project.getCurYear(),project.getId()));
	}
	setDefaultRenderer("".getClass(),new MyCellRender(this,aligns));
	setSlips(slips,pid,-1,-1);
    }

    public void setSlips(List slips,int pid,int lf,int rf) {
	this.slips = slips;
	this.project = projectManager.getProjectData(pid);
	this.leftFilter = lf;
	this.rightFilter = rf;
	amounts[0] = 0;
	amounts[1] = 0;
	initModel();
    }

    public long [] getAmounts() {return amounts;}
    public ASlipLine getLine(int ps) {
	try {
	    return ((ASlipLine)model.elements.get(ps));
	} catch (RuntimeException e) {
	    e.printStackTrace();
	}
	return null;
    }

    public List getSlips() {
	return slips;
    }

    List slips;

    void initModel() {
	model = new SlipLineModel(slips);
	setModel(model);
    }

    void update() {
	tableChanged(new TableModelEvent(model));
    }

    public AbstractTableModel getMyModel() {return model;}
    public boolean isStrongCell(int row,int col) {
	try {
	    return getLine(row).getParent().isLocked();
	}catch(RuntimeException e) {
	    e.printStackTrace();
	}
	return false;
    }
}
