/* Arg office software 
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package arg.money.print;
import arg.money.*;
import jp.gr.java_conf.ccs2.io.*;
import jp.gr.java_conf.ccs2.core.*;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.io.*;


public class TablePrinter {

    JTable table;
    int maxRows = 43;
    int [] lengthes;
    String [] aligns;
    LineListener liner;

    HashMap hash = new HashMap();
    public String getString(String key) {
	return (String)hash.get(key);
    }
    void init() {
	hash.put("pageBegin","\\documentclass[9pt]{jarticle} \\topmargin=-0.8in \\oddsidemargin=-0.3in \\evensidemargin=-0.3in \\textheight47\\baselineskip \\textwidth 50zw \\def\\Hline{\\noalign{\\hrule height1pt}}");
	hash.put("titleBegin","\\title{");
	hash.put("titleEnd","}");
	hash.put("docBegin","\\begin{document} \\maketitle \\begin{center}");
	hash.put("docEnd","\\end{center} \\end{document}");
	hash.put("pageEnd","");
	StringBuffer sb = new StringBuffer();
	for (int i=0;i<aligns.length;i++) {
	    sb.append(aligns[i]);
	    int ps = liner.getColumnLine(table.getModel(),i);
	    if (ps > 0) 
		for (int j=0;j<ps;j++)
		    sb.append("|");
	}
	String gen = "\\begin{tabular}{|"+sb.toString()+"} \\hline";
	hash.put("tableBegin",gen);
	hash.put("tableEnd","\\end{tabular}");
	hash.put("tableReturn","\\\\");
	hash.put("hline","\\hline");
	hash.put("Hline","\\Hline");
	hash.put("Dline","\\hline\\hline");
	hash.put("bfBegin","\\bf{");
	hash.put("bfEnd","}");
	hash.put("newpage","\\newpage");
    }
    
    public TablePrinter(String title,JTable table,String [] aligns,
			int [] lengthes) {
	this(title,table,aligns,lengthes,null);
    }
    public TablePrinter(String title,JTable table,String [] aligns,
			int [] lengthes,LineListener liner) {
	this.table = table;
	this.title = title;
	if (aligns == null) {
	    TableModel model = table.getModel();
	    int nc = model.getColumnCount();
	    aligns = new String[nc];
	    for (int i=0;i<nc;i++)
		aligns[i] = "l";
	}
	this.aligns = aligns;
	if (lengthes == null) {
	    TableModel model = table.getModel();
	    int nc = model.getColumnCount();
	    lengthes = new int[nc];
	    for (int i=0;i<nc;i++)
		lengthes[i] = 12;
	}
	this.lengthes = lengthes;
	if (liner == null) {
	    liner = new LineListener() {
		    public int getColumnLine(TableModel model,int col) {
			return 1;
		    }
		    public int getRowLine(TableModel model,int row) {
			if ( (row % 5) == 4 )
			    return 1;
			return 0;
		    }
		    public boolean isStrong(TableModel model,int r,int c) {
			return false;
		    }
		};
	}
	this.liner = liner;
	init();
    }
    String title;

    public void print() {
	EasyWriter out = new EasyWriter("temp.tex");
	out.println(getString("pageBegin"));

	//title
	out.println(getString("titleBegin"));
	out.println(title);
	out.println(getString("titleEnd"));

	out.println(getString("docBegin"));

	int curRow = 0;
	while (curRow >= 0) {//page loop
	    if (curRow != 0) out.println(getString("newpage"));
	    curRow = outputPage(out,table,curRow);
	}

	out.println(getString("docEnd"));
	out.println(getString("pageEnd"));
	out.close();
	
	System.gc();
    }


    private int outputPage(EasyWriter out,JTable table,int curRow) {
	out.println(getString("tableBegin"));

	TableColumnModel colModel = table.getColumnModel();
	TableModel model = table.getModel();
	int nColumns = colModel.getColumnCount();

	for (int nCol=0; nCol<nColumns; nCol++) {
	    if (nCol != 0) out.print(" & ");
	    TableColumn tk = colModel.getColumn(nCol);
	    String t = (String)tk.getIdentifier();
	    out.print(getString("bfBegin"));
	    out.print(t);
	    out.print(getString("bfEnd"));
	}
	out.println(getString("tableReturn"));
	    
	out.println(getString("Dline"));
	
	int rowLimit = maxRows;

	if (curRow == 0)
	    rowLimit -= 10;//FIRST PAGE

	int tempRow = curRow;
	for (int i=curRow; i<model.getRowCount() && (i-curRow) < rowLimit; i++) {
	    for (int j=0; j<model.getColumnCount(); j++) {
		if (j != 0) out.print(" & ");
		Object obj = model.getValueAt(i,j);
		if (obj == null) obj = new String("");
		if (liner.isStrong(model,i,j))
		    out.print(getString("bfBegin"));
		out.print( chop( obj.toString(),j ) );
		if (liner.isStrong(model,i,j))
		    out.print(getString("bfEnd"));
	    }
	    out.println(getString("tableReturn"));
	    int ps = liner.getRowLine(model,i);
	    if (ps > 0) {
		for (int j=0;j<ps;j++)
		    out.println(getString("hline"));
	    } else if (ps < 0) {
		out.println(getString("Hline"));
	    }
	       
	    tempRow++;
	}
	if (tempRow >= model.getRowCount()) tempRow = -1;
	out.println(getString("hline"));
	out.println(getString("tableEnd"));
	return tempRow;
    }

    private String chop(String a,int col) {
	if (a.length() > lengthes[col]) {
	    return a.substring(0,lengthes[col])+"...";
	}
	return a;
    }
	
	//
	//execute command
	/*
	Process process=null;
	String line ="",eline="";
	String dir = System.getProperty("user.dir");
	String com = dir+"\\print.bat";
	System.out.println(com);
	try {
	    process = Runtime.getRuntime().exec(com);
	}catch(IOException e) {
	    System.err.println("IOException in command execution "+
			       e.getMessage());
	    return;
	}
	
	BufferedReader in = new BufferedReader(
	    new InputStreamReader(process.getInputStream()));
	
	BufferedReader ein = new BufferedReader(
	    new InputStreamReader(process.getErrorStream()));
	
	try {
	outer:
	    while(true) {
		while(in.ready()) {
		    line = in.readLine();
		    eline = ein.readLine();
		    if (line == null && eline == null) break outer;
		    if (line!=null)
			System.out.println(line);
		    if (eline != null)
			System.out.println(eline);
		}
		try {
		    int q = process.exitValue();
		    System.out.println(
			"command exited with the code ("+q+")...");
		    break;
		} catch(IllegalThreadStateException e) {
		}
	    }
	} catch(IOException e) {
	    System.err.println("IOException in invokeCommand().");
	}

	process.destroy();
	*/

}
