/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.awt.event.*;


/** Abstract Dialog class.
  * This class provides easy building and common frame work.
  */

abstract public class AbstractDialog extends Dialog {

    protected boolean success = false;
    protected Button okButton;

    protected String sok="OK";
    protected String scancel="CANCEL";

    public static int Style_OK = 1;
    public static int Style_OKCANCEL = 2;

    //=====================
    // constructor
    //=====================

    /** dialog style is set Style_OK
      * @param parent      paren frame
      * @param windowTitle window title
      * 
      */
    public AbstractDialog(Frame parent,String windowTitle) {
	this(parent,windowTitle,Style_OK);
    }

    /**
      * @param parent      paren frame
      * @param windowTitle window title
      * @param style dialog style [Style_OK|Style_OKCANCEL]
      */
    public AbstractDialog(Frame parent,String windowTitle,int style) {
	super(parent,windowTitle,true);
	//
	Panel p = init();
	add(p,"Center");
	p = new Panel();
	Button b = new Button(sok);
	b.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		onOkRoot();
	    }
	});
	p.add(b);
	okButton = b;
	if (style == Style_OKCANCEL) {
	    b = new Button(scancel);
	    b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    onCancel();
		}
	    });
	    p.add(b);
	}
	add(p,"South");
	pack();
    }

    //=====================
    // operation
    //=====================

    /** Invoke dialog */
    public boolean doModal() {
	show();
	return success;
    }

    //=====================
    // over ride
    //=====================

    /** This method builds Dialog components.
      * you make a new panel and  put some components on it.
      */
    abstract protected Panel init();

    /** get some data from component */
    protected void onOk() {
    }

    //=====================
    // private area
    //=====================

    /** ok button state */
    protected void enableOk(boolean t) {
	okButton.setEnabled(t);
    }
    
    /** When "OK" button is pushed, this method would be called.
      * You can over-ride this method to do something.
      */
    protected void onOkRoot(){
	onOk();
	success = true;
	dispose();
    }
    
    /** When "CANCEL" button is pushed, this method would be called.
      * You can over-ride this method to do something.
      */
    protected void onCancel(){
	success = false;
	dispose();
    }
    
}
